/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.stream;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.ptp.remotetools.utils.messages.Messages;
import org.eclipse.ptp.remotetools.utils.stream.ILineStreamListener;

public class TextStreamObserver
extends Thread {
    private BufferedReader reader;
    private boolean killed;
    private String name;
    private ILineStreamListener listener;

    public TextStreamObserver(InputStream input, ILineStreamListener listener, String name) {
        this.name = name;
        this.reader = new BufferedReader(new InputStreamReader(input));
        this.listener = listener;
        this.setName(name);
    }

    public TextStreamObserver(InputStream input, ILineStreamListener listener) {
        this.name = this.getClass().getName();
        this.reader = new BufferedReader(new InputStreamReader(input));
        this.listener = listener;
        this.setName(this.name);
    }

    public synchronized void kill() {
        this.killed = true;
    }

    void log(String string) {
    }

    void newLine(String line) {
        this.log(String.valueOf(Messages.TextStreamObserver_0) + Integer.toString(line.length()) + Messages.TextStreamObserver_1);
        this.listener.newLine(line);
    }

    void streamClosed() {
        this.log(Messages.TextStreamObserver_2);
        this.listener.streamClosed();
    }

    void streamError(Exception e) {
        this.log(String.valueOf(Messages.TextStreamObserver_3) + e.getMessage());
        this.listener.streamError(e);
    }

    @Override
    public void run() {
        while (!this.killed) {
            try {
                String line = this.reader.readLine();
                if (line == null) {
                    this.streamClosed();
                    return;
                }
                this.newLine(line);
            }
            catch (IOException e) {
                if (e instanceof EOFException) {
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
                break;
            }
            catch (NullPointerException e) {
                if (this.killed) {
                    this.streamClosed();
                    break;
                }
                this.streamError(e);
                break;
            }
        }
    }
}

