/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.wizards;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.ptp.internal.services.ui.messages.Messages;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.ui.IServiceContributor;
import org.eclipse.ptp.services.ui.ServiceModelUIManager;
import org.eclipse.ptp.services.ui.widgets.ServiceModelWidget;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ServiceConfigurationWizard
extends Wizard
implements INewWizard {
    private final IServiceConfiguration fServiceConfiguration;
    private IWorkbench fWorkbench = null;
    private IStructuredSelection fSelection = null;

    public ServiceConfigurationWizard(IServiceConfiguration serviceConfiguration) {
        this.setForcePreviousAndNextButtons(true);
        this.fServiceConfiguration = serviceConfiguration;
    }

    public void addPages() {
        this.setWizardPages(this.getWizardPagesFromServiceConfiguration(this.fServiceConfiguration));
        this.addPage((IWizardPage)new ServicesPage(Messages.ServiceConfigurationWizard_1));
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public IServiceConfiguration getServiceConfiguration() {
        return this.fServiceConfiguration;
    }

    public IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.fSelection = selection;
    }

    public boolean performFinish() {
        return true;
    }

    private WizardPage[] getWizardPagesFromServiceConfiguration(IServiceConfiguration serviceConfiguration) {
        ArrayList<WizardPage> wizardPages = new ArrayList<WizardPage>();
        for (IService service : serviceConfiguration.getServicesByPriority()) {
            WizardPage[] pages;
            IServiceContributor contrib = ServiceModelUIManager.getInstance().getServiceContributor(service);
            if (contrib == null) continue;
            WizardPage[] wizardPageArray = pages = contrib.getWizardPages(service);
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                WizardPage page = wizardPageArray[n2];
                wizardPages.add(page);
                ++n2;
            }
        }
        return wizardPages.toArray(new WizardPage[wizardPages.size()]);
    }

    private void setWizardPages(WizardPage[] pages) {
        WizardPage[] wizardPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            WizardPage page = wizardPageArray[n2];
            this.addPage((IWizardPage)page);
            ++n2;
        }
    }

    private class ServicesPage
    extends WizardSelectionPage {
        public ServicesPage(String pageName) {
            super(pageName);
            this.setTitle(pageName);
            this.setDescription(Messages.ServiceConfigurationWizard_0);
        }

        public void createControl(Composite parent) {
            this.setControl(new ServiceModelWidget(ServiceConfigurationWizard.this.fServiceConfiguration).createContents(parent));
            INewWizard wizard = (INewWizard)ServiceModelUIManager.getInstance().getWizardExtensions();
            if (wizard != null) {
                wizard.init(ServiceConfigurationWizard.this.getWorkbench(), ServiceConfigurationWizard.this.getSelection());
                wizard.addPages();
                this.setSelectedNode(new WizardExtensionNode((IWizard)wizard));
            }
        }

        private class WizardExtensionNode
        implements IWizardNode {
            private IWizard fWizard = null;

            public WizardExtensionNode(IWizard wizard) {
                this.fWizard = wizard;
            }

            public void dispose() {
            }

            public Point getExtent() {
                return new Point(-1, -1);
            }

            public IWizard getWizard() {
                return this.fWizard;
            }

            public boolean isContentCreated() {
                return this.fWizard != null;
            }
        }
    }
}

