/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.e4.ui.internal.workbench.ExtensionPointProxy;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenuItem;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderedMenuItemRenderer
extends SWTPartRenderer {
    private static Method aboutToShow;
    private Map<IContributionItem, List<MenuRecord>> map = new WeakHashMap<IContributionItem, List<MenuRecord>>();

    private static Method getAboutToShow() {
        if (aboutToShow == null) {
            try {
                aboutToShow = MenuManager.class.getDeclaredMethod("handleAboutToShow", new Class[0]);
                aboutToShow.setAccessible(true);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return aboutToShow;
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MRenderedMenuItem) || !(parent instanceof Menu)) {
            return null;
        }
        MRenderedMenuItem menuModel = (MRenderedMenuItem)element;
        Object contribution = menuModel.getContributionItem();
        if (contribution instanceof ExtensionPointProxy) {
            ExtensionPointProxy proxy = (ExtensionPointProxy)contribution;
            Object delegate = proxy.createDelegate((MApplicationElement)menuModel);
            if (delegate != null) {
                proxy.setField("dirty", (Object)Boolean.TRUE);
                return this.fill((IContributionItem)delegate, (Menu)parent);
            }
        } else if (contribution instanceof IContributionItem) {
            return this.fill((IContributionItem)contribution, (Menu)parent);
        }
        return null;
    }

    private Object fill(IContributionItem item, Menu menu) {
        MenuRecord record;
        ContributionItem contribution = (ContributionItem)item;
        MenuManager manager = (MenuManager)contribution.getParent();
        try {
            if (manager == null) {
                manager = new MenuManager();
                manager.add((IContributionItem)contribution);
            }
            RenderedMenuItemRenderer.getAboutToShow().invoke((Object)manager, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        int itemCount = menu.getItemCount();
        List<MenuRecord> list = this.map.get(item);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                record = list.get(i);
                Menu storedMenu = record.getMenu();
                if (storedMenu.isDisposed()) {
                    list.remove(i);
                    --i;
                } else if (storedMenu == menu) {
                    record.dispose();
                    itemCount = menu.getItemCount();
                    list.remove(i);
                    break;
                }
                ++i;
            }
        }
        item.fill(menu, itemCount);
        int endIndex = menu.getItemCount();
        if (list == null) {
            if (itemCount != endIndex) {
                list = new ArrayList<MenuRecord>();
                record = new MenuRecord(menu);
                int i = itemCount;
                while (i < endIndex) {
                    record.addItem(menu.getItem(i));
                    ++i;
                }
                list.add(record);
                this.map.put(item, list);
            }
        } else {
            int i = 0;
            while (i < list.size()) {
                MenuRecord record2 = list.get(i);
                if (record2.getMenu() == menu) {
                    list.remove(i);
                    record2 = new MenuRecord(menu);
                    int j = itemCount;
                    while (j < endIndex) {
                        record2.addItem(menu.getItem(j));
                        ++j;
                    }
                    list.add(record2);
                    return null;
                }
                ++i;
            }
            MenuRecord record3 = new MenuRecord(menu);
            int i2 = itemCount;
            while (i2 < endIndex) {
                record3.addItem(menu.getItem(i2));
                ++i2;
            }
            list.add(record3);
            this.map.put(item, list);
        }
        return null;
    }

    @Override
    public Object unbindWidget(MUIElement me) {
        MRenderedMenuItem item = (MRenderedMenuItem)me;
        Object contributionItem = item.getContributionItem();
        if (contributionItem instanceof ExtensionPointProxy) {
            ExtensionPointProxy proxy = (ExtensionPointProxy)contributionItem;
            Object delegate = proxy.getDelegate();
            if (delegate instanceof IContributionItem) {
                ((IContributionItem)delegate).dispose();
            }
        } else if (contributionItem instanceof IContributionItem) {
            ((IContributionItem)contributionItem).dispose();
        }
        return super.unbindWidget(me);
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    public Object getUIContainer(MUIElement element) {
        if (!(element instanceof MMenuElement)) {
            return null;
        }
        if (element.getParent().getWidget() instanceof MenuItem) {
            MenuItem mi = (MenuItem)element.getParent().getWidget();
            if (mi.getMenu() == null) {
                mi.setMenu(new Menu(mi));
            }
            return mi.getMenu();
        }
        return super.getUIContainer(element);
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
    }

    class MenuRecord {
        private Menu menu;
        private List<MenuItem> items = new ArrayList<MenuItem>();

        public MenuRecord(Menu menu) {
            this.menu = menu;
        }

        public Menu getMenu() {
            return this.menu;
        }

        public void addItem(MenuItem item) {
            this.items.add(item);
        }

        public void dispose() {
            for (MenuItem item : this.items) {
                item.dispose();
            }
        }
    }
}

