/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.rdt.ui.wizards.RemoteProjectContentsLocationArea;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class NewRemoteProjectCreationPage
extends WizardNewProjectCreationPage {
    private String initialProjectFieldValue;
    private Text projectNameField;
    private final Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            NewRemoteProjectCreationPage.this.setLocationForSelection();
            boolean valid = NewRemoteProjectCreationPage.this.validatePage();
            NewRemoteProjectCreationPage.this.setPageComplete(valid);
        }
    };
    private RemoteProjectContentsLocationArea locationArea;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public NewRemoteProjectCreationPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    @Deprecated
    public NewRemoteProjectCreationPage(String pageName, IStructuredSelection selection, String[] workingSetTypes) {
        this(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.locationArea = new RemoteProjectContentsLocationArea(this.getErrorReporter(), composite, null);
        if (this.initialProjectFieldValue != null) {
            this.locationArea.updateProjectName(this.initialProjectFieldValue);
        }
        Button[] buttonArray = this.locationArea.getButtons();
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            this.setButtonLayoutData(button);
            ++n2;
        }
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private RemoteProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return new RemoteProjectContentsLocationArea.IErrorMessageReporter(){

            @Override
            public void reportError(String errorMessage, boolean infoOnly) {
                boolean valid;
                if (infoOnly) {
                    NewRemoteProjectCreationPage.this.setMessage(errorMessage, 1);
                    NewRemoteProjectCreationPage.this.setErrorMessage(null);
                } else {
                    NewRemoteProjectCreationPage.this.setErrorMessage(errorMessage);
                }
                boolean bl = valid = errorMessage == null;
                if (valid) {
                    valid = NewRemoteProjectCreationPage.this.validatePage();
                }
                NewRemoteProjectCreationPage.this.setPageComplete(valid);
            }
        };
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(IDEWorkbenchMessages.WizardNewProjectCreationPage_nameLabel);
        projectLabel.setFont(parent.getFont());
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    public IPath getLocationPath() {
        return new Path(this.locationArea.getProjectLocation());
    }

    public URI getLocationURI() {
        return this.locationArea.getProjectLocationURI();
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    public IRemoteConnection getRemoteConnection() {
        return this.locationArea.getRemoteConnection();
    }

    public IRemoteServices getRemoteServices() {
        return this.locationArea.getRemoteServices();
    }

    public void setInitialProjectName(String name) {
        if (name == null) {
            this.initialProjectFieldValue = null;
        } else {
            this.initialProjectFieldValue = name.trim();
            if (this.locationArea != null) {
                this.locationArea.updateProjectName(name.trim());
            }
        }
    }

    private void setLocationForSelection() {
        this.locationArea.updateProjectName(this.getProjectNameFieldValue());
    }

    protected boolean validatePage() {
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectNameEmpty);
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectExistsMessage);
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectNameFieldValue());
        this.locationArea.setExistingProject(project);
        String validLocationMessage = this.locationArea.checkValidLocation();
        if (validLocationMessage != null) {
            this.setErrorMessage(validLocationMessage);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        this.getControl().setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public boolean useDefaults() {
        return this.locationArea.isDefault();
    }
}

