/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.param;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.codan.core.param.AbstractProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceCompositeDescriptor;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceCompositeValue;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceDescriptor;

public class MapProblemPreference
extends AbstractProblemPreference
implements IProblemPreferenceCompositeValue,
IProblemPreferenceCompositeDescriptor {
    protected LinkedHashMap<String, IProblemPreference> hash = new LinkedHashMap();

    public MapProblemPreference() {
    }

    public MapProblemPreference(String key, String label) {
        this.setKey(key);
        this.setLabel(label);
    }

    @Override
    public IProblemPreferenceDescriptor.PreferenceType getType() {
        return IProblemPreferenceDescriptor.PreferenceType.TYPE_MAP;
    }

    @Override
    public IProblemPreference getChildDescriptor(String key) {
        return this.hash.get(key);
    }

    @Override
    public IProblemPreference addChildDescriptor(IProblemPreference desc) {
        ((AbstractProblemPreference)desc).setParent(this);
        this.hash.put(desc.getKey(), desc);
        return desc;
    }

    @Override
    public IProblemPreference[] getChildDescriptors() {
        return this.hash.values().toArray(new IProblemPreference[this.hash.values().size()]);
    }

    @Override
    public Object getChildValue(String key) {
        IProblemPreference childInfo = this.getChildDescriptor(key);
        return childInfo.getValue();
    }

    @Override
    public void setChildValue(String key, Object value) {
        IProblemPreference pref = this.getChildDescriptor(key);
        if (pref == null) {
            throw new IllegalArgumentException("Preference for " + key + " must exists before setting its value");
        }
        pref.setValue(value);
        this.hash.put(key, pref);
    }

    @Override
    public void removeChildValue(String key) {
        this.hash.remove(key);
    }

    @Override
    public Object clone() {
        MapProblemPreference map = (MapProblemPreference)super.clone();
        map.hash = new LinkedHashMap();
        for (String key : this.hash.keySet()) {
            map.hash.put(key, (IProblemPreference)this.hash.get(key).clone());
        }
        return map;
    }

    @Override
    public String exportValue() {
        StringBuffer buf = new StringBuffer("{");
        Iterator<String> iterator = this.hash.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            IProblemPreference d = this.hash.get(key);
            if (d instanceof AbstractProblemPreference && ((AbstractProblemPreference)d).isDefault()) continue;
            buf.append(String.valueOf(key) + "=>" + d.exportValue());
            if (!iterator.hasNext()) continue;
            buf.append(",");
        }
        return String.valueOf(buf.toString()) + "}";
    }

    @Override
    public void importValue(String str) {
        StreamTokenizer tokenizer = this.getImportTokenizer(str);
        try {
            this.importValue(tokenizer);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(str) + ":" + e.toString(), e);
        }
    }

    @Override
    public void importValue(StreamTokenizer tokenizer) {
        try {
            int token = tokenizer.nextToken();
            if (token != 123) {
                throw new IllegalArgumentException(String.valueOf((char)token));
            }
            while ((token = tokenizer.nextToken()) != 125) {
                String key = tokenizer.sval;
                token = tokenizer.nextToken();
                if (token != 61) {
                    throw new IllegalArgumentException(String.valueOf((char)token));
                }
                token = tokenizer.nextToken();
                if (token != 62) {
                    throw new IllegalArgumentException(String.valueOf((char)token));
                }
                this.importChildValue(key, tokenizer);
                token = tokenizer.nextToken();
                if (token == 125) break;
                if (token == 44) continue;
                throw new IllegalArgumentException(String.valueOf((char)token));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected IProblemPreference importChildValue(String key, StreamTokenizer tokenizer) throws IOException {
        IProblemPreference desc = this.getChildDescriptor(key);
        if (desc != null && desc instanceof AbstractProblemPreference) {
            ((AbstractProblemPreference)desc).importValue(tokenizer);
            this.setChildValue(key, desc.getValue());
        }
        return desc;
    }

    @Override
    public void removeChildDescriptor(IProblemPreference info) {
        this.hash.remove(info.getKey());
    }

    public int size() {
        return this.hash.size();
    }

    public void clear() {
        this.hash.clear();
    }

    public String toString() {
        return this.hash.values().toString();
    }

    @Override
    public Object getValue() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (IProblemPreference pref : this.hash.values()) {
            map.put(pref.getKey(), pref.getValue());
        }
        return map;
    }

    @Override
    public void setValue(Object value) {
        Map map = (Map)value;
        LinkedHashMap hash2 = (LinkedHashMap)this.hash.clone();
        this.hash.clear();
        for (String key : map.keySet()) {
            Object value2 = map.get(key);
            if (value2 instanceof IProblemPreference) {
                this.hash.put(key, (IProblemPreference)value2);
                continue;
            }
            IProblemPreference pref = (IProblemPreference)hash2.get(key);
            this.addChildDescriptor(pref);
            pref.setValue(value2);
            this.hash.put(key, pref);
        }
    }
}

