/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.filter;

import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.filter.FilterWizardPage;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.filter.MatchFilterWizardPage;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.filter.RangeFilterWizardPage;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.filter.SortFilterWizardPage;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.filter.UniqueFilterWizardPage;

public final class AvailableFilterTypes {
    private static final String[] filterNames = new String[]{Localization.getString("AvailableFilterTypes.MatchFilter"), Localization.getString("AvailableFilterTypes.RangeFilter"), Localization.getString("AvailableFilterTypes.SortFilter"), Localization.getString("AvailableFilterTypes.UniqueFilter")};
    private static final String[] filterDescriptions = new String[]{Localization.getString("AvailableFilterTypes.MatchFilterDescription"), Localization.getString("AvailableFilterTypes.RangeFilterDescription"), Localization.getString("AvailableFilterTypes.SortFilterDescription"), Localization.getString("AvailableFilterTypes.UniqueFilterDescription")};
    private static final FilterWizardPage[] filterWizards = new FilterWizardPage[]{new MatchFilterWizardPage(), new RangeFilterWizardPage(), new SortFilterWizardPage(), new UniqueFilterWizardPage()};
    public static final String[] filterIDs = new String[]{"org.eclipse.linuxtools.systemtap.graphingapi.core.filters.MatchFilter", "org.eclipse.linuxtools.systemtap.graphingapi.core.filters.RangeFilter", "org.eclipse.linuxtools.systemtap.graphingapi.core.filters.SortFilter", "org.eclipse.linuxtools.systemtap.graphingapi.core.filters.UniqueFilter"};

    public static FilterWizardPage getFilterWizardPage(String id) {
        FilterWizardPage page = null;
        int index = AvailableFilterTypes.getIndex(id);
        if (index >= 0 && index < filterWizards.length) {
            return filterWizards[index];
        }
        return page;
    }

    public static String getFilterName(String id) {
        int index = AvailableFilterTypes.getIndex(id);
        if (index >= 0) {
            return filterNames[index];
        }
        return null;
    }

    public static String getFilterDescription(String id) {
        int index = AvailableFilterTypes.getIndex(id);
        if (index >= 0) {
            return filterDescriptions[index];
        }
        return null;
    }

    private static int getIndex(String id) {
        int i = 0;
        while (i < filterIDs.length) {
            if (id.equals(filterIDs[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

