/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.GraphModel;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.SelectGraphAndSeriesWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SelectGraphAndSeriesWizardPage
extends WizardPage
implements Listener {
    private Button[] btnGraphs;
    private SelectGraphAndSeriesWizard wizard;
    private Text txtTitle;
    private Text txtKey;
    private Button btnKey;
    private Label lblKey;
    private Combo cboXItem;
    private Combo[] cboYItems;
    private Label[] lblYItems;
    private GraphModel model;
    private boolean edit;

    public SelectGraphAndSeriesWizardPage() {
        super("selectGraphAndSeries");
        this.setTitle(Localization.getString("SelectGraphAndSeriesWizardPage.SelectGraphAndSeries"));
    }

    public void createControl(Composite parent) {
        this.wizard = (SelectGraphAndSeriesWizard)this.getWizard();
        this.model = this.wizard.model;
        this.edit = this.wizard.isEditing();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Group cmpGraphOptsGraph = new Group(comp, 16);
        cmpGraphOptsGraph.setLayoutData((Object)new GridData(4, 4, true, false));
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        cmpGraphOptsGraph.setLayout((Layout)rowLayout);
        cmpGraphOptsGraph.setText(Localization.getString("SelectGraphAndSeriesWizardPage.Graph"));
        String[] graphIDs = GraphFactory.getAvailableGraphs(this.wizard.model.getDataSet());
        this.btnGraphs = new Button[graphIDs.length];
        int i = 0;
        while (i < this.btnGraphs.length) {
            this.btnGraphs[i] = new Button((Composite)cmpGraphOptsGraph, 16);
            this.btnGraphs[i].setImage(GraphFactory.getGraphImage(graphIDs[i]));
            this.btnGraphs[i].addListener(13, (Listener)this);
            this.btnGraphs[i].setData((Object)graphIDs[i]);
            this.btnGraphs[i].setToolTipText(String.valueOf(GraphFactory.getGraphName(this.btnGraphs[i].getData().toString())) + "\n\n" + GraphFactory.getGraphDescription(this.btnGraphs[i].getData().toString()));
            if (this.wizard.isEditing() && graphIDs[i].equals(this.wizard.model.getGraphID())) {
                this.btnGraphs[i].setSelection(true);
            }
            ++i;
        }
        Group cmpGraphOptsSeries = new Group(comp, 16);
        cmpGraphOptsSeries.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        cmpGraphOptsSeries.setLayout((Layout)layout);
        Label lblTitle = new Label((Composite)cmpGraphOptsSeries, 0);
        lblTitle.setLayoutData((Object)new GridData(4, 4, false, false));
        lblTitle.setText(Localization.getString("SelectGraphAndSeriesWizardPage.Title"));
        this.txtTitle = new Text((Composite)cmpGraphOptsSeries, 2048);
        this.txtTitle.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.edit) {
            this.txtTitle.setText(this.model.getGraphData().title);
        }
        this.txtTitle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectGraphAndSeriesWizardPage.this.getWizard().getContainer().updateButtons();
                if (SelectGraphAndSeriesWizardPage.this.txtTitle.getText().length() == 0) {
                    SelectGraphAndSeriesWizardPage.this.setErrorMessage(Localization.getString("SelectGraphAndSeriesWizardPage.TitleNotSet"));
                    SelectGraphAndSeriesWizardPage.this.setMessage(null);
                } else {
                    SelectGraphAndSeriesWizardPage.this.setErrorMessage(null);
                    SelectGraphAndSeriesWizardPage.this.setMessage("");
                }
            }
        });
        String[] labels = this.model.getSeries();
        this.cboYItems = new Combo[labels.length];
        this.lblYItems = new Label[this.cboYItems.length];
        Label lblXItem = new Label((Composite)cmpGraphOptsSeries, 0);
        lblXItem.setLayoutData((Object)new GridData(4, 4, false, false));
        lblXItem.setText(Localization.getString("SelectGraphAndSeriesWizardPage.XSeries"));
        this.cboXItem = new Combo((Composite)cmpGraphOptsSeries, 4);
        this.cboXItem.setLayoutData((Object)new GridData(4, 4, true, false));
        this.cboXItem.addSelectionListener((SelectionListener)new ComboSelectionListener());
        this.cboXItem.add(Localization.getString("SelectGraphAndSeriesWizardPage.RowID"));
        int i2 = 0;
        while (i2 < this.cboYItems.length) {
            this.lblYItems[i2] = new Label((Composite)cmpGraphOptsSeries, 0);
            this.lblYItems[i2].setLayoutData((Object)new GridData(4, 4, false, false));
            this.lblYItems[i2].setText(String.valueOf(Localization.getString("SelectGraphAndSeriesWizardPage.YSeries")) + i2 + ":");
            this.cboYItems[i2] = new Combo((Composite)cmpGraphOptsSeries, 4);
            this.cboYItems[i2].setLayoutData((Object)new GridData(4, 4, true, false));
            this.cboYItems[i2].addSelectionListener((SelectionListener)new ComboSelectionListener());
            if (i2 > 0) {
                this.cboYItems[i2].add(Localization.getString("SelectGraphAndSeriesWizardPage.NA"));
                this.cboYItems[i2].setVisible(false);
                this.lblYItems[i2].setVisible(false);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < labels.length) {
            this.cboXItem.add(labels[i3]);
            int j = 0;
            while (j < this.lblYItems.length) {
                this.cboYItems[j].add(labels[i3]);
                ++j;
            }
            ++i3;
        }
        this.cboXItem.select(this.edit ? this.model.getXSeries() + 1 : 0);
        boolean cvisible = this.edit;
        if (this.edit) {
            this.cboYItems[0].select(this.model.getYSeries()[0]);
        }
        i3 = 1;
        while (i3 < this.cboYItems.length) {
            int index = this.edit && this.model.getYSeries().length > i3 ? this.model.getYSeries()[i3] + 1 : 0;
            this.cboYItems[i3].select(index);
            this.cboYItems[i3].setVisible(cvisible);
            this.lblYItems[i3].setVisible(cvisible);
            cvisible = index > 0;
            ++i3;
        }
        if (!this.edit) {
            this.btnGraphs[0].setSelection(true);
            this.saveDataToModelGraph(graphIDs[0]);
        } else {
            this.saveDataToModelGraph(this.wizard.model.getGraphID());
        }
        this.setControl((Control)comp);
    }

    public void handleEvent(Event event) {
        if (event.widget instanceof Button) {
            this.saveDataToModelGraph(((Button)event.widget).getData().toString());
            this.wizard.getContainer().updateButtons();
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        return this.saveDataToModelSeries();
    }

    private void saveDataToModelGraph(String selected) {
        this.model.setGraph(selected);
    }

    private boolean saveDataToModelSeries() {
        if (this.isSeriesUnique()) {
            this.model.setTitle(this.txtTitle.getText());
            if (this.txtKey != null && this.txtKey.isEnabled()) {
                this.model.setKey(this.txtKey.getText());
            } else {
                this.model.setKey(null);
            }
            this.model.setXSeries(this.cboXItem.getSelectionIndex() - 1);
            int i = 1;
            int count = 1;
            while (i < this.cboYItems.length) {
                if (this.cboYItems[i].getSelectionIndex() != 0) {
                    ++count;
                }
                ++i;
            }
            int[] ySeries = new int[count];
            ySeries[0] = this.cboYItems[0].getSelectionIndex();
            i = 1;
            while (i < count) {
                ySeries[i] = this.cboYItems[i].getSelectionIndex() - 1;
                ++i;
            }
            this.model.setYSeries(ySeries);
            return true;
        }
        return false;
    }

    private boolean isSeriesUnique() {
        if ("".equals(this.txtTitle.getText().trim())) {
            return false;
        }
        if (this.txtKey != null && this.txtKey.isEnabled() && this.txtKey.getText().length() <= 0) {
            return false;
        }
        int i = 0;
        while (i < this.cboYItems.length) {
            if (this.cboYItems[i].isVisible()) {
                int j = i + 1;
                while (j < this.cboYItems.length) {
                    if (this.cboYItems[j].isVisible()) {
                        if (this.cboYItems[i].getSelectionIndex() < 0) {
                            return false;
                        }
                        if (this.cboYItems[j].getSelectionIndex() < 0) {
                            return false;
                        }
                        if (this.cboYItems[i].getItem(this.cboYItems[i].getSelectionIndex()).equals(this.cboYItems[j].getItem(this.cboYItems[j].getSelectionIndex()))) {
                            return false;
                        }
                    }
                    ++j;
                }
                if (this.cboYItems[i].getSelectionIndex() < 0) {
                    return false;
                }
                if (this.cboXItem.getSelectionIndex() < 0) {
                    return false;
                }
                if (this.cboYItems[i].getItem(this.cboYItems[i].getSelectionIndex()).equals(this.cboXItem.getItem(this.cboXItem.getSelectionIndex()))) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void dispose() {
        int i;
        super.dispose();
        if (this.btnGraphs != null) {
            i = 0;
            while (i < this.btnGraphs.length) {
                this.btnGraphs[i].dispose();
                ++i;
            }
        }
        this.btnGraphs = null;
        if (this.txtTitle != null) {
            this.txtTitle.dispose();
        }
        this.txtTitle = null;
        if (this.txtKey != null) {
            this.txtKey.dispose();
        }
        this.txtKey = null;
        if (this.btnKey != null) {
            this.btnKey.dispose();
        }
        this.btnKey = null;
        if (this.lblKey != null) {
            this.lblKey.dispose();
        }
        this.lblKey = null;
        if (this.cboXItem != null) {
            this.cboXItem.dispose();
        }
        this.cboXItem = null;
        if (this.cboYItems != null) {
            i = 0;
            while (i < this.cboYItems.length) {
                if (this.cboYItems[i] != null) {
                    this.cboYItems[i].dispose();
                }
                this.cboYItems[i] = null;
                if (this.lblYItems[i] != null) {
                    this.lblYItems[i].dispose();
                }
                this.lblYItems[i] = null;
                ++i;
            }
        }
        this.cboYItems = null;
        this.lblYItems = null;
        this.model = null;
    }

    private class ComboSelectionListener
    implements SelectionListener {
        private ComboSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!SelectGraphAndSeriesWizardPage.this.cboXItem.equals(e.getSource())) {
                boolean setVisible = true;
                if (GraphFactory.isMultiGraph(SelectGraphAndSeriesWizardPage.this.model.getGraphID())) {
                    int i = 1;
                    while (i < SelectGraphAndSeriesWizardPage.this.cboYItems.length) {
                        SelectGraphAndSeriesWizardPage.this.cboYItems[i].setVisible(setVisible);
                        SelectGraphAndSeriesWizardPage.this.lblYItems[i].setVisible(setVisible);
                        setVisible = SelectGraphAndSeriesWizardPage.this.cboYItems[i].getSelectionIndex() > 0 && SelectGraphAndSeriesWizardPage.this.cboYItems[i].isVisible();
                        ++i;
                    }
                }
            }
            if (!SelectGraphAndSeriesWizardPage.this.isSeriesUnique()) {
                SelectGraphAndSeriesWizardPage.this.setErrorMessage(Localization.getString("SelectGraphAndSeriesWizardPage.SeriesNotSelected"));
                SelectGraphAndSeriesWizardPage.this.setMessage(null);
            } else {
                SelectGraphAndSeriesWizardPage.this.setErrorMessage(null);
                SelectGraphAndSeriesWizardPage.this.setMessage("");
            }
            if (SelectGraphAndSeriesWizardPage.this.txtTitle.getText().length() == 0) {
                SelectGraphAndSeriesWizardPage.this.setErrorMessage(Localization.getString("SelectGraphAndSeriesWizardPage.TitleNotSet"));
                SelectGraphAndSeriesWizardPage.this.setMessage(null);
            }
            SelectGraphAndSeriesWizardPage.this.getWizard().getContainer().updateButtons();
        }
    }
}

