/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.GraphModel;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.SelectGraphWizard;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.ColumnLayout;

@Deprecated
public class SelectGraphWizardPage
extends WizardPage
implements Listener {
    private Button[] btnGraphs;
    private SelectGraphWizard wizard;

    public SelectGraphWizardPage() {
        super("selectGraph");
        this.setTitle(Localization.getString("SelectGraphWizardPage.SelectGraph"));
    }

    public void createControl(Composite parent) {
        this.wizard = (SelectGraphWizard)this.getWizard();
        Composite cmpGraphOpts = new Composite(parent, 0);
        ColumnLayout colLayout = new ColumnLayout();
        colLayout.maxNumColumns = 1;
        cmpGraphOpts.setLayout((Layout)colLayout);
        String[] graphIDs = GraphFactory.getAvailableGraphs(this.wizard.model.getDataSet());
        this.btnGraphs = new Button[graphIDs.length];
        int i = 0;
        while (i < this.btnGraphs.length) {
            this.btnGraphs[i] = new Button(cmpGraphOpts, 2);
            this.btnGraphs[i].setImage(GraphFactory.getGraphImage(graphIDs[i]));
            this.btnGraphs[i].addListener(13, (Listener)this);
            this.btnGraphs[i].setData((Object)graphIDs[i]);
            this.btnGraphs[i].setToolTipText(String.valueOf(GraphFactory.getGraphName(this.btnGraphs[i].getData().toString())) + "\n\n" + GraphFactory.getGraphDescription(this.btnGraphs[i].getData().toString()));
            if (this.wizard.isEditing() && graphIDs[i].equals(this.wizard.model.getGraphID())) {
                this.btnGraphs[i].setSelection(true);
            }
            ++i;
        }
        this.setControl((Control)cmpGraphOpts);
    }

    public void handleEvent(Event event) {
        if (event.widget instanceof Button) {
            Button target = (Button)event.widget;
            int i = 0;
            while (i < this.btnGraphs.length) {
                if (target == this.btnGraphs[i]) {
                    this.saveDataToModel(this.btnGraphs[i].getData().toString());
                    this.wizard.getContainer().updateButtons();
                } else {
                    this.btnGraphs[i].setSelection(false);
                }
                ++i;
            }
        }
    }

    public IWizardPage getNextPage() {
        return this.wizard.selectSeriesPage;
    }

    public boolean canFlipToNextPage() {
        return this.wizard.model.isGraphSet();
    }

    private void saveDataToModel(String selected) {
        GraphModel model = this.wizard.model;
        model.setGraph(selected);
        this.wizard.selectSeriesPage.setKeyEnablement(GraphFactory.isKeyRequired(model.getGraphID(), model.getDataSet()), GraphFactory.isKeyOptional(model.getGraphID(), model.getDataSet()));
    }

    public void dispose() {
        super.dispose();
        if (this.btnGraphs != null) {
            int i = 0;
            while (i < this.btnGraphs.length) {
                this.btnGraphs[i] = null;
                ++i;
            }
        }
        this.btnGraphs = null;
    }
}

