/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphing;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.ui.graphing.GraphingPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.graphing.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.datadisplay.DataGrid;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.GraphFactory;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.graph.SelectGraphAndSeriesWizard;
import org.eclipse.linuxtools.systemtap.structures.UpdateManager;
import org.eclipse.linuxtools.systemtap.structures.listeners.ITabListener;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class GraphDisplaySet {
    private int lastSelectedTab;
    private IDataSet dataSet;
    private CTabFolder folder;
    private ButtonClickListener listener;
    private UpdateManager updater;
    private ArrayList<ITabListener> tabListeners;
    private ArrayList<AbstractChartBuilder> builders;

    public GraphDisplaySet(Composite parent, IDataSet data) {
        IPreferenceStore p = GraphingPlugin.getDefault().getPreferenceStore();
        int delay = p.getInt("GraphUpdateDelay");
        this.dataSet = data;
        this.updater = new UpdateManager(delay);
        this.createPartControl(parent);
        this.builders = new ArrayList();
        this.tabListeners = new ArrayList();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        FormData data1 = new FormData();
        Composite cmpCoolBar = new Composite(parent, 0);
        data1.left = new FormAttachment(0, 0);
        data1.top = new FormAttachment(0, 0);
        data1.right = new FormAttachment(100, 0);
        data1.bottom = new FormAttachment(0, 10);
        cmpCoolBar.setLayoutData((Object)data1);
        FormData data2 = new FormData();
        data2.left = new FormAttachment(0, 0);
        data2.top = new FormAttachment((Control)cmpCoolBar);
        data2.right = new FormAttachment(100, 0);
        data2.bottom = new FormAttachment(100, 0);
        Composite cmpGraph = new Composite(parent, 0);
        cmpGraph.setLayoutData((Object)data2);
        cmpGraph.setLayout((Layout)new FormLayout());
        this.folder = new CTabFolder(cmpGraph, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.folder.setLayoutData((Object)data);
        this.listener = new ButtonClickListener();
        this.folder.addSelectionListener((SelectionListener)this.listener);
        this.folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent e) {
                int selected = GraphDisplaySet.this.folder.indexOf((CTabItem)e.item) - 2;
                if (GraphDisplaySet.this.updater != null) {
                    GraphDisplaySet.this.updater.removeUpdateListener((IUpdateListener)GraphDisplaySet.this.builders.get(selected));
                }
                GraphDisplaySet.this.builders.remove(selected);
                GraphDisplaySet.this.fireTabCloseEvent();
            }
        });
        CTabItem newGraph = new CTabItem(this.folder, 0);
        newGraph.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.systemtap.ui.graphing", (String)"icons/actions/new_wiz.gif").createImage());
        newGraph.setToolTipText(Localization.getString("GraphDisplaySet.DataView"));
        CTabItem item = new CTabItem(this.folder, 0);
        item.setText(Localization.getString("GraphDisplaySet.DataView"));
        Composite c = new Composite((Composite)this.folder, 0);
        GridLayout grid = new GridLayout();
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        c.setLayout((Layout)grid);
        GridData gd = new GridData(4, 4, true, true);
        DataGrid table = DataSetFactory.getDataGrid((Composite)c, (IDataSet)this.dataSet);
        if (this.updater != null) {
            this.updater.addUpdateListener((IUpdateListener)table);
        }
        table.getControl().setLayoutData((Object)gd);
        item.setControl((Control)c);
        this.folder.setSelection(item);
        this.lastSelectedTab = 1;
    }

    public IDataSet getDataSet() {
        return this.dataSet;
    }

    public AbstractChartBuilder getActiveGraph() {
        if (this.builders.size() == 0 || this.folder.getSelectionIndex() < 2) {
            return null;
        }
        return this.builders.get(this.folder.getSelectionIndex() - 2);
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.updater != null) {
            this.updater.dispose();
        }
        this.updater = null;
        this.dataSet = null;
        if (this.folder != null) {
            this.folder.removeSelectionListener((SelectionListener)this.listener);
            this.folder.dispose();
            this.folder = null;
        }
        this.listener = null;
    }

    public void addTabListener(ITabListener listener) {
        this.tabListeners.add(listener);
    }

    private void fireTabCloseEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            this.tabListeners.get(i).tabClosed();
            ++i;
        }
    }

    private void fireTabOpenEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            this.tabListeners.get(i).tabOpened();
            ++i;
        }
    }

    private void fireTabChangedEvent() {
        int i = 0;
        while (i < this.tabListeners.size()) {
            this.tabListeners.get(i).tabChanged();
            ++i;
        }
    }

    public void addGraph(GraphData gd) {
        CTabItem item = new CTabItem(this.folder, 64);
        item.setText(GraphFactory.getGraphName((String)gd.graphID));
        GraphComposite gc = new GraphComposite((Composite)this.folder, 4, gd, this.dataSet);
        gc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.folder.setSelection(item);
        AbstractChartBuilder g = gc.getCanvas();
        item.setControl((Control)gc);
        if (g != null) {
            if (this.updater != null) {
                this.updater.addUpdateListener((IUpdateListener)g);
            }
            this.builders.add(g);
        }
    }

    public class ButtonClickListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent event) {
            CTabFolder folder = (CTabFolder)event.getSource();
            if (folder.getSelectionIndex() == 0) {
                folder.setSelection(GraphDisplaySet.this.lastSelectedTab);
                SelectGraphAndSeriesWizard wizard = new SelectGraphAndSeriesWizard(GraphDisplaySet.this.dataSet, null);
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
                GraphData gd = wizard.getGraphData();
                if (gd != null) {
                    GraphDisplaySet.this.addGraph(gd);
                }
                wizard.dispose();
                GraphDisplaySet.this.fireTabOpenEvent();
            }
            GraphDisplaySet.this.lastSelectedTab = folder.getSelectionIndex();
            GraphDisplaySet.this.fireTabChangedEvent();
        }
    }
}

