/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSymbol;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.OprofileSAXHandler;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.XMLProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata.SamplesProcessor;
import org.xml.sax.Attributes;

public class SymbolsProcessor
extends XMLProcessor {
    private static final String SYMBOLS_TAG = "symbols";
    private static final String SYMBOL_TAG = "symbol";
    private static final String SAMPLE_TAG = "sample";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FILE = "file";
    private static final String ATTR_COUNT = "count";
    private static final String ATTR_LINE = "line";
    private OpModelSymbol symbol;
    private ArrayList<OpModelSymbol> symbols;
    private SamplesProcessor samplesProcessor = new SamplesProcessor();

    public void reset(Object callData) {
        this.symbol = new OpModelSymbol();
        this.symbols = new ArrayList();
    }

    public void startElement(String name, Attributes attrs, Object callData) {
        if (name.equals(SYMBOL_TAG)) {
            this.symbol.setName(this.valid_string(attrs.getValue(ATTR_NAME)));
            this.symbol.setCount(Integer.parseInt(attrs.getValue(ATTR_COUNT)));
            this.symbol.setFilePath(this.valid_string(attrs.getValue(ATTR_FILE)));
            this.symbol.setLine(Integer.parseInt(attrs.getValue(ATTR_LINE)));
        } else if (name.equals(SAMPLE_TAG)) {
            OprofileSAXHandler.getInstance(callData).push(this.samplesProcessor);
        }
    }

    public void endElement(String name, Object callData) {
        if (name.equals(SYMBOL_TAG)) {
            this.symbol.setSamples(this.samplesProcessor.getSamples());
            this.symbols.add(this.symbol);
            this.symbol = new OpModelSymbol();
        } else if (name.equals(SYMBOLS_TAG)) {
            OprofileSAXHandler.getInstance(callData).pop(SYMBOLS_TAG);
        }
    }

    public OpModelSymbol[] getSymbols() {
        OpModelSymbol[] s = new OpModelSymbol[this.symbols.size()];
        this.symbols.toArray(s);
        return s;
    }
}

