/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.outline;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.internal.rpm.ui.editor.outline.SpecfileContentProvider;
import org.eclipse.linuxtools.internal.rpm.ui.editor.outline.SpecfileLabelProvider;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class SpecfileContentOutlinePage
extends ContentOutlinePage {
    private ITextEditor editor;
    private IEditorInput input;

    public SpecfileContentOutlinePage(SpecfileEditor editor) {
        this.editor = editor;
    }

    public void setInput(IEditorInput editorInput) {
        this.input = editorInput;
        this.update();
    }

    public void update() {
        Control control;
        final TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        control.setRedraw(false);
                        if (SpecfileContentOutlinePage.this.input != null) {
                            viewer.setInput((Object)SpecfileContentOutlinePage.this.input);
                        }
                        viewer.expandAll();
                        control.setRedraw(true);
                    }
                }
            });
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new SpecfileContentProvider(this.editor));
        viewer.setLabelProvider((IBaseLabelProvider)new SpecfileLabelProvider());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.input != null) {
            viewer.setInput((Object)this.input);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editor.resetHighlightRange();
        } else {
            SpecfileElement element = (SpecfileElement)((IStructuredSelection)selection).getFirstElement();
            int start = element.getLineStartPosition();
            try {
                this.editor.setHighlightRange(start, 1, true);
            }
            catch (IllegalArgumentException e) {
                this.editor.resetHighlightRange();
            }
        }
    }
}

