/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph;

import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.linuxtools.internal.callgraph.Messages;
import org.eclipse.linuxtools.internal.callgraph.StapData;
import org.eclipse.linuxtools.internal.callgraph.StapGraph;
import org.eclipse.linuxtools.internal.callgraph.core.MP;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;

public class StapNode
extends GraphNode {
    private static int nodeSize = 20;
    public int id;
    public GraphConnection connection;
    static NumberFormat numberFormat = NumberFormat.getInstance(Locale.CANADA);

    public StapNode(StapGraph graphModel, int style, StapData data) {
        super((IContainer)graphModel, style, Messages.getString("StapNode.0"));
        Label tooltip;
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        if (Display.getCurrent().getPrimaryMonitor().getBounds().width < 1000) {
            nodeSize = 10;
        }
        if (data.name == StapGraph.CONSTANT_TOP_NODE_NAME) {
            this.setText(StapGraph.CONSTANT_TOP_NODE_NAME);
        } else {
            String shortName = data.name;
            if (data.name.length() > nodeSize) {
                shortName = String.valueOf(data.name.substring(0, nodeSize - 3)) + "...";
            }
            this.setText(String.valueOf(shortName) + ": " + numberFormat.format((float)data.getTime() / (float)graphModel.getTotalTime() * 100.0f) + "%");
        }
        if (data.markedMessage != null && data.markedMessage.length() != 0) {
            tooltip = new Label(String.valueOf(data.name) + ": " + numberFormat.format((float)data.getTime() / (float)graphModel.getTotalTime() * 100.0f) + "%" + "\n  " + data.markedMessage);
            this.setTooltip((IFigure)tooltip);
        } else if (data.name.length() > nodeSize) {
            tooltip = new Label(String.valueOf(data.name) + ": " + numberFormat.format((float)data.getTime() / (float)graphModel.getTotalTime() * 100.0f) + "%");
            this.setTooltip((IFigure)tooltip);
        }
        this.id = data.id;
        this.connection = null;
        if (graphModel.getNode(data.parent) != null) {
            this.connection = new GraphConnection((Graph)graphModel, style, (GraphNode)this, (GraphNode)graphModel.getNode(data.parent));
            if (graphModel.isCollapseMode()) {
                this.connection.setText("" + data.timesCalled);
            }
        } else if (graphModel.getNode(data.collapsedParent) != null) {
            this.connection = new GraphConnection((Graph)graphModel, style, (GraphNode)this, (GraphNode)graphModel.getNode(data.collapsedParent));
            if (graphModel.isCollapseMode()) {
                this.connection.setText("" + data.timesCalled);
            }
        }
    }

    public StapData getData() {
        return ((StapGraph)this.getGraphModel()).getNodeData(this.id);
    }

    public void makeConnection(int style, StapNode n, int called) {
        if (n == null) {
            MP.println((String)("Error! Attempting to connect null node to " + this.getText()));
        }
        this.connection = new GraphConnection(this.getGraphModel(), style, (GraphNode)this, (GraphNode)n);
        if (((StapGraph)this.getGraphModel()).isCollapseMode()) {
            this.connection.setText("" + called);
        }
    }
}

