/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ssh.proxy;

import com.jcraft.jsch.ChannelExec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class SSHProcess
extends Process {
    private ChannelExec channel;
    private static final long DELAY = 100L;

    public SSHProcess(ChannelExec channel) {
        this.channel = channel;
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return this.channel.getOutputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            return this.channel.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream getErrorStream() {
        try {
            return this.channel.getErrStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public int waitFor() throws InterruptedException {
        while (!this.channel.isClosed()) {
            Thread.sleep(100L);
        }
        return this.channel.getExitStatus();
    }

    @Override
    public int exitValue() {
        if (!this.channel.isClosed()) {
            throw new IllegalThreadStateException();
        }
        return this.channel.getExitStatus();
    }

    @Override
    public void destroy() {
        this.channel.disconnect();
    }

    protected int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        this.channel.setOutputStream(output);
        this.channel.setErrStream(err);
        while (!this.channel.isClosed() && !monitor.isCanceled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.channel.setOutputStream(null);
        this.channel.setErrStream(null);
        return this.channel.getExitStatus();
    }
}

