/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.text.MessageFormat;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.CherryPickCommand;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.TeamException;

public class CherryPickOperation
implements IEGitOperation {
    private final Repository repo;
    private final RevCommit commit;
    private CherryPickResult result;

    public CherryPickOperation(Repository repository, RevCommit commit) {
        this.repo = repository;
        this.commit = commit;
    }

    public CherryPickResult getResult() {
        return this.result;
    }

    public void execute(IProgressMonitor m) throws CoreException {
        IProgressMonitor monitor = m != null ? m : new NullProgressMonitor();
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                pm.beginTask("", 2);
                pm.subTask(MessageFormat.format(CoreText.CherryPickOperation_cherryPicking, CherryPickOperation.this.commit.name()));
                CherryPickCommand command = new Git(CherryPickOperation.this.repo).cherryPick().include((AnyObjectId)CherryPickOperation.this.commit.getId());
                try {
                    CherryPickOperation.this.result = command.call();
                }
                catch (GitAPIException e) {
                    throw new TeamException(e.getLocalizedMessage(), e.getCause());
                }
                pm.worked(1);
                ProjectUtil.refreshValidProjects(ProjectUtil.getValidOpenProjects(CherryPickOperation.this.repo), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                pm.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(action, monitor);
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

