/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.io.CharArrayReader;
import java.io.Reader;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.ScannerContext;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.SimpleScanner;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.Token;

public class Scanner
extends SimpleScanner {
    public char[] source;
    public int eofPosition;
    public int startPosition;

    public Scanner() {
        this.setReuseToken(true);
        this.setSplitPreprocessor(false);
    }

    @Override
    protected void init(Reader reader, String filename) {
        throw new UnsupportedOperationException();
    }

    public void setSource(char[] source) {
        this.source = source;
        this.fContext = new ScannerContext().initialize(new CharArrayReader(source));
        this.startPosition = -1;
        this.eofPosition = source.length;
    }

    public void resetTo(int start, int end) {
        CharArrayReader reader = end >= this.source.length ? new CharArrayReader(this.source) : new CharArrayReader(this.source, 0, Math.min(this.source.length, end));
        this.fContext = new ScannerContext().initialize(reader, start);
        this.startPosition = start;
        this.eofPosition = this.source != null && this.source.length < end ? this.source.length : end;
    }

    public int getCurrentTokenStartPosition() {
        return this.fCurrentToken.offset;
    }

    public int getCurrentTokenEndPosition() {
        return this.getCurrentPosition() - 1;
    }

    public int getCurrentPosition() {
        return this.fContext.getOffset() - this.fContext.undoStackSize();
    }

    public final boolean atEnd() {
        return this.getCurrentPosition() >= this.eofPosition;
    }

    public int getNextChar() {
        return this.getChar();
    }

    public boolean getNextChar(char c) {
        if (c == this.getChar()) {
            return true;
        }
        this.ungetChar(c);
        return false;
    }

    public int peekNextChar() {
        int c = this.getChar();
        this.ungetChar(c);
        return c;
    }

    /*
     * Unable to fully structure code
     */
    public void setCurrentPosition(int nextCharacterStart) {
        block4: {
            block3: {
                currentPos = this.getCurrentPosition();
                diff = currentPos - nextCharacterStart;
                if (diff >= 0) break block3;
                do {
                    this.getChar();
                } while (++diff < 0);
                break block4;
            }
            if (diff == 0) break block4;
            if (diff <= this.fTokenBuffer.length()) ** GOTO lbl17
            this.resetTo(nextCharacterStart, this.source.length);
            break block4;
lbl-1000:
            // 1 sources

            {
                if (this.fTokenBuffer.length() > 0) {
                    this.ungetChar(this.fTokenBuffer.charAt(this.fTokenBuffer.length() - 1));
                }
                --diff;
lbl17:
                // 2 sources

                ** while (diff > 0)
            }
        }
    }

    public char[] getCurrentTokenSource() {
        return this.fCurrentToken.getText().toCharArray();
    }

    public int getNextToken() {
        Token token = this.nextToken();
        if (token == null) {
            return -1;
        }
        return token.type;
    }

    public String toString() {
        char[] middle;
        if (this.startPosition == this.source.length) {
            return "EOF\n\n" + new String(this.source);
        }
        if (this.getCurrentPosition() > this.source.length) {
            return "behind the EOF\n\n" + new String(this.source);
        }
        char[] front = new char[this.startPosition];
        System.arraycopy(this.source, 0, front, 0, this.startPosition);
        int middleLength = this.getCurrentPosition() - 1 - this.startPosition + 1;
        if (middleLength > -1) {
            middle = new char[middleLength];
            System.arraycopy(this.source, this.startPosition, middle, 0, middleLength);
        } else {
            middle = new char[]{};
        }
        char[] end = new char[this.source.length - (this.getCurrentPosition() - 1)];
        System.arraycopy(this.source, this.getCurrentPosition() - 1 + 1, end, 0, this.source.length - (this.getCurrentPosition() - 1) - 1);
        return String.valueOf(new String(front)) + "\n===============================\nStarts here -->" + new String(middle) + "<-- Ends here\n===============================\n" + new String(end);
    }
}

