/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.man.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.man.Activator;

public class ManParser {
    public StringBuilder getRawManPage(String manPage) {
        String manExecutable = Activator.getDefault().getPreferenceStore().getString("pathPreference");
        ProcessBuilder builder = new ProcessBuilder(manExecutable, manPage);
        builder.redirectErrorStream(true);
        StringBuilder sb = new StringBuilder();
        try {
            Process process = builder.start();
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") != 0) {
                process.waitFor();
            }
            InputStream manContent = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(manContent));
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        manContent.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    manContent.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e1) {
            Status status = new Status(4, e1.getMessage(), "org.eclipse.linuxtools.man");
            Activator.getDefault().getLog().log((IStatus)status);
        }
        catch (InterruptedException e1) {
            Status status = new Status(4, e1.getMessage(), "org.eclipse.linuxtools.man");
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return sb;
    }
}

