/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event;

public class CTFCallsite
implements Comparable<CTFCallsite> {
    private static final long MASK32 = 0xFFFFFFFFL;
    private final String eventName;
    private final String fileName;
    private final long ip;
    private final String functionName;
    private final long lineNumber;

    public CTFCallsite(String en, String func, long ip, String fn, long line) {
        this.eventName = en;
        this.fileName = fn;
        this.functionName = func;
        this.ip = ip;
        this.lineNumber = line;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getIp() {
        return this.ip;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int compareTo(CTFCallsite o) {
        long other = o.ip;
        long otherHigh = other >> 32 & 0xFFFFFFFFL;
        long otherLow = other & 0xFFFFFFFFL;
        long ownHigh = this.ip >> 32 & 0xFFFFFFFFL;
        long ownLow = this.ip & 0xFFFFFFFFL;
        if (ownHigh > otherHigh) {
            return 1;
        }
        if (ownHigh < otherHigh) {
            return -1;
        }
        if (ownLow > otherLow) {
            return 1;
        }
        if (ownLow < otherLow) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.fileName) + "/" + this.functionName + ":" + this.lineNumber;
    }
}

