/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.dataset;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.dataset.ParsingWizardPage;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.dataset.SelectDataSetWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class DataSetWizard
extends Wizard
implements INewWizard {
    private IPageChangedListener pageListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent e) {
            if (e.getSelectedPage() instanceof ParsingWizardPage) {
                ((ParsingWizardPage)((Object)e.getSelectedPage())).checkComplete();
                DataSetWizard.this.getContainer().updateButtons();
            }
        }
    };
    private SelectDataSetWizardPage dataSetPage;
    private ParsingWizardPage[] parsingPages;
    public String scriptFile;
    public File metaFile;
    public IDataSet dataSet;
    public IDataSetParser parser;

    public DataSetWizard(File metaFile, String scriptFile) {
        this.metaFile = metaFile;
        this.scriptFile = scriptFile;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Localization.getString("DataSetWizard.CreateDataSet"));
        this.dataSetPage = new SelectDataSetWizardPage();
        this.addPage((IWizardPage)this.dataSetPage);
        String[] ids = DataSetFactory.getIDs();
        this.parsingPages = new ParsingWizardPage[ids.length];
        int i = 0;
        while (i < ids.length) {
            this.parsingPages[i] = DataSetFactory.getParsingWizardPage(ids[i]);
            this.addPage((IWizardPage)this.parsingPages[i]);
            ++i;
        }
        ((WizardDialog)this.getContainer()).addPageChangedListener(this.pageListener);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return this.dataSet != null && this.parser != null && page instanceof ParsingWizardPage;
    }

    public boolean performCancel() {
        this.parser = null;
        this.dataSet = null;
        return true;
    }

    public boolean performFinish() {
        return true;
    }

    public IDataSetParser getParser() {
        return this.parser;
    }

    public IDataSet getDataSet() {
        return this.dataSet;
    }

    protected boolean openFile() {
        try {
            if (!this.metaFile.exists()) {
                this.metaFile.createNewFile();
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.getContainer() != null) {
            ((WizardDialog)this.getContainer()).removePageChangedListener(this.pageListener);
        }
        if (this.dataSetPage != null) {
            this.dataSetPage.dispose();
        }
        if (this.parsingPages != null) {
            int i = 0;
            while (i < this.parsingPages.length) {
                if (this.parsingPages[i] != null) {
                    this.parsingPages[i].dispose();
                    this.parsingPages[i] = null;
                }
                ++i;
            }
            this.parsingPages = null;
        }
    }
}

