/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.ui.view;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;

class LogReader
implements Runnable,
IRunnableWithProgress {
    private static long lastModified = -1L;
    private static String contents = null;
    private IRemoteFileProxy proxy;

    LogReader() {
    }

    public void run() {
        try {
            this.proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
            IFileStore fileStore = this.proxy.getResource(Oprofile.getLogFile());
            if (fileStore.fetchInfo().exists()) {
                String line;
                long modified = fileStore.fetchInfo().getLastModified();
                if (modified != lastModified) {
                    lastModified = modified;
                    contents = "";
                }
                InputStream is = fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
                BufferedReader bi = new BufferedReader(new InputStreamReader(is));
                while ((line = bi.readLine()) != null) {
                    contents = String.valueOf(contents) + line + "\n";
                }
                bi.close();
            }
        }
        catch (FileNotFoundException e) {
            contents = OprofileUiMessages.getString("oprofiled.logreader.error.fileNotFound");
        }
        catch (IOException e) {
            lastModified = 0L;
            contents = OprofileUiMessages.getString("oprofiled.logreader.error.io");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getLogContents() {
        return contents;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.run();
    }
}

