/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.gerrit;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.gerrit.GerritConfigurationPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class ConfigureGerritWizard
extends Wizard {
    private GerritConfigurationPage gerritConfiguration;
    private StoredConfig config;
    private final String remoteName;
    private RemoteConfig remoteConfig;

    public ConfigureGerritWizard(Repository repository, String remoteName) {
        this.setWindowTitle(UIText.ConfigureGerritWizard_title);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.setNeedsProgressMonitor(true);
        this.gerritConfiguration = new GerritConfigurationPage(repository, remoteName){

            public void setVisible(boolean visible) {
                if (visible) {
                    ConfigureGerritWizard.this.configurePage();
                }
                super.setVisible(visible);
            }
        };
        this.config = repository.getConfig();
        this.remoteName = remoteName;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.gerritConfiguration);
    }

    private void configurePage() {
        try {
            this.findRemoteConfig();
            if (this.remoteConfig != null) {
                this.gerritConfiguration.setSelection(this.getUri(), this.getProposedTargetBranch());
            }
        }
        catch (URISyntaxException e) {
            this.gerritConfiguration.setErrorMessage("Error in configured URI");
            Activator.logError("Configured URI could not be read", e);
        }
    }

    private void findRemoteConfig() throws URISyntaxException {
        List allRemoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this.config);
        for (RemoteConfig rc : allRemoteConfigs) {
            if (!rc.getName().equals(this.remoteName)) continue;
            this.remoteConfig = rc;
        }
    }

    private URIish getUri() {
        URIish urIish = null;
        urIish = this.remoteConfig.getPushURIs().size() > 0 ? (URIish)this.remoteConfig.getPushURIs().get(0) : (URIish)this.remoteConfig.getURIs().get(0);
        return urIish;
    }

    private String getProposedTargetBranch() {
        List pushRefSpecs = this.remoteConfig.getPushRefSpecs();
        String destination = null;
        if (pushRefSpecs.size() > 0) {
            destination = ((RefSpec)pushRefSpecs.get(0)).getDestination();
            if (destination.startsWith("refs/heads/")) {
                destination = destination.substring("refs/heads/".length());
            } else if (destination.startsWith("refs/for/")) {
                destination = destination.substring("refs/for/".length());
            }
        }
        return destination;
    }

    public boolean canFinish() {
        return this.gerritConfiguration.isPageComplete();
    }

    public boolean performFinish() {
        this.configureRemoteSection();
        this.configureCreateChangeId();
        try {
            this.config.save();
        }
        catch (IOException e) {
            this.gerritConfiguration.setErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }

    private void configureRemoteSection() {
        this.configurePushURI();
        this.configurePushRefSpec();
        this.configureFetchNotes();
        this.remoteConfig.update((Config)this.config);
    }

    private void configurePushURI() {
        ArrayList pushURIs = new ArrayList(this.remoteConfig.getPushURIs());
        for (URIish urIish : pushURIs) {
            this.remoteConfig.removePushURI(urIish);
        }
        URIish pushURI = this.gerritConfiguration.getURI();
        this.remoteConfig.addPushURI(pushURI);
    }

    private void configurePushRefSpec() {
        String gerritBranch = this.gerritConfiguration.getBranch();
        ArrayList pushRefSpecs = new ArrayList(this.remoteConfig.getPushRefSpecs());
        for (RefSpec refSpec : pushRefSpecs) {
            this.remoteConfig.removePushRefSpec(refSpec);
        }
        this.remoteConfig.addPushRefSpec(new RefSpec("HEAD:refs/for/" + gerritBranch));
    }

    private void configureFetchNotes() {
        String notesRef = "refs/notes/*";
        List fetchRefSpecs = this.remoteConfig.getFetchRefSpecs();
        for (RefSpec refSpec : fetchRefSpecs) {
            if (!refSpec.matchSource(notesRef)) continue;
            return;
        }
        this.remoteConfig.addFetchRefSpec(new RefSpec(String.valueOf(notesRef) + ":" + notesRef));
    }

    private void configureCreateChangeId() {
        this.config.setBoolean("gerrit", null, "createchangeid", true);
    }
}

