/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.repository.RepositoriesView;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RepositoriesViewCommandHandler<T>
extends AbstractHandler {
    protected final RepositoryUtil util = Activator.getDefault().getRepositoryUtil();

    RepositoriesViewCommandHandler() {
    }

    public RepositoriesView getView(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        return (RepositoriesView)part;
    }

    public Shell getShell(ExecutionEvent event) {
        return HandlerUtil.getActiveShell((ExecutionEvent)event);
    }

    public List<T> getSelectedNodes(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    public Shell getActiveShell(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
    }

    private boolean checkRepositoryHasHead(Object element) {
        if (element instanceof RepositoryTreeNode) {
            RepositoryTreeNode treeNode = (RepositoryTreeNode)element;
            Repository repo = treeNode.getRepository();
            try {
                Ref ref = repo.getRef("HEAD");
                return ref != null && ref.getObjectId() != null;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    protected boolean checkSelectionHasHead(Object evaluationContext, boolean all) {
        IStructuredSelection structuredSelection;
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() > 0) {
            if (all) {
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (!this.checkRepositoryHasHead(element)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return this.checkRepositoryHasHead(structuredSelection.getFirstElement());
        }
        return false;
    }

    protected void enableWhenAllRepositoriesHaveHead(Object evaluationContext) {
        this.setBaseEnabled(this.checkSelectionHasHead(evaluationContext, true));
    }

    protected void enableWhenRepositoryHaveHead(Object evaluationContext) {
        this.setBaseEnabled(this.checkSelectionHasHead(evaluationContext, false));
    }

    protected void enableWorkingDirCommand(Object evaluationContext) {
        if (!(evaluationContext instanceof IEvaluationContext)) {
            this.setBaseEnabled(false);
            return;
        }
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        Object selection = context.getVariable("selection");
        if (!(selection instanceof TreeSelection)) {
            this.setBaseEnabled(false);
            return;
        }
        Repository repository = null;
        TreeSelection treeSelection = (TreeSelection)selection;
        for (Object object : treeSelection) {
            String path;
            if (!(object instanceof RepositoryTreeNode)) {
                this.setBaseEnabled(false);
                return;
            }
            Repository nodeRepository = ((RepositoryTreeNode)object).getRepository();
            if (repository == null) {
                repository = nodeRepository;
            } else if (repository != nodeRepository) {
                this.setBaseEnabled(false);
                return;
            }
            if (object instanceof WorkingDirNode) continue;
            if (object instanceof FolderNode) {
                path = ((File)((FolderNode)object).getObject()).getAbsolutePath();
            } else if (object instanceof FileNode) {
                path = ((File)((FileNode)object).getObject()).getAbsolutePath();
            } else {
                this.setBaseEnabled(false);
                return;
            }
            if (!path.startsWith(repository.getDirectory().getAbsolutePath())) continue;
            this.setBaseEnabled(false);
            return;
        }
        this.setBaseEnabled(true);
    }

    protected Object getSelection(IEvaluationContext ctx) {
        Object selection = ctx.getVariable("activeMenuSelection");
        if (selection == null || !(selection instanceof ISelection)) {
            selection = ctx.getVariable("selection");
        }
        return selection;
    }

    protected Collection<IPath> getSelectedFileAndFolderPaths(ExecutionEvent event) throws ExecutionException {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (T selectedNode : this.getSelectedNodes(event)) {
            RepositoryTreeNode treeNode = (RepositoryTreeNode)selectedNode;
            IPath path = treeNode.getPath();
            paths.add(path);
        }
        return paths;
    }
}

