/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.internal.core.model.ext.SourceRange;
import org.eclipse.cdt.internal.ui.actions.StructureSelectionAction;
import org.eclipse.cdt.internal.ui.editor.SelectionHistory;
import org.eclipse.ui.texteditor.ITextEditor;

public class StructureSelectEnclosingAction
extends StructureSelectionAction {
    public static final String PREFIX = "StructureSelectEnclosing.";

    public StructureSelectEnclosingAction(ResourceBundle bundle, ITextEditor editor, SelectionHistory history) {
        super(bundle, PREFIX, editor, history);
    }

    @Override
    public ISourceRange doExpand(IASTTranslationUnit ast, SourceRange current) {
        ISourceRange newSourceRange = StructureSelectEnclosingAction.expandToEnclosing(ast, current);
        if (newSourceRange != null) {
            this.history.remember((ISourceRange)current);
        }
        return newSourceRange;
    }

    public static ISourceRange expandToEnclosing(IASTTranslationUnit ast, SourceRange current) {
        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
        IASTNode node = nodeSelector.findStrictlyEnclosingNode(current.getStartPos(), current.getLength());
        if (node == null) {
            return null;
        }
        IASTFileLocation fileLocation = node.getFileLocation();
        return new SourceRange(fileLocation.getNodeOffset(), fileLocation.getNodeLength());
    }
}

