/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.launch;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.internal.etfw.launch.ui.util.ETFWToolTabBuilder;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.launch.IJAXBLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ETFWParentLaunchConfigurationTab
extends JAXBControllerLaunchConfigurationTab {
    private final IVariableMap variableMap;
    private List<IJAXBLaunchConfigurationTab> tabControllers;

    public ETFWParentLaunchConfigurationTab(ILaunchController control, ILaunchConfigurationDialog dialog, IProgressMonitor monitor, IVariableMap variableMap) throws Throwable {
        super(control, dialog, monitor);
        this.variableMap = variableMap;
    }

    public void createControl(Composite parent, String id) throws CoreException {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.control.setLayout((Layout)layout);
        this.tabFolder = new TabFolder(this.control, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        ETFWToolTabBuilder.initialize();
        for (IJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            ETFWToolTabBuilder builder = new ETFWToolTabBuilder(tabControl, this.variableMap);
            TabItem tabItem = new TabItem(this.tabFolder, 0);
            Composite control = null;
            ScrolledComposite scroller = new ScrolledComposite((Composite)this.tabFolder, 768);
            try {
                control = builder.build((Composite)scroller);
                control.layout();
                tabItem.setText(tabControl.getController().getTitle());
                String tooltip = tabControl.getController().getTooltip();
                if (tooltip != null) {
                    tabItem.setToolTipText(tooltip);
                    scroller.setToolTipText(tooltip);
                }
                scroller.setContent((Control)control);
                scroller.setExpandHorizontal(true);
                scroller.setExpandVertical(true);
                scroller.setMinSize(control.computeSize(-1, -1));
                tabItem.setControl((Control)scroller);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.controlId = id;
        this.control.layout(true, true);
    }

    public RMLaunchValidation initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.getVariableMap().initialize(this.variableMap, this.getJobControl().getControlId());
            this.getUpdateHandler().clear();
            this.getVariableMap().updateFromConfiguration(configuration);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public void addDynamicContent(List<IJAXBLaunchConfigurationTab> tabs) {
        this.tabControllers = tabs;
    }

    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration) {
        RMLaunchValidation validation = super.performApply(configuration);
        for (String attribute : this.getVariableMap().getAttributes().keySet()) {
            int val;
            String name = attribute;
            if (!name.startsWith(this.controlId)) continue;
            name = name.substring(this.controlId.length() + 1, attribute.length());
            AttributeType temp = (AttributeType)this.variableMap.getAttributes().get(name);
            if (temp == null || !this.isWidgetEnabled(temp.getName()) || !temp.isVisible()) continue;
            String attType = temp.getType();
            String translateBoolean = ((AttributeType)this.variableMap.getAttributes().get(name)).getTranslateBooleanAs();
            Object value = this.getVariableMap().getValue(name);
            if (attType.equals("boolean")) {
                if (translateBoolean != null) {
                    configuration.setAttribute(attribute, value.toString());
                    continue;
                }
                val = new Boolean(value.toString()).booleanValue();
                configuration.setAttribute(attribute, val != 0);
                continue;
            }
            if (attType.equals("string")) {
                configuration.setAttribute(attribute, value.toString());
                continue;
            }
            if (attType.equals("integer")) {
                if (value.toString().length() > 0) {
                    val = new Integer(value.toString());
                    configuration.setAttribute(attribute, val);
                    continue;
                }
                configuration.setAttribute(attribute, value.toString());
                continue;
            }
            configuration.setAttribute(attribute, value.toString());
        }
        return validation;
    }

    public boolean isWidgetEnabled(String attributeName) {
        for (IJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            for (IUpdateModel m : tabControl.getLocalWidgets().values()) {
                if (m.getName() == null || !m.getName().equals(attributeName)) continue;
                return ((Control)m.getControl()).isEnabled();
            }
        }
        return true;
    }

    public void relink() {
    }
}

