/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.linux;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.internal.oprofile.core.IOpxmlProvider;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpInfo;
import org.eclipse.linuxtools.internal.oprofile.core.linux.OpxmlRunner;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelEvent;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata.ModelDataProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.sessions.SessionsProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxOpxmlProvider
implements IOpxmlProvider {
    @Override
    public IRunnableWithProgress info(OpInfo info) {
        return new OpInfoRunner(info);
    }

    @Override
    public IRunnableWithProgress modelData(final String eventName, final String sessionName, final OpModelImage image) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                OpxmlRunner runner = new OpxmlRunner();
                String[] args = new String[]{"model-data", eventName, sessionName};
                ModelDataProcessor.CallData data = new ModelDataProcessor.CallData(image);
                runner.run(args, data);
            }
        };
        return runnable;
    }

    @Override
    public IRunnableWithProgress checkEvents(final int ctr, final String event, final int um, final int[] eventValid) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                OpxmlRunner runner = new OpxmlRunner();
                String[] args = new String[]{"check-events", Integer.toString(ctr), event, Integer.toString(um)};
                runner.run(args, eventValid);
            }
        };
        return runnable;
    }

    @Override
    public IRunnableWithProgress sessions(final ArrayList<OpModelEvent> sessionList) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                OpxmlRunner runner = new OpxmlRunner();
                String[] args = new String[]{"sessions"};
                SessionsProcessor.SessionInfo sinfo = new SessionsProcessor.SessionInfo(sessionList);
                runner.run(args, sinfo);
            }
        };
        return runnable;
    }

    public class OpInfoRunner
    implements IRunnableWithProgress {
        private boolean b;
        private final OpInfo info;

        public OpInfoRunner(OpInfo info) {
            this.info = info;
        }

        public boolean run0(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.run(monitor);
            return this.b;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            OpxmlRunner runner = new OpxmlRunner();
            String[] args = new String[]{"info"};
            this.b = runner.run(args, this.info);
        }
    }
}

