/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class ReplaceDoLoopWithForallRefactoring
extends FortranEditorRefactoring {
    ASTProperLoopConstructNode selected_do_loop = null;
    LinkedList<ASTProperLoopConstructNode> nested_selected_do_loop = new LinkedList();

    public String getName() {
        return "Replace Do Loop With Forall (Unchecked)";
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        IASTNode do_loop_node = ReplaceDoLoopWithForallRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (!(do_loop_node instanceof ASTProperLoopConstructNode)) {
            this.fail("Please, select a Do Loop.");
        }
        this.selected_do_loop = this.findSelectedDoLoop();
        if (this.selected_do_loop != null) {
            IASTListNode<IExecutionPartConstruct> body_selected_loop = this.selected_do_loop.getBody();
            for (IExecutionPartConstruct i : body_selected_loop) {
                if (this.getBody(i)) continue;
                this.fail("Sorry, this refactoring can be applied only in Do Loops that contains just variable assignments.");
            }
        }
        this.findNestedSelectedDoLoop();
    }

    private boolean getBody(IExecutionPartConstruct node) {
        if (node instanceof ASTProperLoopConstructNode) {
            IASTListNode<IExecutionPartConstruct> body = ((ASTProperLoopConstructNode)node).getBody();
            for (IExecutionPartConstruct i : body) {
                if (i instanceof ASTProperLoopConstructNode) {
                    return this.getBody(i);
                }
                if (i instanceof ASTAssignmentStmtNode) continue;
                return false;
            }
        } else if (!(node instanceof ASTAssignmentStmtNode)) {
            return false;
        }
        return true;
    }

    private ASTProperLoopConstructNode findSelectedDoLoop() {
        return ReplaceDoLoopWithForallRefactoring.getLoopNode(this.astOfFileInEditor, this.selectedRegionInEditor);
    }

    private void findNestedSelectedDoLoop() {
        if (this.selected_do_loop != null) {
            IASTListNode<IExecutionPartConstruct> body_selected_loop = this.selected_do_loop.getBody();
            for (IExecutionPartConstruct i : body_selected_loop) {
                this.addNestedSelectedDoLoop(i);
            }
        }
    }

    private void addNestedSelectedDoLoop(IExecutionPartConstruct node) {
        if (node instanceof ASTProperLoopConstructNode) {
            this.nested_selected_do_loop.add((ASTProperLoopConstructNode)node);
            IASTListNode<IExecutionPartConstruct> body = ((ASTProperLoopConstructNode)node).getBody();
            for (IExecutionPartConstruct i : body) {
                if (!(i instanceof ASTProperLoopConstructNode)) continue;
                this.addNestedSelectedDoLoop(i);
            }
        }
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    protected void doCreateChange(IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        int i = this.nested_selected_do_loop.size() - 1;
        while (i >= 0) {
            ASTProperLoopConstructNode node = this.nested_selected_do_loop.get(i);
            String forall = this.constructForallNode(node);
            node.replaceWith(ReplaceDoLoopWithForallRefactoring.parseLiteralStatementSequence(forall));
            --i;
        }
        String forall = this.constructForallNode(this.selected_do_loop);
        this.selected_do_loop.replaceWith(ReplaceDoLoopWithForallRefactoring.parseLiteralStatementSequence(forall));
        this.addChangeFromModifiedAST(this.fileInEditor, progressMonitor);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private String constructForallNode(ASTProperLoopConstructNode node) {
        String variable = node.getLoopHeader().getLoopControl().getVariableName().getText();
        String initial_value = node.getLoopHeader().getLoopControl().getLb().toString().trim();
        String final_value = node.getLoopHeader().getLoopControl().getUb().toString().trim();
        String tab_init = node.findFirstToken().getWhiteBefore();
        String tab_end = node.getEndDoStmt().findFirstToken().getWhiteBefore();
        String step = null;
        IExpr step_expr = node.getLoopHeader().getLoopControl().getStep();
        if (step_expr != null) {
            step = step_expr.toString();
        }
        String forall = String.valueOf(tab_init) + "FORALL (" + variable + "=" + initial_value + ":" + final_value;
        forall = step != null ? String.valueOf(forall) + ":" + step + ")" : String.valueOf(forall) + ")";
        String body = node.getBody().toString();
        forall = String.valueOf(forall) + "\n" + body + tab_end + "END FORALL";
        return forall;
    }
}

