/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;

public class LogicalStructureCache {
    private Map fCacheForType = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue getLogicalStructure(ILogicalStructureType type, IValue value) throws CoreException {
        Map map = this.fCacheForType;
        synchronized (map) {
            LogicalStructureTypeCache cache = this.getCacheForType(type);
            return cache.getLogicalStructure(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.fCacheForType;
        synchronized (map) {
            this.fCacheForType.clear();
        }
    }

    protected LogicalStructureTypeCache getCacheForType(ILogicalStructureType type) {
        LogicalStructureTypeCache cache = (LogicalStructureTypeCache)this.fCacheForType.get(type);
        if (cache == null) {
            cache = new LogicalStructureTypeCache(type);
            this.fCacheForType.put(type, cache);
        }
        return cache;
    }

    class LogicalStructureTypeCache {
        private ILogicalStructureType fType;
        private Map fKnownValues = new HashMap();
        private Set fPendingValues = new HashSet();

        public LogicalStructureTypeCache(ILogicalStructureType type) {
            this.fType = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IValue getLogicalStructure(IValue value) throws CoreException {
            Object object;
            Object object2 = this.fKnownValues;
            synchronized (object2) {
                IValue logical = (IValue)this.fKnownValues.get(value);
                if (logical != null) {
                    return logical;
                }
            }
            object2 = this.fPendingValues;
            synchronized (object2) {
                if (this.fPendingValues.contains(value)) {
                    try {
                        this.fPendingValues.wait();
                        return this.getLogicalStructure(value);
                    }
                    catch (InterruptedException e) {
                        throw new CoreException((IStatus)new Status(8, DebugUIPlugin.getUniqueIdentifier(), VariablesViewMessages.LogicalStructureCache_0, (Throwable)e));
                    }
                }
                this.fPendingValues.add(value);
            }
            try {
                IValue result = this.fType.getLogicalStructure(value);
                object = this.fKnownValues;
                synchronized (object) {
                    this.fKnownValues.put(value, result);
                }
                object = this.fPendingValues;
                synchronized (object) {
                    this.fPendingValues.remove(value);
                    this.fPendingValues.notifyAll();
                }
                return result;
            }
            catch (CoreException e) {
                object = this.fPendingValues;
                synchronized (object) {
                    this.fPendingValues.remove(value);
                    this.fPendingValues.notifyAll();
                }
                throw e;
            }
        }
    }
}

