/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.request;

import java.util.concurrent.CountDownLatch;
import org.eclipse.linuxtools.internal.tmf.core.TmfCoreTracer;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;

public abstract class TmfDataRequest
implements ITmfDataRequest {
    public static final int DEFAULT_BLOCK_SIZE = 1000;
    public static final int ALL_DATA = Integer.MAX_VALUE;
    private static int fRequestNumber = 0;
    private final Class<? extends ITmfEvent> fDataType;
    private final ITmfDataRequest.ExecutionType fExecType;
    private final int fRequestId;
    protected long fIndex;
    protected int fNbRequested;
    private final int fBlockSize;
    private int fNbRead;
    private final CountDownLatch startedLatch = new CountDownLatch(1);
    private final CountDownLatch completedLatch = new CountDownLatch(1);
    private boolean fRequestRunning;
    private boolean fRequestCompleted;
    private boolean fRequestFailed;
    private boolean fRequestCanceled;

    public static void reset() {
        fRequestNumber = 0;
    }

    public TmfDataRequest(Class<? extends ITmfEvent> dataType) {
        this(dataType, 0L, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfDataRequest(Class<? extends ITmfEvent> dataType, ITmfDataRequest.ExecutionType priority) {
        this(dataType, 0L, Integer.MAX_VALUE, 1000, priority);
    }

    public TmfDataRequest(Class<? extends ITmfEvent> dataType, long index) {
        this(dataType, index, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfDataRequest(Class<? extends ITmfEvent> dataType, long index, ITmfDataRequest.ExecutionType priority) {
        this(dataType, index, Integer.MAX_VALUE, 1000, priority);
    }

    public TmfDataRequest(Class<? extends ITmfEvent> dataType, long index, int nbRequested) {
        this(dataType, index, nbRequested, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfDataRequest(Class<? extends ITmfEvent> dataType, long index, int nbRequested, ITmfDataRequest.ExecutionType priority) {
        this(dataType, index, nbRequested, 1000, priority);
    }

    public TmfDataRequest(Class<? extends ITmfEvent> dataType, long index, int nbRequested, int blockSize) {
        this(dataType, index, nbRequested, blockSize, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfDataRequest(Class<? extends ITmfEvent> dataType, long index, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType priority) {
        this.fRequestId = fRequestNumber++;
        this.fDataType = dataType;
        this.fIndex = index;
        this.fNbRequested = nbRequested;
        this.fBlockSize = blockSize;
        this.fExecType = priority;
        this.fNbRead = 0;
        this.fRequestRunning = false;
        this.fRequestCompleted = false;
        this.fRequestFailed = false;
        this.fRequestCanceled = false;
        if (!(this instanceof ITmfEventRequest) && TmfCoreTracer.isRequestTraced()) {
            String type = this.getClass().getName();
            type = type.substring(type.lastIndexOf(46) + 1);
            String message = "CREATED " + (this.getExecType() == ITmfDataRequest.ExecutionType.BACKGROUND ? "(BG)" : "(FG)") + " Type=" + type + " Index=" + this.getIndex() + " NbReq=" + this.getNbRequested() + " DataType=" + this.getDataType().getSimpleName();
            TmfCoreTracer.traceRequest(this, message);
        }
    }

    @Override
    public int getRequestId() {
        return this.fRequestId;
    }

    @Override
    public long getIndex() {
        return this.fIndex;
    }

    @Override
    public ITmfDataRequest.ExecutionType getExecType() {
        return this.fExecType;
    }

    @Override
    public int getNbRequested() {
        return this.fNbRequested;
    }

    @Override
    public int getBlockSize() {
        return this.fBlockSize;
    }

    @Override
    public synchronized int getNbRead() {
        return this.fNbRead;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.fRequestRunning;
    }

    @Override
    public synchronized boolean isCompleted() {
        return this.fRequestCompleted;
    }

    @Override
    public synchronized boolean isFailed() {
        return this.fRequestFailed;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.fRequestCanceled;
    }

    @Override
    public Class<? extends ITmfEvent> getDataType() {
        return this.fDataType;
    }

    protected void setIndex(int index) {
        this.fIndex = index;
    }

    @Override
    public void handleData(ITmfEvent data) {
        if (data != null) {
            ++this.fNbRead;
        }
    }

    @Override
    public void handleStarted() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this, "STARTED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCompleted() {
        boolean requestFailed = false;
        boolean requestCanceled = false;
        TmfDataRequest tmfDataRequest = this;
        synchronized (tmfDataRequest) {
            requestFailed = this.fRequestFailed;
            requestCanceled = this.fRequestCanceled;
        }
        if (requestFailed) {
            this.handleFailure();
        } else if (requestCanceled) {
            this.handleCancel();
        } else {
            this.handleSuccess();
        }
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this, "COMPLETED (" + this.fNbRead + " events read)");
        }
    }

    @Override
    public void handleSuccess() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this, "SUCCEEDED");
        }
    }

    @Override
    public void handleFailure() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this, "FAILED");
        }
    }

    @Override
    public void handleCancel() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this, "CANCELLED");
        }
    }

    public void waitForStart() throws InterruptedException {
        while (!this.fRequestRunning) {
            this.startedLatch.await();
        }
    }

    @Override
    public void waitForCompletion() throws InterruptedException {
        while (!this.fRequestCompleted) {
            this.completedLatch.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        TmfDataRequest tmfDataRequest = this;
        synchronized (tmfDataRequest) {
            this.fRequestRunning = true;
        }
        this.handleStarted();
        this.startedLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        TmfDataRequest tmfDataRequest = this;
        synchronized (tmfDataRequest) {
            if (this.fRequestCompleted) {
                return;
            }
            this.fRequestRunning = false;
            this.fRequestCompleted = true;
        }
        try {
            this.handleCompleted();
        }
        finally {
            this.completedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail() {
        TmfDataRequest tmfDataRequest = this;
        synchronized (tmfDataRequest) {
            this.fRequestFailed = true;
        }
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        TmfDataRequest tmfDataRequest = this;
        synchronized (tmfDataRequest) {
            this.fRequestCanceled = true;
        }
        this.done();
    }

    public int hashCode() {
        return this.getRequestId();
    }

    public boolean equals(Object other) {
        if (other instanceof TmfDataRequest) {
            TmfDataRequest request = (TmfDataRequest)other;
            return request.fDataType == this.fDataType && request.fIndex == this.fIndex && request.fNbRequested == this.fNbRequested;
        }
        return false;
    }

    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            name = name.substring(dot + 1);
        }
        return "[" + name + "(" + this.fRequestId + "," + this.fDataType.getSimpleName() + "," + (Object)((Object)this.getExecType()) + "," + this.fIndex + "," + this.fNbRequested + "," + this.getBlockSize() + ")]";
    }
}

