/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statistics;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfStatsUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statesystem.TmfStateSystemFactory;
import org.eclipse.linuxtools.tmf.core.statistics.ITmfStatistics;
import org.eclipse.linuxtools.tmf.core.statistics.StatsStateProvider;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;

public class TmfStateStatistics
implements ITmfStatistics {
    public static final String STATE_ID = "org.eclipse.linuxtools.tmf.statistics";
    private static final String STATS_STATE_FILENAME = "statistics.ht";
    private final ITmfTrace trace;
    private final ITmfStateSystem stats;

    public TmfStateStatistics() {
        this.stats = null;
        this.trace = null;
    }

    public TmfStateStatistics(ITmfTrace trace) throws TmfTraceException {
        this.trace = trace;
        String directory = TmfTraceManager.getSupplementaryFileDir(trace);
        File htFile = new File(String.valueOf(directory) + STATS_STATE_FILENAME);
        StatsStateProvider htInput = new StatsStateProvider(trace);
        this.stats = TmfStateSystemFactory.newFullHistory(htFile, htInput, false);
        this.registerStateSystems();
    }

    public TmfStateStatistics(ITmfTrace trace, File historyFile) throws TmfTraceException {
        this.trace = trace;
        StatsStateProvider htInput = new StatsStateProvider(trace);
        this.stats = TmfStateSystemFactory.newFullHistory(historyFile, htInput, true);
        this.registerStateSystems();
    }

    private void registerStateSystems() {
        this.trace.registerStateSystem(STATE_ID, this.stats);
    }

    @Override
    public void dispose() {
        this.stats.dispose();
    }

    @Override
    public void updateStats(final boolean isGlobal, final long start, final long end) {
        Thread statsThread = new Thread("Statistics update"){

            @Override
            public void run() {
                if (!TmfStateStatistics.this.stats.waitUntilBuilt()) {
                    return;
                }
                long total = TmfStateStatistics.this.getEventsInRange(start, end);
                Map<String, Long> map = TmfStateStatistics.this.getEventTypesInRange(start, end);
                TmfStatsUpdatedSignal sig = new TmfStatsUpdatedSignal(this, TmfStateStatistics.this.trace, isGlobal, total, map);
                TmfSignalManager.dispatchSignal(sig);
            }
        };
        statsThread.start();
    }

    @Override
    public List<Long> histogramQuery(long start, long end, int nb) {
        long count;
        long curTotal;
        LinkedList<Long> list = new LinkedList<Long>();
        long increment = (end - start) / (long)nb;
        if (!this.stats.waitUntilBuilt()) {
            return null;
        }
        long prevTotal = start == this.stats.getStartTime() ? 0L : this.getEventCountAt(start);
        long curTime = start + increment;
        int i = 0;
        while (i < nb - 1) {
            curTotal = this.getEventCountAt(curTime);
            count = curTotal - prevTotal;
            list.add(count);
            curTime += increment;
            prevTotal = curTotal;
            ++i;
        }
        curTotal = this.getEventCountAt(end);
        count = curTotal - prevTotal;
        list.add(count);
        return list;
    }

    @Override
    public long getEventsTotal() {
        this.stats.waitUntilBuilt();
        long endTime = this.stats.getCurrentEndTime();
        int count = 0;
        try {
            int quark = this.stats.getQuarkAbsolute("total");
            count = this.stats.querySingleState(endTime, quark).getStateValue().unboxInt();
        }
        catch (TimeRangeException e) {
            return 0L;
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    public Map<String, Long> getEventTypesTotal() {
        this.stats.waitUntilBuilt();
        HashMap<String, Long> map = new HashMap<String, Long>();
        long endTime = this.stats.getCurrentEndTime();
        try {
            int quark = this.stats.getQuarkAbsolute("event_types");
            List<Integer> quarks = this.stats.getSubAttributes(quark, false);
            List<ITmfStateInterval> endState = this.stats.queryFullState(endTime);
            for (int typeQuark : quarks) {
                String curEventName = this.stats.getAttributeName(typeQuark);
                long eventCount = endState.get(typeQuark).getStateValue().unboxInt();
                map.put(curEventName, eventCount);
            }
        }
        catch (TimeRangeException quark) {
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public long getEventsInRange(long start, long end) {
        this.stats.waitUntilBuilt();
        long startCount = start == this.stats.getStartTime() ? 0L : this.getEventCountAt(start - 1L);
        long endCount = this.getEventCountAt(end);
        return endCount - startCount;
    }

    @Override
    public Map<String, Long> getEventTypesInRange(long start, long end) {
        this.stats.waitUntilBuilt();
        HashMap<String, Long> map = new HashMap<String, Long>();
        long startTime = this.checkStartTime(start);
        long endTime = this.checkEndTime(end);
        try {
            int quark = this.stats.getQuarkAbsolute("event_types");
            List<Integer> quarks = this.stats.getSubAttributes(quark, false);
            List<ITmfStateInterval> endState = this.stats.queryFullState(endTime);
            if (startTime == this.stats.getStartTime()) {
                for (int typeQuark : quarks) {
                    String curEventName = this.stats.getAttributeName(typeQuark);
                    long eventCount = endState.get(typeQuark).getStateValue().unboxInt();
                    if (eventCount == -1L) {
                        eventCount = 0L;
                    }
                    map.put(curEventName, eventCount);
                }
            } else {
                List<ITmfStateInterval> startState = this.stats.queryFullState(startTime - 1L);
                for (int typeQuark : quarks) {
                    String curEventName = this.stats.getAttributeName(typeQuark);
                    long countAtStart = startState.get(typeQuark).getStateValue().unboxInt();
                    long countAtEnd = endState.get(typeQuark).getStateValue().unboxInt();
                    if (countAtStart == -1L) {
                        countAtStart = 0L;
                    }
                    if (countAtEnd == -1L) {
                        countAtEnd = 0L;
                    }
                    long eventCount = countAtEnd - countAtStart;
                    map.put(curEventName, eventCount);
                }
            }
        }
        catch (TimeRangeException quark) {
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException e) {
            e.printStackTrace();
        }
        return map;
    }

    private long getEventCountAt(long timestamp) {
        long ts = this.checkStartTime(timestamp);
        ts = this.checkEndTime(ts);
        try {
            int quark = this.stats.getQuarkAbsolute("total");
            long count = this.stats.querySingleState(ts, quark).getStateValue().unboxInt();
            return count;
        }
        catch (TimeRangeException quark) {
        }
        catch (AttributeNotFoundException e) {
            e.printStackTrace();
        }
        catch (StateValueTypeException e) {
            e.printStackTrace();
        }
        catch (StateSystemDisposedException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    private long checkStartTime(long initialStart) {
        long start = initialStart;
        if (start < this.stats.getStartTime()) {
            return this.stats.getStartTime();
        }
        return start;
    }

    private long checkEndTime(long initialEnd) {
        long end = initialEnd;
        if (end > this.stats.getCurrentEndTime()) {
            return this.stats.getCurrentEndTime();
        }
        return end;
    }

    public static class Attributes {
        public static final String TOTAL = "total";
        public static final String EVENT_TYPES = "event_types";
    }
}

