/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.annotatedsourceeditor;

import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.ISTAnnotationColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class STRulerColumn
implements IVerticalRulerColumn {
    private CompositeRuler fParentRuler;
    private ITextViewer fCachedTextViewer;
    private StyledText fCachedTextWidget;
    private Canvas fCanvas;
    private int fScrollPos;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private Font fFont;
    private int[] fIndentation;
    private boolean fSensitiveToTextChanges = false;
    private Color fForeground;
    private Color fBackground;
    private int fCachedNumberOfDigits = -1;
    private boolean fRelayoutRequired = false;
    private final Object fRunnableLock = new Object();
    private boolean fIsRunnablePosted = false;
    private final Runnable fRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = STRulerColumn.this.fRunnableLock;
            synchronized (object) {
                STRulerColumn.this.fIsRunnablePosted = false;
            }
            STRulerColumn.this.redraw();
        }
    };
    private MouseHandler fMouseHandler;
    private final ISTAnnotationColumn annotationColumn;

    public STRulerColumn(ISTAnnotationColumn ac) {
        this.annotationColumn = ac;
    }

    public ISTAnnotationColumn getSTAnnotationColumn() {
        return this.annotationColumn;
    }

    public void setForeground(Color foreground) {
        this.fForeground = foreground;
    }

    protected Color getForeground() {
        return this.fForeground;
    }

    public void setBackground(Color background) {
        this.fBackground = background;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        }
    }

    protected Color getBackground(Display display) {
        if (this.fBackground == null) {
            return display.getSystemColor(25);
        }
        return this.fBackground;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fIndentation[0];
    }

    protected boolean updateNumberOfDigits() {
        if (this.fCachedTextViewer == null) {
            return false;
        }
        int digits = this.computeNumberOfDigits();
        if (this.fCachedNumberOfDigits != digits) {
            this.fCachedNumberOfDigits = digits;
            return true;
        }
        return false;
    }

    protected int computeNumberOfDigits() {
        IDocument document = this.fCachedTextViewer.getDocument();
        int lines = document == null ? 0 : document.getNumberOfLines();
        int digits = 0;
        int i = 0;
        while (i < lines) {
            String annotation = this.annotationColumn.getAnnotation(i);
            if (annotation.length() > digits) {
                digits = annotation.length();
            }
            ++i;
        }
        return digits;
    }

    protected void layout(boolean redraw) {
        ITextViewerExtension extension;
        Control control;
        if (!redraw) {
            this.fRelayoutRequired = true;
            return;
        }
        this.fRelayoutRequired = false;
        if (this.fCachedTextViewer instanceof ITextViewerExtension && (control = (extension = (ITextViewerExtension)this.fCachedTextViewer).getControl()) instanceof Composite && !control.isDisposed()) {
            Composite composite = (Composite)control;
            composite.layout(true);
        }
    }

    protected void computeIndentations() {
        if (this.fCanvas == null || this.fCanvas.isDisposed()) {
            return;
        }
        GC gc = new GC((Drawable)this.fCanvas);
        try {
            gc.setFont(this.fCanvas.getFont());
            this.fIndentation = new int[this.fCachedNumberOfDigits + 3];
            char[] nines = new char[this.fCachedNumberOfDigits + 2];
            Arrays.fill(nines, '9');
            String nineString = new String(nines);
            Point p = gc.stringExtent(nineString);
            this.fIndentation[0] = p.x;
            int i = 1;
            while (i <= this.fCachedNumberOfDigits) {
                p = gc.stringExtent(nineString.substring(0, i));
                this.fIndentation[i] = this.fIndentation[0] - p.x;
                ++i;
            }
        }
        finally {
            gc.dispose();
        }
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.fParentRuler = parentRuler;
        this.fCachedTextViewer = parentRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getTextWidget();
        this.fCanvas = new Canvas(parentControl, 2048);
        this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        this.fCanvas.setForeground(this.fForeground);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (STRulerColumn.this.fCachedTextViewer != null) {
                    STRulerColumn.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                STRulerColumn.this.handleDispose();
                STRulerColumn.this.fCachedTextViewer = null;
                STRulerColumn.this.fCachedTextWidget = null;
            }
        });
        this.fMouseHandler = new MouseHandler();
        this.fCanvas.addMouseListener((MouseListener)this.fMouseHandler);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)this.fMouseHandler);
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.addViewportListener((IViewportListener)this.fInternalListener);
            this.fCachedTextViewer.addTextListener((ITextListener)this.fInternalListener);
            if (this.fFont == null && this.fCachedTextWidget != null && !this.fCachedTextWidget.isDisposed()) {
                this.fFont = this.fCachedTextWidget.getFont();
            }
        }
        if (this.fFont != null) {
            this.fCanvas.setFont(this.fFont);
        }
        this.updateNumberOfDigits();
        this.computeIndentations();
        return this.fCanvas;
    }

    protected void handleDispose() {
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.removeViewportListener((IViewportListener)this.fInternalListener);
            this.fCachedTextViewer.removeTextListener((ITextListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        gc.setFont(this.fCanvas.getFont());
        if (this.fForeground != null) {
            gc.setForeground(this.fForeground);
        }
        try {
            gc.setBackground(this.getBackground(this.fCanvas.getDisplay()));
            gc.fillRectangle(0, 0, size.x, size.y);
            ILineRange visibleLines = JFaceTextUtil.getVisibleModelLines((ITextViewer)this.fCachedTextViewer);
            if (visibleLines == null) {
                return;
            }
            this.fScrollPos = this.fCachedTextWidget.getTopPixel();
            this.doPaint(gc, visibleLines);
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.fBuffer, 0, 0);
    }

    protected final boolean isViewerCompletelyShown() {
        return JFaceTextUtil.isShowingEntireContents((StyledText)this.fCachedTextWidget);
    }

    void doPaint(GC gc, ILineRange visibleLines) {
        Display display = this.fCachedTextWidget.getDisplay();
        int y = -JFaceTextUtil.getHiddenTopLinePixels((StyledText)this.fCachedTextWidget);
        int lastLine = STRulerColumn.end(visibleLines);
        int line = visibleLines.getStartLine();
        while (line < lastLine) {
            int widgetLine = JFaceTextUtil.modelLineToWidgetLine((ITextViewer)this.fCachedTextViewer, (int)line);
            if (widgetLine != -1) {
                int lineHeight = this.fCachedTextWidget.getLineHeight(this.fCachedTextWidget.getOffsetAtLine(widgetLine));
                this.paintLine(line, y, lineHeight, gc, display);
                y += lineHeight;
            }
            ++line;
        }
    }

    private static int end(ILineRange range) {
        return range.getStartLine() + range.getNumberOfLines();
    }

    protected String createDisplayString(int line) {
        return Integer.toString(line);
    }

    private int getBaselineBias(GC gc, int widgetLine) {
        int offset = this.fCachedTextWidget.getOffsetAtLine(widgetLine);
        int widgetBaseline = this.fCachedTextWidget.getBaseline(offset);
        FontMetrics fm = gc.getFontMetrics();
        int fontBaseline = fm.getAscent() + fm.getLeading();
        int baselineBias = widgetBaseline - fontBaseline;
        return Math.max(0, baselineBias);
    }

    protected void paintLine(int line, int y, int lineheight, GC gc, Display display) {
        int widgetLine = JFaceTextUtil.modelLineToWidgetLine((ITextViewer)this.fParentRuler.getTextViewer(), (int)line);
        int indentation = this.fCachedNumberOfDigits;
        int baselineBias = this.getBaselineBias(gc, widgetLine);
        String s = this.annotationColumn.getAnnotation(widgetLine);
        gc.drawString(s, indentation, y + baselineBias, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postRedraw() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            Object object = this.fRunnableLock;
            synchronized (object) {
                if (this.fIsRunnablePosted) {
                    return;
                }
                this.fIsRunnablePosted = true;
            }
            d.asyncExec(this.fRunnable);
        }
    }

    public void redraw() {
        if (this.fRelayoutRequired) {
            this.layout(true);
            return;
        }
        if (this.fCachedTextViewer != null && this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    public void setModel(IAnnotationModel model) {
    }

    public void setFont(Font font) {
        this.fFont = font;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setFont(this.fFont);
            this.updateNumberOfDigits();
            this.computeIndentations();
        }
    }

    protected CompositeRuler getParentRuler() {
        return this.fParentRuler;
    }

    class InternalListener
    implements IViewportListener,
    ITextListener {
        private boolean fCachedRedrawState = true;

        InternalListener() {
        }

        public void viewportChanged(int verticalPosition) {
            if (this.fCachedRedrawState && verticalPosition != STRulerColumn.this.fScrollPos) {
                STRulerColumn.this.redraw();
            }
        }

        public void textChanged(TextEvent event) {
            this.fCachedRedrawState = event.getViewerRedrawState();
            if (!this.fCachedRedrawState) {
                return;
            }
            if (STRulerColumn.this.updateNumberOfDigits()) {
                STRulerColumn.this.computeIndentations();
                STRulerColumn.this.layout(event.getViewerRedrawState());
                return;
            }
            boolean viewerCompletelyShown = STRulerColumn.this.isViewerCompletelyShown();
            if (viewerCompletelyShown || STRulerColumn.this.fSensitiveToTextChanges || event.getDocumentEvent() == null) {
                STRulerColumn.this.postRedraw();
            }
            STRulerColumn.this.fSensitiveToTextChanges = viewerCompletelyShown;
        }
    }

    class MouseHandler
    implements MouseListener,
    MouseMoveListener {
        private int fCachedViewportSize;
        private IRegion fStartLine;
        private int fStartLineNumber;
        private int fAutoScrollDirection;
        private boolean fIsListeningForMove = false;

        MouseHandler() {
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 1) {
                this.stopSelecting();
                this.stopAutoScroll();
            }
        }

        public void mouseDown(MouseEvent event) {
            STRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            if (event.button == 1) {
                this.startSelecting();
            }
        }

        public void mouseDoubleClick(MouseEvent event) {
            STRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            this.stopSelecting();
            this.stopAutoScroll();
        }

        public void mouseMove(MouseEvent event) {
            int newLine = STRulerColumn.this.fParentRuler.toDocumentLineNumber(event.y) + 1;
            if (this.fIsListeningForMove && !this.autoScroll(event)) {
                this.expandSelection(newLine);
            }
            STRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }

        private void startSelecting() {
            try {
                IDocument document = STRulerColumn.this.fCachedTextViewer.getDocument();
                this.fStartLineNumber = STRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                this.fStartLine = document.getLineInformation(this.fStartLineNumber);
                STRulerColumn.this.fCachedTextViewer.setSelectedRange(this.fStartLine.getOffset(), this.fStartLine.getLength());
                this.fIsListeningForMove = true;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void stopSelecting() {
            this.fIsListeningForMove = false;
        }

        private void expandSelection(int lineNumber) {
            try {
                IDocument document = STRulerColumn.this.fCachedTextViewer.getDocument();
                IRegion lineInfo = document.getLineInformation(lineNumber);
                int start = Math.min(this.fStartLine.getOffset(), lineInfo.getOffset());
                int end = Math.max(this.fStartLine.getOffset() + this.fStartLine.getLength(), lineInfo.getOffset() + lineInfo.getLength());
                if (lineNumber < this.fStartLineNumber) {
                    STRulerColumn.this.fCachedTextViewer.setSelectedRange(end, start - end);
                } else {
                    STRulerColumn.this.fCachedTextViewer.setSelectedRange(start, end - start);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private void stopAutoScroll() {
            this.fAutoScrollDirection = 0;
        }

        private boolean autoScroll(MouseEvent event) {
            Rectangle area = STRulerColumn.this.fCanvas.getClientArea();
            if (event.y > area.height) {
                this.autoScroll(1024);
                return true;
            }
            if (event.y < 0) {
                this.autoScroll(128);
                return true;
            }
            this.stopAutoScroll();
            return false;
        }

        private void autoScroll(int direction) {
            if (this.fAutoScrollDirection == direction) {
                return;
            }
            int TIMER_INTERVAL = 5;
            final Display display = STRulerColumn.this.fCanvas.getDisplay();
            Runnable timer = null;
            switch (direction) {
                case 128: {
                    timer = new Runnable(){

                        @Override
                        public void run() {
                            int top;
                            if (MouseHandler.this.fAutoScrollDirection == 128 && (top = MouseHandler.this.getInclusiveTopIndex()) > 0) {
                                STRulerColumn.this.fCachedTextViewer.setTopIndex(top - 1);
                                MouseHandler.this.expandSelection(top - 1);
                                display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                    break;
                }
                case 1024: {
                    timer = new Runnable(){

                        @Override
                        public void run() {
                            if (MouseHandler.this.fAutoScrollDirection == 1024) {
                                int top = MouseHandler.this.getInclusiveTopIndex();
                                STRulerColumn.this.fCachedTextViewer.setTopIndex(top + 1);
                                MouseHandler.this.expandSelection(top + 1 + MouseHandler.this.fCachedViewportSize);
                                display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                }
            }
            if (timer != null) {
                this.fAutoScrollDirection = direction;
                display.timerExec(5, timer);
            }
        }

        private int getInclusiveTopIndex() {
            if (STRulerColumn.this.fCachedTextWidget != null && !STRulerColumn.this.fCachedTextWidget.isDisposed()) {
                return JFaceTextUtil.getPartialTopIndex((ITextViewer)STRulerColumn.this.fCachedTextViewer);
            }
            return -1;
        }
    }
}

