/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Calendar;
import org.eclipse.linuxtools.systemtap.structures.TreeDefinitionNode;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.systemtapgui.SystemTapGUISettings;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public final class TreeSettings {
    private static long treeFileDate;
    private static TreeNode functions;
    private static TreeNode probes;
    private static final String fileName = "/TreeSettings.xml";
    private static File settingsFile;

    static {
        settingsFile = null;
    }

    private TreeSettings() {
    }

    public static long getTreeFileDate() {
        if (!TreeSettings.readData()) {
            return -1L;
        }
        return treeFileDate;
    }

    public static TreeNode getFunctionTree() {
        if (!TreeSettings.readData()) {
            return null;
        }
        return functions;
    }

    public static TreeNode getProbeTree() {
        if (!TreeSettings.readData()) {
            return null;
        }
        return probes;
    }

    public static boolean setTrees(TreeNode func, TreeNode probe) {
        if (func == null || probe == null) {
            return false;
        }
        functions = func;
        probes = probe;
        return TreeSettings.writeData();
    }

    private static boolean readData() {
        FileReader reader;
        block10: {
            if (settingsFile == null && !TreeSettings.openFile()) {
                return false;
            }
            reader = new FileReader(settingsFile);
            if (reader.ready()) break block10;
            reader.close();
            return false;
        }
        try {
            String d;
            XMLMemento data = XMLMemento.createReadRoot((Reader)reader, (String)"TreeSettings");
            IMemento child = data.getChild("functionTree");
            String s = child.getString("string");
            if ("<null>".equals(s)) {
                s = null;
            }
            if ("<null>".equals(d = child.getString("data"))) {
                d = null;
            }
            functions = new TreeNode((Object)d, s, false);
            TreeSettings.readTree(child, functions, 0);
            child = data.getChild("probeTree");
            s = child.getString("string");
            if ("<null>".equals(s)) {
                s = null;
            }
            if ("<null>".equals(d = child.getString("data"))) {
                d = null;
            }
            probes = new TreeNode((Object)d, s, false);
            TreeSettings.readTree(child, probes, 0);
            child = data.getChild("modifiedDate");
            treeFileDate = Long.parseLong(child.getString("date"));
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        catch (WorkbenchException we) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean writeData() {
        if (settingsFile == null && !TreeSettings.openFile()) {
            return false;
        }
        try {
            XMLMemento data = XMLMemento.createWriteRoot((String)"TreeSettings");
            IMemento child = data.createChild("functionTree");
            TreeSettings.writeTree(child, functions, 0);
            child = data.createChild("probeTree");
            TreeSettings.writeTree(child, probes, 0);
            child = data.createChild("modifiedDate");
            child.putString("date", Long.valueOf(Calendar.getInstance().getTimeInMillis()).toString());
            FileWriter writer = new FileWriter(settingsFile);
            data.save((Writer)writer);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static void writeTree(IMemento child, TreeNode tree, int depth) {
        if (tree.toString() == null) {
            child.putString("string", "<null>");
        } else {
            child.putString("string", tree.toString());
        }
        if (tree.getData() == null) {
            child.putString("data", "<null>");
        } else {
            child.putString("data", tree.getData().toString());
        }
        if (tree instanceof TreeDefinitionNode) {
            if (((TreeDefinitionNode)tree).getDefinition() == null) {
                child.putString("definition", "<null>");
            } else {
                child.putString("definition", ((TreeDefinitionNode)tree).getDefinition());
            }
        }
        child.putInteger("click", tree.isClickable() ? 1 : 0);
        int i = 0;
        while (i < tree.getChildCount()) {
            TreeSettings.writeTree(child.createChild("level" + depth), tree.getChildAt(i), depth + 1);
            ++i;
        }
    }

    private static void readTree(IMemento data, TreeNode parent, int depth) {
        IMemento[] children = data.getChildren("level" + depth);
        try {
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    TreeNode t;
                    boolean c;
                    String s = children[i].getString("string");
                    String d = children[i].getString("data");
                    String def = children[i].getString("definition");
                    boolean bl = c = children[i].getInteger("click") != 0;
                    if ("<null>".equals(s)) {
                        s = null;
                    }
                    if ("<null>".equals(d)) {
                        d = null;
                    }
                    if (def == null) {
                        t = new TreeNode((Object)d, s, c);
                    } else {
                        if ("<null>".equals(def)) {
                            def = null;
                        }
                        t = new TreeDefinitionNode((Object)d, s, def, c);
                    }
                    parent.add(t);
                    TreeSettings.readTree(children[i], t, depth + 1);
                    ++i;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static boolean openFile() {
        settingsFile = new File(String.valueOf(SystemTapGUISettings.settingsFolder.getAbsolutePath()) + fileName);
        try {
            if (!settingsFile.exists()) {
                settingsFile.getParentFile().mkdirs();
                settingsFile.createNewFile();
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }
}

