/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.valgrind.core;

import java.io.IOException;
import org.eclipse.linuxtools.internal.valgrind.core.Messages;
import org.eclipse.osgi.util.NLS;

public final class ValgrindParserUtils {
    private static final String DOT = ".";
    private static final String EMPTY_STRING = "";

    public static Long parseLongValue(String line, String delim) throws IOException {
        Long result = null;
        String[] parts = line.split(delim, 2);
        if (parts.length > 1 && ValgrindParserUtils.isNumber(parts[1])) {
            result = Long.parseLong(parts[1]);
        } else {
            ValgrindParserUtils.fail(line);
        }
        return result;
    }

    public static String parseStrValue(String line, String delim) throws IOException {
        String result = null;
        String[] parts = line.split(delim, 2);
        if (parts.length > 1) {
            result = parts[1];
        } else {
            ValgrindParserUtils.fail(line);
        }
        return result;
    }

    public static Integer parsePID(String filename, String prefix) throws IOException {
        String pidstr = filename.substring(prefix.length(), filename.lastIndexOf(DOT));
        if (ValgrindParserUtils.isNumber(pidstr)) {
            return new Integer(pidstr);
        }
        throw new IOException("Cannot parse PID from output file");
    }

    public static void fail(String line) throws IOException {
        throw new IOException(NLS.bind((String)Messages.getString("AbstractValgrindTextParser.Parsing_output_failed"), (Object)line));
    }

    public static boolean isNumber(String string) {
        boolean result = true;
        char[] chars = string.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isDigit(chars[i])) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public static Object[] parseFilename(String line) {
        String filename = null;
        int lineNo = 0;
        int ix = line.lastIndexOf("(");
        if (ix >= 0) {
            String part = line.substring(ix, line.length());
            ix = (part = part.substring(1, part.length() - 1)).lastIndexOf(":");
            if (ix >= 0) {
                String strLineNo = part.substring(ix + 1);
                if (ValgrindParserUtils.isNumber(strLineNo)) {
                    lineNo = Integer.parseInt(strLineNo);
                    filename = part.substring(0, ix);
                }
            } else {
                part = part.replaceFirst("^in ", EMPTY_STRING);
                filename = part = part.replaceFirst("^within ", EMPTY_STRING);
            }
        }
        return new Object[]{filename, lineNo};
    }
}

