/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.wizards.RenameTraceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RenameTraceHandler
extends AbstractHandler {
    private TmfTraceElement fTrace = null;

    public boolean isEnabled() {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fTrace = null;
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfTraceElement) {
            this.fTrace = (TmfTraceElement)element;
        }
        return this.fTrace != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        this.fTrace = this.fTrace.getElementUnderTraceFolder();
        Shell shell = window.getShell();
        TmfTraceFolder traceFolder = (TmfTraceFolder)this.fTrace.getParent();
        TmfTraceElement oldTrace = this.fTrace;
        RenameTraceDialog dialog = new RenameTraceDialog(shell, this.fTrace);
        if (dialog.open() != 0) {
            return null;
        }
        TmfTraceElement newTrace = null;
        String newTraceName = dialog.getNewTraceName();
        for (ITmfProjectModelElement element : traceFolder.getChildren()) {
            TmfTraceElement tmfTraceElement;
            if (!(element instanceof TmfTraceElement) || !(tmfTraceElement = (TmfTraceElement)element).getName().equals(newTraceName)) continue;
            newTrace = tmfTraceElement;
            break;
        }
        if (newTrace == null) {
            return null;
        }
        ArrayList<1> removeOps = new ArrayList<1>();
        TmfExperimentFolder experimentFolder = newTrace.getProject().getExperimentsFolder();
        for (final ITmfProjectModelElement iTmfProjectModelElement : experimentFolder.getChildren()) {
            for (final ITmfProjectModelElement trace : iTmfProjectModelElement.getChildren()) {
                if (!trace.getName().equals(oldTrace.getName())) continue;
                RenameTraceHandler.createTraceLink(newTrace, iTmfProjectModelElement);
                removeOps.add(new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        iTmfProjectModelElement.removeChild(trace);
                        trace.getResource().delete(true, null);
                        iTmfProjectModelElement.refresh();
                    }
                });
            }
        }
        for (WorkspaceModifyOperation workspaceModifyOperation : removeOps) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)workspaceModifyOperation);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void createTraceLink(TmfTraceElement trace, ITmfProjectModelElement experiment) {
        try {
            IResource resource = trace.getResource();
            IPath location = resource.getLocation();
            String traceBundle = resource.getPersistentProperty(TmfCommonConstants.TRACEBUNDLE);
            String traceTypeId = resource.getPersistentProperty(TmfCommonConstants.TRACETYPE);
            String traceIcon = resource.getPersistentProperty(TmfCommonConstants.TRACEICON);
            if (resource instanceof IFolder) {
                IFolder folder = ((IFolder)experiment.getResource()).getFolder(trace.getName());
                if (ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)folder, location).isOK()) {
                    folder.createLink(location, 256, null);
                    folder.setPersistentProperty(TmfCommonConstants.TRACEBUNDLE, traceBundle);
                    folder.setPersistentProperty(TmfCommonConstants.TRACETYPE, traceTypeId);
                    folder.setPersistentProperty(TmfCommonConstants.TRACEICON, traceIcon);
                } else {
                    Activator.getDefault().logError("RenamaeTraceHandler: Invalid Trace Location: " + location);
                }
            } else {
                IFile file = ((IFolder)experiment.getResource()).getFile(trace.getName());
                if (ResourcesPlugin.getWorkspace().validateLinkLocation((IResource)file, location).isOK()) {
                    file.createLink(location, 256, null);
                    file.setPersistentProperty(TmfCommonConstants.TRACEBUNDLE, traceBundle);
                    file.setPersistentProperty(TmfCommonConstants.TRACETYPE, traceTypeId);
                    file.setPersistentProperty(TmfCommonConstants.TRACEICON, traceIcon);
                } else {
                    Activator.getDefault().logError("RenamaeTraceHandler: Invalid Trace Location: " + location);
                }
            }
            experiment.refresh();
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error renaming trace" + trace.getName(), e);
        }
    }
}

