/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.model.TmfImportHelper;
import org.eclipse.linuxtools.internal.tmf.ui.project.model.TmfTraceImportException;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.project.model.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceType;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceTypeHelper;
import org.eclipse.linuxtools.tmf.ui.project.model.TraceUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class TmfOpenTraceHelper {
    private static final String ENDL = System.getProperty("line.separator");

    public IStatus openTraceFromPath(String projectRoot, String path, Shell shell) throws CoreException {
        TmfTraceType tt = TmfTraceType.getInstance();
        TraceTypeHelper traceTypeToSet = null;
        try {
            traceTypeToSet = tt.selectTraceType(path, shell);
        }
        catch (TmfTraceImportException e) {
            MessageBox mb = new MessageBox(shell);
            mb.setMessage(e.getMessage());
            mb.open();
            return new Status(4, "org.eclipse.linuxtools.tmf.ui", e.getMessage());
        }
        if (traceTypeToSet == null) {
            return Status.CANCEL_STATUS;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectRoot);
        IFolder folder = project.getFolder("Traces");
        String traceName = TmfOpenTraceHelper.getTraceName(path, folder);
        if (TmfOpenTraceHelper.traceExists(path, folder)) {
            return TmfOpenTraceHelper.openTraceFromProject(projectRoot, traceName);
        }
        IPath tracePath = folder.getFullPath().append(traceName);
        IPath pathString = Path.fromOSString((String)path);
        IResource linkedTrace = TmfImportHelper.createLink(folder, pathString, traceName);
        if (linkedTrace != null && linkedTrace.exists()) {
            IStatus ret = TmfTraceType.setTraceType(tracePath, traceTypeToSet);
            if (ret.isOK()) {
                ret = TmfOpenTraceHelper.openTraceFromProject(projectRoot, traceName);
            }
            return ret;
        }
        return new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TmfOpenTraceHelper_LinkFailed);
    }

    private static boolean traceExists(String file, IFolder folder) {
        String val = TmfOpenTraceHelper.getTraceName(file, folder);
        return folder.findMember(val) != null;
    }

    private static boolean isWrongMember(IFolder folder, String ret, File traceFile) {
        IResource candidate = folder.findMember(ret);
        if (candidate != null) {
            IPath rawLocation = candidate.getRawLocation();
            File file = rawLocation.toFile();
            return !file.equals(traceFile);
        }
        return false;
    }

    private static String getTraceName(String file, IFolder folder) {
        File traceFile = new File(file);
        String ret = traceFile.getName();
        int i = 2;
        while (TmfOpenTraceHelper.isWrongMember(folder, ret, traceFile)) {
            ret = String.valueOf(traceFile.getName()) + '(' + i + ')';
            ++i;
        }
        return ret;
    }

    public static IStatus openTraceFromProject(String projectRoot, String traceName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectRoot);
        TmfImportHelper.forceFolderRefresh(project.getFolder("Traces"));
        TmfProjectElement project2 = TmfProjectRegistry.getProject(project, true);
        TmfTraceFolder tracesFolder = project2.getTracesFolder();
        List<TmfTraceElement> traces = tracesFolder.getTraces();
        TmfTraceElement found = null;
        for (TmfTraceElement candidate : traces) {
            if (!candidate.getName().equals(traceName)) continue;
            found = candidate;
        }
        if (found == null) {
            return new Status(4, "org.eclipse.linuxtools.tmf.ui", Messages.TmfOpenTraceHelper_ErrorOpeningTrace);
        }
        TmfOpenTraceHelper.openTraceFromElement(found);
        return Status.OK_STATUS;
    }

    public static void openTraceFromElement(final TmfTraceElement traceElement) {
        IFile file;
        try {
            file = traceElement.createBookmarksFile();
        }
        catch (CoreException e) {
            Activator.getDefault().logError(String.valueOf(Messages.TmfOpenTraceHelper_ErrorOpeningTrace) + ' ' + traceElement.getName());
            TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenTrace, String.valueOf(Messages.TmfOpenTraceHelper_ErrorTrace) + ENDL + ENDL + e.getMessage());
            return;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        final IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = TmfOpenTraceHelper.findEditor((IEditorInput)new FileEditorInput(file), true);
        if (editor != null) {
            activePage.activate((IWorkbenchPart)editor);
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                final ITmfTrace trace = traceElement.instantiateTrace();
                ITmfEvent traceEvent = traceElement.instantiateEvent();
                if (trace == null || traceEvent == null) {
                    TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenTrace, Messages.TmfOpenTraceHelper_NoTraceType);
                    if (trace != null) {
                        trace.dispose();
                    }
                    return;
                }
                try {
                    trace.initTrace(traceElement.getResource(), traceElement.getLocation().getPath(), traceEvent.getClass());
                }
                catch (TmfTraceException e) {
                    TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenTrace, String.valueOf(Messages.TmfOpenTraceHelper_InitError) + ENDL + ENDL + (Object)((Object)e));
                    trace.dispose();
                    return;
                }
                String traceEditorId = traceElement.getEditorId();
                final String editorId = traceEditorId != null ? traceEditorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                final TmfEditorInput editorInput = new TmfEditorInput(file, trace);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            activePage.openEditor(editorInput, editorId);
                            IDE.setDefaultEditor((IFile)file, (String)editorId);
                        }
                        catch (PartInitException e) {
                            TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenTrace, String.valueOf(Messages.TmfOpenTraceHelper_ErrorOpeningTrace) + ENDL + ENDL + e.getMessage());
                            Activator.getDefault().logError(String.valueOf(Messages.TmfOpenTraceHelper_ErrorOpeningTrace) + ' ' + traceElement.getName());
                            trace.dispose();
                        }
                    }
                });
            }
        };
        thread.start();
    }

    public static void openExperimentFromElement(final TmfExperimentElement experimentElement) {
        IFile file;
        try {
            file = experimentElement.createBookmarksFile();
        }
        catch (CoreException e) {
            Activator.getDefault().logError(String.valueOf(Messages.TmfOpenTraceHelper_ErrorOpeningExperiment) + ' ' + experimentElement.getName());
            TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenExperiment, String.valueOf(Messages.TmfOpenTraceHelper_ErrorExperiment) + ENDL + ENDL + e.getMessage());
            return;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        final IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = TmfOpenTraceHelper.findEditor((IEditorInput)new FileEditorInput(file), true);
        if (editor != null) {
            activePage.activate((IWorkbenchPart)editor);
            return;
        }
        Thread thread = new Thread(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                experimentElement.refreshSupplementaryFolder();
                traceEntries = experimentElement.getTraces();
                nbTraces = traceEntries.size();
                cacheSize = 0x7FFFFFFF;
                commonEditorId = null;
                traces = new ITmfTrace[nbTraces];
                i = 0;
                while (i < nbTraces) {
                    block10: {
                        element = traceEntries.get(i);
                        element = element.getElementUnderTraceFolder();
                        trace = element.instantiateTrace();
                        traceEvent = element.instantiateEvent();
                        if (trace == null || traceEvent == null) {
                            TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenExperiment, String.valueOf(Messages.TmfOpenTraceHelper_ErrorOpeningTrace) + ' ' + element.getName() + TmfOpenTraceHelper.access$0() + Messages.TmfOpenTraceHelper_NoTraceType);
                            j = 0;
                            while (j < i) {
                                traces[j].dispose();
                                ++j;
                            }
                            if (trace != null) {
                                trace.dispose();
                            }
                            return;
                        }
                        try {
                            trace.initTrace(element.getResource(), element.getLocation().getPath(), traceEvent.getClass());
                            break block10;
                        }
                        catch (TmfTraceException e) {
                            TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenExperiment, String.valueOf(element.getName()) + ':' + ' ' + Messages.TmfOpenTraceHelper_InitError + TmfOpenTraceHelper.access$0() + TmfOpenTraceHelper.access$0() + (Object)e);
                            j = 0;
                            ** while (j < i)
                        }
lbl-1000:
                        // 1 sources

                        {
                            traces[j].dispose();
                            ++j;
                            continue;
                        }
lbl33:
                        // 1 sources

                        trace.dispose();
                        return;
                    }
                    cacheSize = Math.min(cacheSize, trace.getCacheSize());
                    editorId = element.getEditorId();
                    if (commonEditorId == null) {
                        commonEditorId = editorId != null ? editorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                    } else if (!commonEditorId.equals(editorId)) {
                        commonEditorId = "org.eclipse.linuxtools.tmf.ui.editors.events";
                    }
                    traces[i] = trace;
                    ++i;
                }
                experiment = new TmfExperiment(ITmfEvent.class, experimentElement.getName(), traces, cacheSize, (IResource)experimentElement.getResource());
                experiment.setBookmarksFile(file);
                editorId = commonEditorId;
                editorInput = new TmfEditorInput(file, (ITmfTrace)experiment);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            activePage.openEditor(editorInput, editorId);
                            IDE.setDefaultEditor((IFile)file, (String)editorId);
                        }
                        catch (PartInitException e) {
                            TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenExperiment, String.valueOf(Messages.TmfOpenTraceHelper_ErrorOpeningExperiment) + ENDL + ENDL + e.getMessage());
                            Activator.getDefault().logError(String.valueOf(Messages.TmfOpenTraceHelper_ErrorOpeningExperiment) + ' ' + experimentElement.getName());
                            experiment.dispose();
                        }
                    }
                });
            }
        };
        thread.start();
    }

    private static IEditorPart findEditor(IEditorInput input, boolean restore) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                IEditorInput editorInput = editorReference.getEditorInput();
                if (editorInput.equals(input)) {
                    return editorReference.getEditor(restore);
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static void reopenTraceFromElement(final TmfTraceElement traceElement, final IReusableEditor editor) {
        IFile file;
        try {
            file = traceElement.createBookmarksFile();
        }
        catch (CoreException e) {
            Activator.getDefault().logError(String.valueOf(Messages.TmfOpenTraceHelper_ErrorOpeningTrace) + ' ' + traceElement.getName());
            TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenTrace, String.valueOf(Messages.TmfOpenTraceHelper_ErrorTrace) + ENDL + ENDL + e.getMessage());
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                ITmfTrace trace = traceElement.instantiateTrace();
                ITmfEvent traceEvent = traceElement.instantiateEvent();
                if (trace == null || traceEvent == null) {
                    TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenTrace, Messages.TmfOpenTraceHelper_NoTraceType);
                    if (trace != null) {
                        trace.dispose();
                    }
                    return;
                }
                try {
                    trace.initTrace(traceElement.getResource(), traceElement.getLocation().getPath(), traceEvent.getClass());
                }
                catch (TmfTraceException e) {
                    TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenTrace, String.valueOf(Messages.TmfOpenTraceHelper_InitError) + ENDL + ENDL + (Object)((Object)e));
                    trace.dispose();
                    return;
                }
                final TmfEditorInput editorInput = new TmfEditorInput(file, trace);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbench wb = PlatformUI.getWorkbench();
                        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                        activePage.reuseEditor(editor, editorInput);
                        activePage.activate((IWorkbenchPart)editor);
                    }
                });
            }
        };
        thread.start();
    }

    public static void reopenExperimentFromElement(final TmfExperimentElement experimentElement, final IReusableEditor editor) {
        IFile file;
        try {
            file = experimentElement.createBookmarksFile();
        }
        catch (CoreException e) {
            Activator.getDefault().logError(String.valueOf(Messages.TmfOpenTraceHelper_ErrorOpeningExperiment) + ' ' + experimentElement.getName());
            TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenExperiment, String.valueOf(Messages.TmfOpenTraceHelper_ErrorExperiment) + ENDL + ENDL + e.getMessage());
            return;
        }
        Thread thread = new Thread(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                experimentElement.refreshSupplementaryFolder();
                traceEntries = experimentElement.getTraces();
                nbTraces = traceEntries.size();
                cacheSize = 0x7FFFFFFF;
                traces = new ITmfTrace[nbTraces];
                i = 0;
                while (i < nbTraces) {
                    block7: {
                        element = traceEntries.get(i);
                        element = element.getElementUnderTraceFolder();
                        trace = element.instantiateTrace();
                        traceEvent = element.instantiateEvent();
                        if (trace == null || traceEvent == null) {
                            TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenExperiment, String.valueOf(Messages.TmfOpenTraceHelper_ErrorOpeningTrace) + ' ' + element.getName() + TmfOpenTraceHelper.access$0() + Messages.TmfOpenTraceHelper_NoTraceType);
                            j = 0;
                            while (j < i) {
                                traces[j].dispose();
                                ++j;
                            }
                            if (trace != null) {
                                trace.dispose();
                            }
                            return;
                        }
                        try {
                            trace.initTrace(element.getResource(), element.getLocation().getPath(), traceEvent.getClass());
                            break block7;
                        }
                        catch (TmfTraceException e) {
                            TraceUtils.displayErrorMsg(Messages.TmfOpenTraceHelper_OpenExperiment, String.valueOf(element.getName()) + ':' + ' ' + Messages.TmfOpenTraceHelper_InitError + TmfOpenTraceHelper.access$0() + TmfOpenTraceHelper.access$0() + (Object)e);
                            j = 0;
                            ** while (j < i)
                        }
lbl-1000:
                        // 1 sources

                        {
                            traces[j].dispose();
                            ++j;
                            continue;
                        }
lbl32:
                        // 1 sources

                        trace.dispose();
                        return;
                    }
                    cacheSize = Math.min(cacheSize, trace.getCacheSize());
                    traces[i] = trace;
                    ++i;
                }
                experiment = new TmfExperiment(ITmfEvent.class, experimentElement.getName(), traces, cacheSize, (IResource)experimentElement.getResource());
                experiment.setBookmarksFile(file);
                editorInput = new TmfEditorInput(file, (ITmfTrace)experiment);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbench wb = PlatformUI.getWorkbench();
                        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                        activePage.reuseEditor(editor, editorInput);
                        activePage.activate((IWorkbenchPart)editor);
                    }
                });
            }
        };
        thread.start();
    }
}

