/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.dialogs;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemCopyProfileDialog
extends SystemPromptDialog {
    private Text newName;
    private Button makeActiveCB;
    private String newNameString;
    private String inputName;
    private boolean makeActive = false;
    private SystemMessage errorMessage;
    private ISystemValidator nameValidator;
    private boolean initialized = false;
    private ISystemProfile profile;

    public SystemCopyProfileDialog(Shell shell) {
        this(shell, (ISystemProfile)null);
    }

    public SystemCopyProfileDialog(Shell shell, ISystemProfile profile) {
        super(shell, SystemResources.RESID_COPY_PROFILE_TITLE);
        this.profile = profile;
        if (profile != null) {
            this.setInputObject(profile);
        }
        this.nameValidator = ValidatorFactory.getProfileNameValidator(null);
        this.setHelp("org.eclipse.rse.ui.drnp0000");
    }

    protected ISystemMessageLine createMessageLine(Composite c) {
        super.createMessageLine(c);
        return this.fMessageLine;
    }

    protected Control getInitialFocusControl() {
        return this.newName;
    }

    public void setNameValidator(ISystemValidator nv) {
        this.nameValidator = nv;
    }

    protected Control createInner(Composite parent) {
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        this.newName = SystemWidgetHelpers.createLabeledTextField(composite_prompts, null, SystemResources.RESID_COPY_PROFILE_PROMPT_LABEL, SystemResources.RESID_COPY_PROFILE_PROMPT_TOOLTIP);
        this.newName.setTextLimit(100);
        this.makeActiveCB = SystemWidgetHelpers.createCheckBox(composite_prompts, nbrColumns, null, SystemResources.RESID_NEWPROFILE_MAKEACTIVE_LABEL, SystemResources.RESID_NEWPROFILE_MAKEACTIVE_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.newName, "org.eclipse.rse.ui.drnp0002");
        SystemWidgetHelpers.setHelp((Control)this.makeActiveCB, "org.eclipse.rse.ui.drnp0003");
        this.initialize();
        this.newName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemCopyProfileDialog.this.validateNameInput();
            }
        });
        return composite_prompts;
    }

    public void setInputObject(Object inputObject) {
        super.setInputObject(inputObject);
        if (inputObject instanceof SystemSimpleContentElement) {
            SystemSimpleContentElement element = (SystemSimpleContentElement)inputObject;
            this.inputName = element.getName();
        } else if (inputObject instanceof ISelection) {
            SystemSimpleContentElement element = (SystemSimpleContentElement)((IStructuredSelection)inputObject).getFirstElement();
            this.inputName = element.getName();
        } else if (inputObject instanceof ISystemProfile) {
            this.inputName = this.profile.getName();
        }
        this.initialize();
    }

    protected void initialize() {
        if (!this.initialized && this.newName != null && this.inputName != null) {
            this.initialized = true;
            this.newName.setText(this.inputName);
            this.newName.selectAll();
            if (this.makeActiveCB != null) {
                this.makeActiveCB.setSelection(true);
            }
            this.setPageComplete(false);
        }
    }

    protected boolean processOK() {
        this.newNameString = this.newName.getText().trim();
        boolean closeDialog = this.verify();
        if (closeDialog) {
            if (this.makeActiveCB != null) {
                this.makeActive = this.makeActiveCB.getSelection();
            }
            this.setOutputObject(this.newNameString);
        }
        return closeDialog;
    }

    public boolean verify() {
        this.clearErrorMessage();
        this.errorMessage = this.validateNameInput();
        if (this.errorMessage != null) {
            this.newName.setFocus();
        }
        return this.errorMessage == null;
    }

    protected SystemMessage validateNameInput() {
        this.errorMessage = this.nameValidator.validate(this.newName.getText());
        if (this.errorMessage != null) {
            this.setErrorMessage(this.errorMessage);
        } else {
            this.clearErrorMessage();
        }
        this.setPageComplete();
        return this.errorMessage;
    }

    public boolean isPageComplete() {
        boolean pageComplete = false;
        if (this.errorMessage == null) {
            String theNewName = this.newName.getText().trim();
            pageComplete = theNewName.length() > 0 && !theNewName.equalsIgnoreCase(this.inputName);
        }
        return pageComplete;
    }

    public void setPageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    public String getNewName() {
        return this.newNameString;
    }

    public boolean getMakeActive() {
        return this.makeActive;
    }

    public String[] getNewNameArray() {
        String[] newNames = new String[]{this.newNameString};
        return newNames;
    }
}

