/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SelectTraceTypeHandler
extends AbstractHandler {
    private static final String BUNDLE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.bundle";
    private static final String TYPE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.type";
    private static final String ICON_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.icon";
    private TreeSelection fSelection = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return false;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fSelection = null;
        if (selection instanceof TreeSelection) {
            this.fSelection = (TreeSelection)selection;
            for (Object element : this.fSelection) {
                if (element instanceof TmfTraceElement) continue;
                return false;
            }
        }
        return !selection.isEmpty();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        boolean ok = true;
        for (Object element : this.fSelection.toList()) {
            TmfTraceElement trace = (TmfTraceElement)element;
            IResource resource = (trace = trace.getElementUnderTraceFolder()).getResource();
            if (resource == null) continue;
            try {
                String bundleName = event.getParameter(BUNDLE_PARAMETER);
                String traceType = event.getParameter(TYPE_PARAMETER);
                String iconUrl = event.getParameter(ICON_PARAMETER);
                String previousTraceType = trace.getTraceType();
                IStatus status = SelectTraceTypeHandler.propagateProperties(trace, bundleName, traceType, iconUrl);
                ok &= status.isOK();
                if (status.isOK()) {
                    if (previousTraceType == null || traceType.equals(previousTraceType)) continue;
                    trace.closeEditors();
                    trace.deleteSupplementaryResources();
                    continue;
                }
                statuses.add(status);
            }
            catch (CoreException e) {
                Activator.getDefault().logError(String.valueOf(Messages.SelectTraceTypeHandler_ErrorSelectingTrace) + trace.getName(), e);
            }
        }
        ((ITmfProjectModelElement)this.fSelection.getFirstElement()).getProject().refresh();
        if (!ok) {
            Shell shell = window.getShell();
            MultiStatus info = new MultiStatus("org.eclipse.linuxtools.tmf.ui", 1, Messages.SelectTraceTypeHandler_TraceFailedValidation, null);
            if (statuses.size() > 1) {
                info = new MultiStatus("org.eclipse.linuxtools.tmf.ui", 1, Messages.SelectTraceTypeHandler_TracesFailedValidation, null);
            }
            for (IStatus status : statuses) {
                info.add(status);
            }
            ErrorDialog.openError((Shell)shell, (String)Messages.SelectTraceTypeHandler_Title, (String)Messages.SelectTraceTypeHandler_InvalidTraceType, (IStatus)info);
        }
        return null;
    }

    private static IStatus propagateProperties(TmfTraceElement trace, String bundleName, String traceType, String iconUrl) throws CoreException {
        IResource svResource = trace.getResource();
        String svBundleName = svResource.getPersistentProperty(TmfCommonConstants.TRACEBUNDLE);
        String svTraceType = svResource.getPersistentProperty(TmfCommonConstants.TRACETYPE);
        String svIconUrl = svResource.getPersistentProperty(TmfCommonConstants.TRACEICON);
        SelectTraceTypeHandler.setProperties(trace.getResource(), bundleName, traceType, iconUrl);
        trace.refreshTraceType();
        IStatus validateTraceType = SelectTraceTypeHandler.validateTraceType(trace);
        if (!validateTraceType.isOK()) {
            SelectTraceTypeHandler.setProperties(trace.getResource(), svBundleName, svTraceType, svIconUrl);
            trace.refreshTraceType();
            return validateTraceType;
        }
        trace.refreshTraceType();
        if (trace.getParent() instanceof TmfTraceFolder) {
            TmfExperimentFolder experimentFolder = trace.getProject().getExperimentsFolder();
            for (ITmfProjectModelElement experiment : experimentFolder.getChildren()) {
                for (ITmfProjectModelElement child : experiment.getChildren()) {
                    TmfTraceElement linkedTrace;
                    if (!(child instanceof TmfTraceElement) || !(linkedTrace = (TmfTraceElement)child).getName().equals(trace.getName())) continue;
                    IResource resource = linkedTrace.getResource();
                    SelectTraceTypeHandler.setProperties(resource, bundleName, traceType, iconUrl);
                    linkedTrace.refreshTraceType();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private static void setProperties(IResource resource, String bundleName, String traceType, String iconUrl) throws CoreException {
        resource.setPersistentProperty(TmfCommonConstants.TRACEBUNDLE, bundleName);
        resource.setPersistentProperty(TmfCommonConstants.TRACETYPE, traceType);
        resource.setPersistentProperty(TmfCommonConstants.TRACEICON, iconUrl);
    }

    private static IStatus validateTraceType(TmfTraceElement trace) {
        IProject project = trace.getProject().getResource();
        ITmfTrace tmfTrace = null;
        Object validate = null;
        try {
            tmfTrace = trace.instantiateTrace();
            validate = tmfTrace != null ? tmfTrace.validate(project, trace.getLocation().getPath()) : new Status(4, trace.getName(), "File does not exist : " + trace.getLocation().getPath());
        }
        finally {
            if (tmfTrace != null) {
                tmfTrace.dispose();
            }
        }
        if (validate == null) {
            validate = new Status(4, "unknown", "unknown");
        }
        return validate;
    }
}

