/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.partial;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.AttributeTree;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.StateSystem;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.NullBackend;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;

public class PartialStateSystem
extends StateSystem {
    private static final String ERR_MSG = "Partial state system should not modify the attribute tree!";
    private final CountDownLatch ssAssignedLatch = new CountDownLatch(1);
    private final Lock queryLock = new ReentrantLock();
    private StateSystem realStateSystem = null;

    public PartialStateSystem() {
        super(new NullBackend());
    }

    public void assignUpstream(StateSystem ss) {
        this.realStateSystem = ss;
        this.ssAssignedLatch.countDown();
    }

    ITmfStateSystem getUpstreamSS() {
        return this.realStateSystem;
    }

    @Override
    public void replaceOngoingState(List<ITmfStateInterval> ongoingIntervals) {
        super.replaceOngoingState(ongoingIntervals);
    }

    public void takeQueryLock() {
        try {
            this.queryLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void releaseQueryLock() {
        this.queryLock.unlock();
    }

    @Override
    public AttributeTree getAttributeTree() {
        this.waitUntilReady();
        return this.realStateSystem.getAttributeTree();
    }

    @Override
    protected void addEmptyAttribute() {
        throw new RuntimeException(ERR_MSG);
    }

    @Override
    public int getQuarkAbsoluteAndAdd(String ... attribute) {
        this.waitUntilReady();
        try {
            return this.realStateSystem.getQuarkAbsolute(attribute);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(ERR_MSG);
        }
    }

    @Override
    public int getQuarkRelativeAndAdd(int startingNodeQuark, String ... subPath) {
        this.waitUntilReady();
        try {
            return this.realStateSystem.getQuarkRelative(startingNodeQuark, subPath);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(ERR_MSG);
        }
    }

    private void waitUntilReady() {
        try {
            this.ssAssignedLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

