/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.GitQuickDiffProvider;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.text.Document;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

class GitDocument
extends Document
implements RefsChangedListener {
    private final IResource resource;
    private ObjectId lastCommit;
    private ObjectId lastTree;
    private ObjectId lastBlob;
    private ListenerHandle myRefsChangedHandle;
    private boolean disposed;
    static Map<GitDocument, Repository> doc2repo = new WeakHashMap<GitDocument, Repository>();

    static GitDocument create(IResource resource) throws IOException {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) create: " + resource);
        }
        GitDocument ret = null;
        if (RepositoryProvider.getProvider((IProject)resource.getProject()) instanceof GitProvider) {
            ret = new GitDocument(resource);
            ret.populate();
            Repository repository = ret.getRepository();
            if (repository != null) {
                ret.myRefsChangedHandle = repository.getListenerList().addRefsChangedListener((RefsChangedListener)ret);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GitDocument(IResource resource) {
        this.resource = resource;
        Map<GitDocument, Repository> map = doc2repo;
        synchronized (map) {
            doc2repo.put(this, this.getRepository());
        }
    }

    private void setResolved(AnyObjectId commit, AnyObjectId tree, AnyObjectId blob, String value) {
        this.lastCommit = commit != null ? commit.copy() : null;
        this.lastTree = tree != null ? tree.copy() : null;
        this.lastBlob = blob != null ? blob.copy() : null;
        this.set(value);
        if (blob != null) {
            if (GitTraceLocation.QUICKDIFF.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) resolved " + this.resource + " to " + this.lastBlob + " in " + this.lastCommit + "/" + this.lastTree);
            } else if (GitTraceLocation.QUICKDIFF.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) unresolved " + this.resource);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void populate() throws IOException {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.QUICKDIFF.getLocation(), (Object)this.resource);
        }
        if (this.disposed) {
            return;
        }
        TreeWalk tw = null;
        RevWalk rw = null;
        try {
            RevCommit baselineCommit;
            String oldPath;
            ObjectId commitId;
            String baseline;
            Repository repository;
            block38: {
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)this.resource);
                if (mapping == null) {
                    this.setResolved(null, null, null, "");
                    return;
                }
                String gitPath = mapping.getRepoRelativePath(this.resource);
                if (gitPath == null) {
                    this.setResolved(null, null, null, "");
                    return;
                }
                repository = mapping.getRepository();
                baseline = GitQuickDiffProvider.baseline.get(repository);
                if (baseline == null) {
                    baseline = "HEAD";
                }
                if ((commitId = repository.resolve(baseline)) != null) {
                    if (commitId.equals((AnyObjectId)this.lastCommit)) {
                        if (!GitTraceLocation.QUICKDIFF.isActive()) return;
                        GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) already resolved");
                        return;
                    }
                } else {
                    if (repository.getRef("HEAD") == null) {
                        String msg = NLS.bind((String)UIText.GitDocument_errorResolveQuickdiff, (Object[])new Object[]{baseline, this.resource, repository});
                        Activator.logError(msg, new Throwable());
                    }
                    this.setResolved(null, null, null, "");
                    return;
                }
                rw = new RevWalk(repository);
                ObjectReader reader = null;
                oldPath = gitPath;
                try {
                    try {
                        DiffEntry e;
                        reader = repository.newObjectReader();
                        baselineCommit = rw.parseCommit((AnyObjectId)commitId);
                        TreeWalk walk = new TreeWalk(repository);
                        CanonicalTreeParser baseLineIterator = new CanonicalTreeParser();
                        baseLineIterator.reset(reader, (AnyObjectId)baselineCommit.getTree());
                        walk.addTree((AbstractTreeIterator)baseLineIterator);
                        walk.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
                        List diffs = DiffEntry.scan((TreeWalk)walk, (boolean)true);
                        RenameDetector renameDetector = new RenameDetector(repository);
                        renameDetector.addAll((Collection)diffs);
                        List renames = renameDetector.compute();
                        Iterator iterator = renames.iterator();
                        do {
                            if (iterator.hasNext()) continue;
                        } while (!(e = (DiffEntry)iterator.next()).getNewPath().equals(gitPath));
                        oldPath = e.getOldPath();
                    }
                    catch (IOException err) {
                        String msg = NLS.bind((String)UIText.GitDocument_errorLoadCommit, (Object[])new Object[]{commitId, baseline, this.resource, repository});
                        Activator.logError(msg, err);
                        this.setResolved(null, null, null, "");
                        if (reader != null) {
                            reader.release();
                        }
                        rw.dispose();
                        if (tw != null) {
                            tw.release();
                        }
                        if (rw != null) {
                            rw.release();
                        }
                        if (!GitTraceLocation.QUICKDIFF.isActive()) return;
                        GitTraceLocation.getTrace().traceExit(GitTraceLocation.QUICKDIFF.getLocation());
                        return;
                    }
                }
                finally {
                    if (reader == null) break block38;
                }
                reader.release();
            }
            rw.dispose();
            RevTree treeId = baselineCommit.getTree();
            if (treeId.equals((AnyObjectId)this.lastTree)) {
                if (!GitTraceLocation.QUICKDIFF.isActive()) return;
                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) already resolved");
                return;
            }
            tw = TreeWalk.forPath((Repository)repository, (String)oldPath, (RevTree)treeId);
            if (tw == null) {
                if (GitTraceLocation.QUICKDIFF.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) resource " + this.resource + " not found in " + treeId + " in " + repository + ", baseline=" + baseline);
                }
                this.setResolved(null, null, null, "");
                return;
            }
            ObjectId id = tw.getObjectId(0);
            if (id.equals((AnyObjectId)ObjectId.zeroId())) {
                this.setResolved(null, null, null, "");
                String msg = NLS.bind((String)UIText.GitDocument_errorLoadTree, (Object[])new Object[]{treeId.getName(), baseline, this.resource, repository});
                Activator.logError(msg, new Throwable());
                this.setResolved(null, null, null, "");
                return;
            }
            if (!id.equals((AnyObjectId)this.lastBlob)) {
                if (GitTraceLocation.QUICKDIFF.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) compareTo: " + baseline);
                }
                ObjectLoader loader = repository.open((AnyObjectId)id, 3);
                byte[] bytes = loader.getBytes();
                String charset = CompareCoreUtils.getResourceEncoding((IResource)this.resource);
                String s = new String(bytes, charset);
                this.setResolved((AnyObjectId)commitId, (AnyObjectId)treeId, (AnyObjectId)id, s);
                if (!GitTraceLocation.QUICKDIFF.isActive()) return;
                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) has reference doc, size=" + s.length() + " bytes");
                return;
            }
            if (!GitTraceLocation.QUICKDIFF.isActive()) return;
            GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) already resolved");
            return;
        }
        finally {
            if (tw != null) {
                tw.release();
            }
            if (rw != null) {
                rw.release();
            }
            if (GitTraceLocation.QUICKDIFF.isActive()) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.QUICKDIFF.getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) dispose: " + this.resource);
        }
        Map<GitDocument, Repository> map = doc2repo;
        synchronized (map) {
            doc2repo.remove((Object)this);
        }
        if (this.myRefsChangedHandle != null) {
            this.myRefsChangedHandle.remove();
            this.myRefsChangedHandle = null;
        }
        this.disposed = true;
    }

    public void onRefsChanged(RefsChangedEvent e) {
        Activator.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    GitDocument.this.populate();
                }
                catch (Exception e1) {
                    Activator.logError(UIText.GitDocument_errorRefreshQuickdiff, e1);
                }
            }
        });
    }

    private Repository getRepository() {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)this.resource);
        return mapping != null ? mapping.getRepository() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refreshRelevant(Repository repository) throws IOException {
        Map.Entry[] docs;
        Map<GitDocument, Repository> map = doc2repo;
        synchronized (map) {
            docs = doc2repo.entrySet().toArray(new Map.Entry[doc2repo.size()]);
        }
        Map.Entry[] entryArray = docs;
        int n = docs.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry doc = entryArray[n2];
            if (doc.getValue() == repository) {
                ((GitDocument)((Object)doc.getKey())).populate();
            }
            ++n2;
        }
    }
}

