/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.parser.ASTOperatorNode;
import org.eclipse.photran.internal.core.parser.GenericASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class RepObsOpersRefactoring
extends FortranResourceRefactoring {
    public String getName() {
        return Messages.RepObsOpersRefactoring_Name;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError(Messages.bind((String)Messages.RepObsOpersRefactoring_SelectedFileCannotBeParsed, (Object)file.getName()));
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws Error {
        try {
            if (ast == null) {
                return;
            }
            OperatorReplacingVisitor replacer = new OperatorReplacingVisitor();
            ast.accept(replacer);
            if (replacer.changedAST) {
                this.addChangeFromModifiedAST(file, pm);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    private static final class OperatorReplacingVisitor
    extends GenericASTVisitor {
        private boolean changedAST = false;

        private OperatorReplacingVisitor() {
        }

        @Override
        public void visitASTNode(IASTNode node) {
            if (node instanceof ASTOperatorNode) {
                this.replaceOperatorIn((ASTOperatorNode)node);
            }
            this.traverseChildren(node);
        }

        private void replaceOperatorIn(ASTOperatorNode op) {
            if (op.hasLtOp()) {
                this.setText(op, "<");
            }
            if (op.hasLeOp()) {
                this.setText(op, "<=");
            }
            if (op.hasEqOp()) {
                this.setText(op, "==");
            }
            if (op.hasNeOp()) {
                this.setText(op, "/=");
            }
            if (op.hasGtOp()) {
                this.setText(op, ">");
            }
            if (op.hasGeOp()) {
                this.setText(op, ">=");
            }
        }

        private void setText(ASTOperatorNode op, String newText) {
            op.findFirstToken().setText(newText);
            this.changedAST = true;
        }
    }
}

