/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.callstack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampDelta;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.callstack.CallStackEntry;
import org.eclipse.linuxtools.tmf.ui.views.callstack.CallStackEvent;
import org.eclipse.linuxtools.tmf.ui.views.callstack.CallStackPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphCombo;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphSelection;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;

public class CallStackView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.callstack";
    private static final String[] COLUMN_NAMES = new String[]{Messages.CallStackView_FunctionColumn, Messages.CallStackView_DepthColumn, Messages.CallStackView_EntryTimeColumn, Messages.CallStackView_ExitTimeColumn, Messages.CallStackView_DurationColumn};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 50, 120, 120, 120};
    private static final double SPACING_RATIO = 0.01;
    private static final Image THREAD_IMAGE = Activator.getDefault().getImageFromPath("icons/obj16/thread_obj.gif");
    private static final Image STACKFRAME_IMAGE = Activator.getDefault().getImageFromPath("icons/obj16/stckframe_obj.gif");
    private TimeGraphCombo fTimeGraphCombo;
    private ITmfTrace fTrace;
    private final Map<ITmfTrace, String> fSelectedThreadMap = new HashMap<ITmfTrace, String>();
    private List<ThreadEntry> fEntryList;
    private final Map<ITmfTrace, ArrayList<ThreadEntry>> fEntryListMap = new HashMap<ITmfTrace, ArrayList<ThreadEntry>>();
    private final Map<ITmfTrace, BuildThread> fBuildThreadMap = new HashMap<ITmfTrace, BuildThread>();
    private long fStartTime;
    private long fEndTime;
    private int fDisplayWidth;
    private Action fNextEventAction;
    private Action fPrevEventAction;
    private Action fNextItemAction;
    private Action fPreviousItemAction;
    private ZoomThread fZoomThread;
    private State fRedrawState = State.IDLE;
    private final Object fSyncObj = new Object();
    private TmfTimeSynchSignal fSavedTimeSyncSignal;
    private TmfRangeSynchSignal fSavedRangeSyncSignal;

    public CallStackView() {
        super(ID);
        this.fDisplayWidth = Display.getDefault().getBounds().width;
    }

    public void createPartControl(Composite parent) {
        ITmfTrace trace;
        this.fTimeGraphCombo = new TimeGraphCombo(parent, 0);
        this.fTimeGraphCombo.setTreeContentProvider(new TreeContentProvider());
        this.fTimeGraphCombo.setTreeLabelProvider(new TreeLabelProvider());
        this.fTimeGraphCombo.setTreeColumns(COLUMN_NAMES);
        this.fTimeGraphCombo.getTreeViewer().getTree().getColumn(0).setWidth(COLUMN_WIDTHS[0]);
        this.fTimeGraphCombo.getTreeViewer().getTree().getColumn(1).setWidth(COLUMN_WIDTHS[1]);
        this.fTimeGraphCombo.getTreeViewer().getTree().getColumn(2).setWidth(COLUMN_WIDTHS[2]);
        this.fTimeGraphCombo.getTreeViewer().getTree().getColumn(3).setWidth(COLUMN_WIDTHS[3]);
        this.fTimeGraphCombo.getTreeViewer().getTree().getColumn(4).setWidth(COLUMN_WIDTHS[4]);
        this.fTimeGraphCombo.setTimeGraphProvider(new CallStackPresentationProvider());
        this.fTimeGraphCombo.getTimeGraphViewer().setTimeFormat(Utils.TimeFormat.CALENDAR);
        this.fTimeGraphCombo.getTimeGraphViewer().addRangeListener(new ITimeGraphRangeListener(){

            @Override
            public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
                long startTime = event.getStartTime();
                long endTime = event.getEndTime();
                TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfNanoTimestamp(startTime), (ITmfTimestamp)new TmfNanoTimestamp(endTime));
                CallStackView.this.broadcast((TmfSignal)new TmfRangeSynchSignal((Object)CallStackView.this, range));
                CallStackView.this.startZoomThread(startTime, endTime);
            }
        });
        this.fTimeGraphCombo.getTimeGraphViewer().addTimeListener(new ITimeGraphTimeListener(){

            @Override
            public void timeSelected(TimeGraphTimeEvent event) {
                long beginTime = event.getBeginTime();
                long endTime = event.getEndTime();
                CallStackView.this.selectTime(beginTime);
                CallStackView.this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)CallStackView.this, (ITmfTimestamp)new TmfNanoTimestamp(beginTime), (ITmfTimestamp)new TmfNanoTimestamp(endTime)));
            }
        });
        this.fTimeGraphCombo.getTimeGraphViewer().getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CallStackView.this.fDisplayWidth = ((CallStackView)CallStackView.this).fTimeGraphCombo.getTimeGraphViewer().getControl().getSize().x;
                if (CallStackView.this.fEntryList != null) {
                    CallStackView.this.startZoomThread(CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getTime0(), CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getTime1());
                }
            }
        });
        this.fTimeGraphCombo.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CallStackEntry entry;
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof CallStackEntry && (entry = (CallStackEntry)selection).getFunctionName().length() > 0) {
                    long startTime = entry.getStartTime();
                    long endTime = entry.getEndTime();
                    long spacingTime = (long)((double)(endTime - startTime) * 0.01);
                    TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfNanoTimestamp(startTime -= spacingTime), (ITmfTimestamp)new TmfNanoTimestamp(endTime += spacingTime));
                    CallStackView.this.broadcast((TmfSignal)new TmfRangeSynchSignal((Object)CallStackView.this, range));
                    CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                    CallStackView.this.startZoomThread(startTime, endTime);
                }
            }
        });
        this.fTimeGraphCombo.getTimeGraphViewer().getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object o;
                TimeGraphControl timeGraphControl = CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getTimeGraphControl();
                ISelection selection = timeGraphControl.getSelection();
                if (selection instanceof TimeGraphSelection && (o = ((TimeGraphSelection)selection).getFirstElement()) instanceof CallStackEvent) {
                    CallStackEvent event = (CallStackEvent)o;
                    long startTime = event.getTime();
                    long endTime = startTime + event.getDuration();
                    long spacingTime = (long)((double)(endTime - startTime) * 0.01);
                    TmfTimeRange range = new TmfTimeRange((ITmfTimestamp)new TmfNanoTimestamp(startTime -= spacingTime), (ITmfTimestamp)new TmfNanoTimestamp(endTime += spacingTime));
                    CallStackView.this.broadcast((TmfSignal)new TmfRangeSynchSignal((Object)CallStackView.this, range));
                    CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                    CallStackView.this.startZoomThread(startTime, endTime);
                }
            }
        });
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fTimeGraphCombo.getTimeGraphViewer().getTimeGraphControl().setStatusLineManager(statusLineManager);
        this.makeActions();
        this.contributeToActionBars();
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    public void setFocus() {
        this.fTimeGraphCombo.setFocus();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            return;
        }
        this.fTrace = signal.getTrace();
        this.loadTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        Map<ITmfTrace, Object> map = this.fBuildThreadMap;
        synchronized (map) {
            BuildThread buildThread = this.fBuildThreadMap.remove(signal.getTrace());
            if (buildThread != null) {
                buildThread.cancel();
            }
        }
        map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.remove(signal.getTrace());
        }
        this.fSelectedThreadMap.remove(signal.getTrace());
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fStartTime = 0L;
            this.fEndTime = 0L;
            this.refresh();
        }
    }

    @TmfSignalHandler
    public void synchToTime(TmfTimeSynchSignal signal) {
        TmfTimeSynchSignal tmfTimeSynchSignal = this.fSavedTimeSyncSignal = this.isPinned() ? new TmfTimeSynchSignal(signal.getSource(), signal.getBeginTime(), signal.getEndTime()) : null;
        if (signal.getSource() == this || this.fTrace == null || this.isPinned()) {
            return;
        }
        final long beginTime = signal.getBeginTime().normalize(0L, -9).getValue();
        final long endTime = signal.getEndTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CallStackView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                if (beginTime == endTime) {
                    CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setSelectedTime(beginTime, true);
                } else {
                    CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setSelectionRange(beginTime, endTime);
                }
                CallStackView.this.selectTime(beginTime);
                CallStackView.this.startZoomThread(CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getTime0(), CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().getTime1());
                if (CallStackView.this.fEntryList == null) {
                    return;
                }
                TimeGraphViewer viewer = CallStackView.this.fTimeGraphCombo.getTimeGraphViewer();
                for (ThreadEntry threadEntry : CallStackView.this.fEntryList) {
                    ITmfStateSystem ss = (ITmfStateSystem)threadEntry.getTrace().getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
                    if (ss == null || beginTime < ss.getStartTime() || beginTime > ss.getCurrentEndTime()) continue;
                    try {
                        int quark = ss.getQuarkRelative(threadEntry.getThreadQuark(), new String[]{"CallStack"});
                        ITmfStateInterval stackInterval = ss.querySingleState(beginTime, quark);
                        if (beginTime != stackInterval.getStartTime()) continue;
                        int stackLevel = stackInterval.getStateValue().unboxInt();
                        CallStackEntry selectedEntry = threadEntry.getChildren().get(Math.max(0, stackLevel - 1));
                        CallStackView.this.fTimeGraphCombo.setSelection(selectedEntry);
                        viewer.getTimeGraphControl().fireSelectionChanged();
                        break;
                    }
                    catch (AttributeNotFoundException e) {
                        Activator.getDefault().logError("Error querying state system", e);
                    }
                    catch (TimeRangeException e) {
                        Activator.getDefault().logError("Error querying state system", e);
                    }
                    catch (StateSystemDisposedException e) {
                        Activator.getDefault().logError("Error querying state system", e);
                    }
                    catch (StateValueTypeException e) {
                        Activator.getDefault().logError("Error querying state system", e);
                    }
                }
            }
        });
    }

    @TmfSignalHandler
    public void synchToRange(TmfRangeSynchSignal signal) {
        if (this.isPinned()) {
            this.fSavedRangeSyncSignal = new TmfRangeSynchSignal(signal.getSource(), new TmfTimeRange(signal.getCurrentRange().getStartTime(), signal.getCurrentRange().getEndTime()));
            this.fSavedTimeSyncSignal = null;
        }
        if (signal.getSource() == this || this.fTrace == null || this.isPinned()) {
            return;
        }
        if (signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange()) == null) {
            return;
        }
        final long startTime = signal.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
        final long endTime = signal.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CallStackView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                CallStackView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrace() {
        Map<ITmfTrace, ArrayList<ThreadEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryList = this.fEntryListMap.get(this.fTrace);
            if (this.fEntryList == null) {
                Map<ITmfTrace, BuildThread> map2 = this.fBuildThreadMap;
                synchronized (map2) {
                    BuildThread buildThread = new BuildThread(this.fTrace);
                    this.fBuildThreadMap.put(this.fTrace, buildThread);
                    buildThread.start();
                }
            } else {
                this.fStartTime = this.fTrace.getStartTime().normalize(0L, -9).getValue();
                this.fEndTime = this.fTrace.getEndTime().normalize(0L, -9).getValue();
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildThreadList(ITmfTrace trace, IProgressMonitor monitor) {
        ITmfTrace aTrace;
        ITmfTrace[] traces;
        this.fStartTime = Long.MAX_VALUE;
        this.fEndTime = Long.MIN_VALUE;
        if (trace instanceof TmfExperiment) {
            TmfExperiment experiment = (TmfExperiment)trace;
            traces = experiment.getTraces();
        } else {
            traces = new ITmfTrace[]{trace};
        }
        ArrayList<ThreadEntry> entryList = new ArrayList<ThreadEntry>();
        ITmfTrace[] iTmfTraceArray = traces;
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            aTrace = iTmfTraceArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            ITmfStateSystem ss = (ITmfStateSystem)aTrace.getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
            if (ss == null || !ss.waitUntilBuilt()) {
                String threadName = String.valueOf(Messages.CallStackView_StackInfoNotAvailable) + ' ' + '(' + aTrace.getName() + ')';
                ThreadEntry threadEntry = new ThreadEntry(aTrace, threadName, -1, 0L, 0L);
                entryList.add(threadEntry);
            } else {
                long startTime = ss.getStartTime();
                long endTime = ss.getCurrentEndTime() + 1L;
                this.fStartTime = Math.min(this.fStartTime, startTime);
                this.fEndTime = Math.max(this.fEndTime, endTime);
                List threadQuarks = ss.getQuarks(new String[]{"Threads", "*"});
                int i = 0;
                while (i < threadQuarks.size()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    int threadQuark = (Integer)threadQuarks.get(i);
                    String thread = ss.getAttributeName(threadQuark);
                    String threadEntryName = String.valueOf(thread) + ' ' + '(' + aTrace.getName() + ')';
                    ThreadEntry threadEntry = new ThreadEntry(aTrace, threadEntryName, threadQuark, startTime, endTime);
                    entryList.add(threadEntry);
                    try {
                        int eventStackQuark = ss.getQuarkRelative(threadQuark, new String[]{"CallStack"});
                        int level = 1;
                        Iterator iterator = ss.getSubAttributes(eventStackQuark, false).iterator();
                        while (iterator.hasNext()) {
                            int stackLevelQuark = (Integer)iterator.next();
                            CallStackEntry callStackEntry = new CallStackEntry(stackLevelQuark, level++, aTrace);
                            threadEntry.addChild(callStackEntry);
                        }
                    }
                    catch (AttributeNotFoundException e) {
                        Activator.getDefault().logError("Error querying state system", e);
                    }
                    ++i;
                }
            }
            ++n2;
        }
        aTrace = this.fEntryListMap;
        synchronized (aTrace) {
            this.fEntryListMap.put(trace, new ArrayList(entryList));
        }
        if (trace == this.fTrace) {
            this.refresh();
        }
        for (ThreadEntry threadEntry : entryList) {
            for (CallStackEntry callStackEntry : threadEntry.getChildren()) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.buildStatusEvents(trace, callStackEntry, monitor);
            }
        }
    }

    private void buildStatusEvents(ITmfTrace trace, CallStackEntry entry, IProgressMonitor monitor) {
        ITmfStateSystem ss = (ITmfStateSystem)entry.getTrace().getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
        long start = ss.getStartTime();
        long end = ss.getCurrentEndTime() + 1L;
        long resolution = Math.max(1L, (end - start) / (long)this.fDisplayWidth);
        List<ITimeEvent> eventList = CallStackView.getEventList(entry, start, end, resolution, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        entry.setEventList(eventList);
        if (trace == this.fTrace) {
            this.redraw();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<ITimeEvent> getEventList(CallStackEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        ITmfStateSystem ss = (ITmfStateSystem)entry.getTrace().getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
        long start = Math.max(startTime, ss.getStartTime());
        long end = Math.min(endTime, ss.getCurrentEndTime() + 1L);
        if (end <= start) {
            return null;
        }
        ArrayList<TimeEvent> eventList = null;
        try {
            List stackIntervals = ss.queryHistoryRange(entry.getQuark(), start, end - 1L, resolution, monitor);
            eventList = new ArrayList<TimeEvent>(stackIntervals.size());
            long lastEndTime = -1L;
            boolean lastIsNull = true;
            Iterator iterator = stackIntervals.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return eventList;
                }
                ITmfStateInterval statusInterval = (ITmfStateInterval)iterator.next();
                if (monitor.isCanceled()) {
                    return null;
                }
                long time = statusInterval.getStartTime();
                long duration = statusInterval.getEndTime() - time + 1L;
                if (!statusInterval.getStateValue().isNull()) {
                    int modulo = 180;
                    int value = statusInterval.getStateValue().toString().hashCode() % 180 + 180;
                    eventList.add(new CallStackEvent(entry, time, duration, value));
                    lastIsNull = false;
                } else {
                    if (lastEndTime == -1L) {
                        eventList.add(new NullTimeEvent(entry, time, duration));
                    } else {
                        if (lastEndTime != time && lastIsNull) {
                            eventList.add(new TimeEvent(entry, lastEndTime, time - lastEndTime));
                        }
                        if (time + duration >= endTime) {
                            eventList.add(new NullTimeEvent(entry, time, duration));
                        }
                    }
                    lastIsNull = true;
                }
                lastEndTime = time + duration;
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getDefault().logError("Error querying state system", e);
            return eventList;
        }
        catch (TimeRangeException e) {
            Activator.getDefault().logError("Error querying state system", e);
            return eventList;
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return eventList;
    }

    private void selectTime(long time) {
        if (this.fEntryList == null) {
            return;
        }
        for (ThreadEntry threadEntry : this.fEntryList) {
            ITmfStateSystem ss = (ITmfStateSystem)threadEntry.fThreadTrace.getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
            if (ss == null || !ss.waitUntilBuilt()) continue;
            long queryTime = Math.max(ss.getStartTime(), Math.min(ss.getCurrentEndTime(), time));
            for (CallStackEntry callStackEntry : threadEntry.getChildren()) {
                try {
                    ITmfStateInterval stackLevelInterval = ss.querySingleState(queryTime, callStackEntry.getQuark());
                    ITmfStateValue nameValue = stackLevelInterval.getStateValue();
                    String name = "";
                    try {
                        if (nameValue.getType() == ITmfStateValue.Type.STRING) {
                            name = nameValue.unboxStr();
                        } else if (nameValue.getType() == ITmfStateValue.Type.INTEGER) {
                            name = "0x" + Integer.toHexString(nameValue.unboxInt());
                        } else if (nameValue.getType() == ITmfStateValue.Type.LONG) {
                            name = "0x" + Long.toHexString(nameValue.unboxLong());
                        }
                    }
                    catch (StateValueTypeException stateValueTypeException) {
                        // empty catch block
                    }
                    callStackEntry.setFunctionName(name);
                    if (name.length() <= 0) continue;
                    callStackEntry.setStartTime(stackLevelInterval.getStartTime());
                    callStackEntry.setEndTime(stackLevelInterval.getEndTime() + 1L);
                }
                catch (AttributeNotFoundException e) {
                    Activator.getDefault().logError("Error querying state system", e);
                }
                catch (TimeRangeException e) {
                    Activator.getDefault().logError("Error querying state system", e);
                }
                catch (StateSystemDisposedException e) {
                    Activator.getDefault().logError("Error querying state system", e);
                }
            }
        }
        this.fTimeGraphCombo.refresh();
    }

    private void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (CallStackView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                ITimeGraphEntry[] entries = null;
                Map map = CallStackView.this.fEntryListMap;
                synchronized (map) {
                    CallStackView.this.fEntryList = (List)CallStackView.this.fEntryListMap.get(CallStackView.this.fTrace);
                    if (CallStackView.this.fEntryList == null) {
                        CallStackView.this.fEntryList = new ArrayList();
                    }
                    entries = CallStackView.this.fEntryList.toArray(new ITimeGraphEntry[0]);
                }
                CallStackView.this.fTimeGraphCombo.setInput(entries);
                CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setTimeBounds(CallStackView.this.fStartTime, CallStackView.this.fEndTime);
                long selectionBeginTime = CallStackView.this.fTrace == null ? 0L : CallStackView.this.fTraceManager.getSelectionBeginTime().normalize(0L, -9).getValue();
                long selectionEndTime = CallStackView.this.fTrace == null ? 0L : CallStackView.this.fTraceManager.getSelectionEndTime().normalize(0L, -9).getValue();
                long startTime = CallStackView.this.fTrace == null ? 0L : CallStackView.this.fTraceManager.getCurrentRange().getStartTime().normalize(0L, -9).getValue();
                long endTime = CallStackView.this.fTrace == null ? 0L : CallStackView.this.fTraceManager.getCurrentRange().getEndTime().normalize(0L, -9).getValue();
                startTime = Math.max(startTime, CallStackView.this.fStartTime);
                endTime = Math.min(endTime, CallStackView.this.fEndTime);
                CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setSelectionRange(selectionBeginTime, selectionEndTime);
                CallStackView.this.selectTime(selectionBeginTime);
                CallStackView.this.fTimeGraphCombo.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                CallStackView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redraw() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawState != State.IDLE) {
                this.fRedrawState = State.PENDING;
                return;
            }
            this.fRedrawState = State.BUSY;
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (CallStackView.this.fTimeGraphCombo.isDisposed()) {
                    return;
                }
                CallStackView.this.fTimeGraphCombo.redraw();
                CallStackView.this.fTimeGraphCombo.update();
                Object object = CallStackView.this.fSyncObj;
                synchronized (object) {
                    if (CallStackView.this.fRedrawState == State.PENDING) {
                        CallStackView.this.fRedrawState = State.IDLE;
                        CallStackView.this.redraw();
                    } else {
                        CallStackView.this.fRedrawState = State.IDLE;
                    }
                }
            }
        });
    }

    private void startZoomThread(long startTime, long endTime) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
        }
        this.fZoomThread = new ZoomThread(this.fEntryList, startTime, endTime);
        this.fZoomThread.start();
    }

    private void makeActions() {
        this.fPreviousItemAction = this.fTimeGraphCombo.getTimeGraphViewer().getPreviousItemAction();
        this.fPreviousItemAction.setText(Messages.TmfTimeGraphViewer_PreviousItemActionNameText);
        this.fPreviousItemAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousItemActionToolTipText);
        this.fNextItemAction = this.fTimeGraphCombo.getTimeGraphViewer().getNextItemAction();
        this.fNextItemAction.setText(Messages.TmfTimeGraphViewer_NextItemActionNameText);
        this.fNextItemAction.setToolTipText(Messages.TmfTimeGraphViewer_NextItemActionToolTipText);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.contributePinActionToToolBar();
        this.fPinAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty()) && !CallStackView.this.isPinned()) {
                    if (CallStackView.this.fSavedRangeSyncSignal != null) {
                        CallStackView.this.synchToRange(CallStackView.this.fSavedRangeSyncSignal);
                        CallStackView.this.fSavedRangeSyncSignal = null;
                    }
                    if (CallStackView.this.fSavedTimeSyncSignal != null) {
                        CallStackView.this.synchToTime(CallStackView.this.fSavedTimeSyncSignal);
                        CallStackView.this.fSavedTimeSyncSignal = null;
                    }
                }
            }
        });
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getResetScaleAction());
        manager.add((IAction)this.getPreviousEventAction());
        manager.add((IAction)this.getNextEventAction());
        manager.add((IAction)this.fPreviousItemAction);
        manager.add((IAction)this.fNextItemAction);
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getZoomInAction());
        manager.add((IAction)this.fTimeGraphCombo.getTimeGraphViewer().getZoomOutAction());
        manager.add((IContributionItem)new Separator());
    }

    private Action getNextEventAction() {
        if (this.fNextEventAction == null) {
            this.fNextEventAction = new Action(){

                public void run() {
                    TimeGraphViewer viewer = CallStackView.this.fTimeGraphCombo.getTimeGraphViewer();
                    ITimeGraphEntry entry = viewer.getSelection();
                    if (entry instanceof CallStackEntry) {
                        try {
                            CallStackEntry callStackEntry = (CallStackEntry)entry;
                            ITmfTrace trace = callStackEntry.getTrace();
                            ITmfStateSystem ss = (ITmfStateSystem)trace.getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
                            long time = Math.max(ss.getStartTime(), Math.min(ss.getCurrentEndTime(), viewer.getSelectionBegin()));
                            ThreadEntry threadEntry = (ThreadEntry)callStackEntry.getParent();
                            int quark = ss.getQuarkRelative(threadEntry.getThreadQuark(), new String[]{"CallStack"});
                            ITmfStateInterval stackInterval = ss.querySingleState(time, quark);
                            long newTime = stackInterval.getEndTime() + 1L;
                            viewer.setSelectedTimeNotify(newTime, true);
                            stackInterval = ss.querySingleState(Math.min(ss.getCurrentEndTime(), newTime), quark);
                            int stackLevel = stackInterval.getStateValue().unboxInt();
                            CallStackEntry selectedEntry = threadEntry.getChildren().get(Math.max(0, stackLevel - 1));
                            CallStackView.this.fTimeGraphCombo.setSelection(selectedEntry);
                            viewer.getTimeGraphControl().fireSelectionChanged();
                            CallStackView.this.startZoomThread(viewer.getTime0(), viewer.getTime1());
                        }
                        catch (AttributeNotFoundException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                        catch (TimeRangeException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                        catch (StateSystemDisposedException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                        catch (StateValueTypeException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                    }
                }
            };
            this.fNextEventAction.setText(Messages.TmfTimeGraphViewer_NextEventActionNameText);
            this.fNextEventAction.setToolTipText(Messages.TmfTimeGraphViewer_NextEventActionToolTipText);
            this.fNextEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/next_event.gif"));
        }
        return this.fNextEventAction;
    }

    private Action getPreviousEventAction() {
        if (this.fPrevEventAction == null) {
            this.fPrevEventAction = new Action(){

                public void run() {
                    TimeGraphViewer viewer = CallStackView.this.fTimeGraphCombo.getTimeGraphViewer();
                    ITimeGraphEntry entry = viewer.getSelection();
                    if (entry instanceof CallStackEntry) {
                        try {
                            CallStackEntry callStackEntry = (CallStackEntry)entry;
                            ITmfTrace trace = callStackEntry.getTrace();
                            ITmfStateSystem ss = (ITmfStateSystem)trace.getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
                            long time = Math.max(ss.getStartTime(), Math.min(ss.getCurrentEndTime(), viewer.getSelectionBegin()));
                            ThreadEntry threadEntry = (ThreadEntry)callStackEntry.getParent();
                            int quark = ss.getQuarkRelative(threadEntry.getThreadQuark(), new String[]{"CallStack"});
                            ITmfStateInterval stackInterval = ss.querySingleState(time, quark);
                            if (stackInterval.getStartTime() == time && time > ss.getStartTime()) {
                                stackInterval = ss.querySingleState(time - 1L, quark);
                            }
                            viewer.setSelectedTimeNotify(stackInterval.getStartTime(), true);
                            int stackLevel = stackInterval.getStateValue().unboxInt();
                            CallStackEntry selectedEntry = threadEntry.getChildren().get(Math.max(0, stackLevel - 1));
                            CallStackView.this.fTimeGraphCombo.setSelection(selectedEntry);
                            viewer.getTimeGraphControl().fireSelectionChanged();
                            CallStackView.this.startZoomThread(viewer.getTime0(), viewer.getTime1());
                        }
                        catch (AttributeNotFoundException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                        catch (TimeRangeException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                        catch (StateSystemDisposedException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                        catch (StateValueTypeException e) {
                            Activator.getDefault().logError("Error querying state system", e);
                        }
                    }
                }
            };
            this.fPrevEventAction.setText(Messages.TmfTimeGraphViewer_PreviousEventActionNameText);
            this.fPrevEventAction.setToolTipText(Messages.TmfTimeGraphViewer_PreviousEventActionToolTipText);
            this.fPrevEventAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath("icons/elcl16/prev_event.gif"));
        }
        return this.fPrevEventAction;
    }

    private class BuildThread
    extends Thread {
        private final ITmfTrace fBuildTrace;
        private final IProgressMonitor fMonitor;

        public BuildThread(ITmfTrace trace) {
            super("CallStackView build");
            this.fBuildTrace = trace;
            this.fMonitor = new NullProgressMonitor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CallStackView.this.buildThreadList(this.fBuildTrace, this.fMonitor);
            Map map = CallStackView.this.fBuildThreadMap;
            synchronized (map) {
                CallStackView.this.fBuildThreadMap.remove(this);
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }

    private static enum State {
        IDLE,
        BUSY,
        PENDING;

    }

    private class ThreadEntry
    implements ITimeGraphEntry {
        private final ITmfTrace fThreadTrace;
        private final long fTraceStartTime;
        private final long fTraceEndTime;
        private ArrayList<CallStackEntry> fChildren;
        private final String fName;
        private final int fThreadQuark;

        public ThreadEntry(ITmfTrace trace, String name, int threadQuark, long startTime, long endTime) {
            this.fThreadTrace = trace;
            this.fChildren = new ArrayList();
            this.fName = name;
            this.fTraceStartTime = startTime;
            this.fTraceEndTime = endTime;
            this.fThreadQuark = threadQuark;
        }

        @Override
        public ITimeGraphEntry getParent() {
            return null;
        }

        @Override
        public boolean hasChildren() {
            if (this.fChildren == null) {
                ITmfStateSystem ss = (ITmfStateSystem)this.fThreadTrace.getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
                try {
                    int eventStackQuark = ss.getQuarkRelative(this.fThreadQuark, new String[]{"CallStack"});
                    ITmfStateInterval eventStackInterval = ss.querySingleState(ss.getStartTime(), eventStackQuark);
                    return !eventStackInterval.getStateValue().isNull() || eventStackInterval.getEndTime() != ss.getCurrentEndTime();
                }
                catch (AttributeNotFoundException e) {
                    Activator.getDefault().logError("Error querying state system", e);
                }
                catch (TimeRangeException e) {
                    Activator.getDefault().logError("Error querying state system", e);
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    // empty catch block
                }
            }
            return this.fChildren != null && this.fChildren.size() > 0;
        }

        public List<CallStackEntry> getChildren() {
            return this.fChildren;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public long getStartTime() {
            return this.fTraceStartTime;
        }

        @Override
        public long getEndTime() {
            return this.fTraceEndTime;
        }

        @Override
        public boolean hasTimeEvents() {
            return false;
        }

        public Iterator<ITimeEvent> getTimeEventsIterator() {
            return null;
        }

        @Override
        public <T extends ITimeEvent> Iterator<T> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
            return null;
        }

        public int getThreadQuark() {
            return this.fThreadQuark;
        }

        public ITmfTrace getTrace() {
            return this.fThreadTrace;
        }

        public void addChild(CallStackEntry entry) {
            entry.setParent(this);
            this.fChildren.add(entry);
        }
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (ITimeGraphEntry[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            ITimeGraphEntry entry = (ITimeGraphEntry)parentElement;
            return entry.getChildren().toArray();
        }

        public Object getParent(Object element) {
            ITimeGraphEntry entry = (ITimeGraphEntry)element;
            return entry.getParent();
        }

        public boolean hasChildren(Object element) {
            ITimeGraphEntry entry = (ITimeGraphEntry)element;
            return entry.hasChildren();
        }
    }

    private class TreeLabelProvider
    implements ITableLabelProvider {
        private TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                CallStackEntry entry;
                if (element instanceof ThreadEntry) {
                    return THREAD_IMAGE;
                }
                if (element instanceof CallStackEntry && (entry = (CallStackEntry)element).getFunctionName().length() > 0) {
                    return STACKFRAME_IMAGE;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ThreadEntry) {
                if (columnIndex == 0) {
                    return ((ThreadEntry)element).getName();
                }
            } else if (element instanceof CallStackEntry) {
                CallStackEntry entry = (CallStackEntry)element;
                if (columnIndex == 0) {
                    return entry.getFunctionName();
                }
                if (columnIndex == 1 && entry.getFunctionName().length() > 0) {
                    int depth = entry.getStackLevel();
                    return Integer.toString(depth);
                }
                if (columnIndex == 2 && entry.getFunctionName().length() > 0) {
                    TmfTimestamp ts = new TmfTimestamp(entry.getStartTime(), -9);
                    return ts.toString();
                }
                if (columnIndex == 3 && entry.getFunctionName().length() > 0) {
                    TmfTimestamp ts = new TmfTimestamp(entry.getEndTime(), -9);
                    return ts.toString();
                }
                if (columnIndex == 4 && entry.getFunctionName().length() > 0) {
                    TmfTimestampDelta ts = new TmfTimestampDelta(entry.getEndTime() - entry.getStartTime(), -9);
                    return ts.toString();
                }
            }
            return "";
        }
    }

    private class ZoomThread
    extends Thread {
        private final List<ThreadEntry> fZoomEntryList;
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final IProgressMonitor fMonitor;

        public ZoomThread(List<ThreadEntry> entryList, long startTime, long endTime) {
            super("ResourcesView zoom");
            this.fZoomEntryList = entryList;
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fMonitor = new NullProgressMonitor();
        }

        @Override
        public void run() {
            if (this.fZoomEntryList == null) {
                return;
            }
            long resolution = Math.max(1L, (this.fZoomEndTime - this.fZoomStartTime) / (long)CallStackView.this.fDisplayWidth);
            block0: for (ThreadEntry threadEntry : this.fZoomEntryList) {
                ITmfStateSystem ss = (ITmfStateSystem)threadEntry.fThreadTrace.getStateSystems().get("org.eclipse.linuxtools.tmf.callstack");
                if (ss == null || !ss.waitUntilBuilt()) continue;
                for (ITimeGraphEntry iTimeGraphEntry : threadEntry.getChildren()) {
                    if (this.fMonitor.isCanceled()) continue block0;
                    CallStackEntry entry = (CallStackEntry)iTimeGraphEntry;
                    if (this.fZoomStartTime <= CallStackView.this.fStartTime && this.fZoomEndTime >= CallStackView.this.fEndTime) {
                        entry.setZoomedEventList(null);
                    } else {
                        List zoomedEventList = CallStackView.getEventList(entry, this.fZoomStartTime, this.fZoomEndTime, resolution, this.fMonitor);
                        if (zoomedEventList != null) {
                            entry.setZoomedEventList(zoomedEventList);
                        }
                    }
                    CallStackView.this.redraw();
                }
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }
}

