/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.parser;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.gcov.parser.Arc;
import org.eclipse.linuxtools.internal.gcov.parser.Block;
import org.eclipse.linuxtools.internal.gcov.parser.GcnoFunction;
import org.eclipse.linuxtools.internal.gcov.parser.Messages;
import org.eclipse.linuxtools.internal.gcov.utils.BEDataInputStream;
import org.eclipse.linuxtools.internal.gcov.utils.LEDataInputStream;
import org.eclipse.osgi.util.NLS;

public class GcdaRecordsParser {
    private static final int GCOV_DATA_MAGIC = 1734567009;
    private static final int GCOV_TAG_FUNCTION = 0x1000000;
    private static final int GCOV_COUNTER_ARCS = 0x1A10000;
    private static final int GCOV_TAG_OBJECT_SYMMARY = -1593835520;
    private static final int GCOV_TAG_PROGRAM_SUMMARY = -1560281088;
    private final ArrayList<GcnoFunction> fnctns;
    private long objSmryNbrPgmRuns = 0L;
    private long pgmSmryChksm = 0L;
    private long objSmryChksm = 0L;
    private long objSmryArcCnts = 0L;
    private long objSmrytotalCnts = 0L;
    private long objSmryRunMax = 0L;
    private long objSmrySumMax = 0L;

    public GcdaRecordsParser(ArrayList<GcnoFunction> fnctns) {
        this.fnctns = fnctns;
    }

    public void parseGcdaRecord(DataInput stream) throws IOException, CoreException {
        int magic = 0;
        GcnoFunction currentFnctn = null;
        magic = stream.readInt();
        if (magic == 1734567009) {
            stream = new BEDataInputStream((DataInputStream)stream);
        } else {
            magic = magic >> 16 | magic << 16;
            if ((magic = (magic & 0xFF00FF) << 8 | magic >> 8 & 0xFF00FF) == 1734567009) {
                stream = new LEDataInputStream((DataInputStream)stream);
            } else {
                String message = NLS.bind((String)Messages.GcdaRecordsParser_magic_num_error, (Object)magic);
                Status status = new Status(4, "org.eclipse.linuxtools.gcov.core", message);
                throw new CoreException((IStatus)status);
            }
        }
        int version = stream.readInt();
        stream.readInt();
        try {
            block8: while (true) {
                int tag;
                if ((tag = stream.readInt()) == 0) {
                    continue;
                }
                long length = (long)stream.readInt() & 0xFFFFFFFFL;
                switch (tag) {
                    case 0x1000000: {
                        long fnctnId = (long)stream.readInt() & 0xFFFFFFFFL;
                        if (this.fnctns.isEmpty()) continue block8;
                        boolean fnctnFound = false;
                        for (GcnoFunction f : this.fnctns) {
                            if (f.getIdent() != fnctnId) continue;
                            fnctnFound = true;
                            currentFnctn = f;
                            long fnctnChksm = (long)stream.readInt() & 0xFFFFFFFFL;
                            if (f.getCheksum() != fnctnChksm) {
                                String message = NLS.bind((String)Messages.GcdaRecordsParser_checksum_error, (Object[])new Object[]{currentFnctn.getName(), fnctnId});
                                Status status = new Status(4, "org.eclipse.linuxtools.gcov.core", message);
                                throw new CoreException((IStatus)status);
                            }
                            if (version < 875575082) break;
                            stream.readInt();
                            break;
                        }
                        if (fnctnFound) continue block8;
                        currentFnctn = null;
                        String message = NLS.bind((String)Messages.GcdaRecordsParser_func_not_found, (Object)fnctnId);
                        Status status = new Status(4, "org.eclipse.linuxtools.gcov.core", message);
                        throw new CoreException((IStatus)status);
                    }
                    case 0x1A10000: {
                        if (currentFnctn == null) {
                            String message = Messages.GcdaRecordsParser_func_counter_error;
                            Status status = new Status(4, "org.eclipse.linuxtools.gcov.core", message);
                            throw new CoreException((IStatus)status);
                        }
                        if (length != (long)(2 * currentFnctn.getNumCounts())) {
                            String message = Messages.GcdaRecordsParser_content_inconsistent;
                            Status status = new Status(4, "org.eclipse.linuxtools.gcov.core", message);
                            throw new CoreException((IStatus)status);
                        }
                        ArrayList<Block> fnctnBlcks = currentFnctn.getFunctionBlocks();
                        if (fnctnBlcks.isEmpty()) {
                            String message = Messages.GcdaRecordsParser_func_block_empty;
                            Status status = new Status(4, "org.eclipse.linuxtools.gcov.core", message);
                            throw new CoreException((IStatus)status);
                        }
                        int i = 0;
                        while (i < fnctnBlcks.size()) {
                            Block b = fnctnBlcks.get(i);
                            int nonFakeExit = 0;
                            ArrayList<Arc> arcsExit = b.getExitArcs();
                            for (Arc extArc : arcsExit) {
                                if (!extArc.isFake()) {
                                    ++nonFakeExit;
                                }
                                if (extArc.isOnTree()) continue;
                                long arcsCnts = stream.readLong();
                                extArc.setCount(arcsCnts);
                                extArc.setCountValid(true);
                                b.decNumSuccs();
                                extArc.getDstnatnBlock().decNumPreds();
                            }
                            if (nonFakeExit == 1) {
                                for (Arc extArc : arcsExit) {
                                    if (extArc.isFake()) continue;
                                    extArc.setUnconditionnal(true);
                                    if (!b.isCallSite() || !extArc.isFallthrough() || !extArc.getDstnatnBlock().getEntryArcs().get(0).equals(extArc) || extArc.getDstnatnBlock().getEntryArcs().size() != 1) continue;
                                    extArc.getDstnatnBlock().setCallReturn(true);
                                }
                            }
                            ++i;
                        }
                        currentFnctn = null;
                        continue block8;
                    }
                    case -1593835520: {
                        this.objSmryChksm = (long)stream.readInt() & 0xFFFFFFFFL;
                        this.objSmryArcCnts = (long)stream.readInt() & 0xFFFFFFFFL;
                        this.objSmryNbrPgmRuns = (long)stream.readInt() & 0xFFFFFFFFL;
                        this.objSmrytotalCnts = stream.readLong();
                        this.objSmryRunMax = stream.readLong();
                        this.objSmrySumMax = stream.readLong();
                        continue block8;
                    }
                    case -1560281088: {
                        this.pgmSmryChksm = (long)stream.readInt() & 0xFFFFFFFFL;
                        int i = 0;
                        while (true) {
                            if ((long)i >= length - 1L) continue block8;
                            stream.readInt();
                            ++i;
                        }
                    }
                }
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    public long getObjSmryNbrPgmRuns() {
        return this.objSmryNbrPgmRuns;
    }

    public long getObjSmryChksm() {
        return this.objSmryChksm;
    }

    public long getObjSmryArcCnts() {
        return this.objSmryArcCnts;
    }

    public long getObjSmrytotalCnts() {
        return this.objSmrytotalCnts;
    }

    public long getObjSmryRunMax() {
        return this.objSmryRunMax;
    }

    public long getObjSmrySumMax() {
        return this.objSmrySumMax;
    }

    public long getPgmSmryChksm() {
        return this.pgmSmryChksm;
    }
}

