/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionScope;

public class CPPASTFunctionDeclarator
extends CPPASTDeclarator
implements ICPPASTFunctionDeclarator,
IASTAmbiguityParent {
    private ICPPASTParameterDeclaration[] parameters;
    private IASTTypeId[] typeIds = NO_EXCEPTION_SPECIFICATION;
    private ICPPASTExpression noexceptExpression;
    private IASTTypeId trailingReturnType;
    private boolean varArgs;
    private boolean pureVirtual;
    private boolean isVolatile;
    private boolean isConst;
    private boolean isMutable;
    private boolean isOverride;
    private boolean isFinal;
    private ICPPFunctionScope scope;

    public CPPASTFunctionDeclarator() {
    }

    public CPPASTFunctionDeclarator(IASTName name) {
        super(name);
    }

    @Override
    public CPPASTFunctionDeclarator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTFunctionDeclarator copy(IASTNode.CopyStyle style) {
        CPPASTFunctionDeclarator copy = new CPPASTFunctionDeclarator();
        this.copyBaseDeclarator(copy, style);
        copy.varArgs = this.varArgs;
        copy.pureVirtual = this.pureVirtual;
        copy.isVolatile = this.isVolatile;
        copy.isConst = this.isConst;
        copy.isMutable = this.isMutable;
        copy.isOverride = this.isOverride;
        copy.isFinal = this.isFinal;
        IASTNode[] iASTNodeArray = this.getParameters();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTParameterDeclaration param = iASTNodeArray[n2];
            copy.addParameterDeclaration(param == null ? null : param.copy(style));
            ++n2;
        }
        iASTNodeArray = this.getExceptionSpecification();
        n = iASTNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            IASTNode typeId = iASTNodeArray[n2];
            copy.addExceptionSpecificationTypeId(typeId == null ? null : typeId.copy(style));
            ++n2;
        }
        if (this.noexceptExpression != null) {
            copy.setNoexceptExpression(this.noexceptExpression == NOEXCEPT_DEFAULT ? this.noexceptExpression : (ICPPASTExpression)this.noexceptExpression.copy(style));
        }
        if (this.trailingReturnType != null) {
            copy.setTrailingReturnType(this.trailingReturnType.copy(style));
        }
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public ICPPASTParameterDeclaration[] getParameters() {
        if (this.parameters == null) {
            return ICPPASTParameterDeclaration.EMPTY_CPPPARAMETERDECLARATION_ARRAY;
        }
        this.parameters = ArrayUtil.trim(this.parameters);
        return this.parameters;
    }

    @Override
    public void addParameterDeclaration(IASTParameterDeclaration parameter) {
        this.assertNotFrozen();
        if (parameter != null) {
            parameter.setParent(this);
            parameter.setPropertyInParent(FUNCTION_PARAMETER);
            this.parameters = ArrayUtil.append(ICPPASTParameterDeclaration.class, this.parameters, (ICPPASTParameterDeclaration)parameter);
        }
    }

    @Override
    public boolean takesVarArgs() {
        return this.varArgs;
    }

    @Override
    public void setVarArgs(boolean value) {
        this.assertNotFrozen();
        this.varArgs = value;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public void setConst(boolean value) {
        this.assertNotFrozen();
        this.isConst = value;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public void setVolatile(boolean value) {
        this.assertNotFrozen();
        this.isVolatile = value;
    }

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public void setMutable(boolean value) {
        this.assertNotFrozen();
        this.isMutable = value;
    }

    @Override
    public IASTTypeId[] getExceptionSpecification() {
        this.typeIds = ArrayUtil.trim(this.typeIds);
        return this.typeIds;
    }

    @Override
    public void setEmptyExceptionSpecification() {
        this.assertNotFrozen();
        this.typeIds = IASTTypeId.EMPTY_TYPEID_ARRAY;
    }

    @Override
    public void addExceptionSpecificationTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        if (typeId != null) {
            assert (this.typeIds != null);
            this.typeIds = ArrayUtil.append(this.typeIds, typeId);
            typeId.setParent(this);
            typeId.setPropertyInParent(EXCEPTION_TYPEID);
        }
    }

    @Override
    public ICPPASTExpression getNoexceptExpression() {
        return this.noexceptExpression;
    }

    @Override
    public void setNoexceptExpression(ICPPASTExpression expression) {
        this.assertNotFrozen();
        this.noexceptExpression = expression;
        if (expression != null && expression != NOEXCEPT_DEFAULT) {
            expression.setParent(this);
            expression.setPropertyInParent(NOEXCEPT_EXPRESSION);
        }
    }

    @Override
    public IASTTypeId getTrailingReturnType() {
        return this.trailingReturnType;
    }

    @Override
    public void setTrailingReturnType(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.trailingReturnType = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TRAILING_RETURN_TYPE);
        }
    }

    @Override
    public boolean isPureVirtual() {
        return this.pureVirtual;
    }

    @Override
    public void setPureVirtual(boolean isPureVirtual) {
        this.assertNotFrozen();
        this.pureVirtual = isPureVirtual;
    }

    @Override
    @Deprecated
    public ICPPASTConstructorChainInitializer[] getConstructorChain() {
        if (ASTQueries.findTypeRelevantDeclarator(this) == this) {
            IASTNode parent = this.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                if (parent == null) break;
                parent = parent.getParent();
            }
            if (parent instanceof ICPPASTFunctionDefinition) {
                return ((ICPPASTFunctionDefinition)parent).getMemberInitializers();
            }
        }
        return ICPPASTConstructorChainInitializer.EMPTY_CONSTRUCTORCHAININITIALIZER_ARRAY;
    }

    @Override
    @Deprecated
    public void addConstructorToChain(ICPPASTConstructorChainInitializer initializer) {
        this.assertNotFrozen();
    }

    @Override
    public ICPPFunctionScope getFunctionScope() {
        if (this.scope != null) {
            return this.scope;
        }
        IASTNode node = this.getParent();
        while (!(node instanceof IASTDeclaration)) {
            if (node == null) {
                return null;
            }
            node = node.getParent();
        }
        if (node instanceof IASTParameterDeclaration) {
            return null;
        }
        if (ASTQueries.findTypeRelevantDeclarator(this) == this) {
            this.scope = new CPPFunctionScope(this);
        }
        return this.scope;
    }

    @Override
    protected boolean postAccept(ASTVisitor action) {
        ICPPASTParameterDeclaration[] params = this.getParameters();
        int i = 0;
        while (i < params.length) {
            if (!params[i].accept(action)) {
                return false;
            }
            ++i;
        }
        IASTTypeId[] ids = this.getExceptionSpecification();
        int i2 = 0;
        while (i2 < ids.length) {
            if (!ids[i2].accept(action)) {
                return false;
            }
            ++i2;
        }
        if (this.noexceptExpression != null && this.noexceptExpression != NOEXCEPT_DEFAULT && !this.noexceptExpression.accept(action)) {
            return false;
        }
        if (this.trailingReturnType != null && !this.trailingReturnType.accept(action)) {
            return false;
        }
        return super.postAccept(action);
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                if (child == this.parameters[i]) {
                    other.setPropertyInParent(child.getPropertyInParent());
                    other.setParent(child.getParent());
                    this.parameters[i] = (ICPPASTParameterDeclaration)other;
                    return;
                }
                ++i;
            }
        }
        assert (false);
    }

    @Override
    public boolean isOverride() {
        return this.isOverride;
    }

    @Override
    public void setOverride(boolean value) {
        this.assertNotFrozen();
        this.isOverride = value;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public void setFinal(boolean value) {
        this.assertNotFrozen();
        this.isFinal = value;
    }
}

