/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventFactory;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfStateProvider
implements ITmfStateProvider {
    private static final int DEFAULT_EVENTS_QUEUE_SIZE = 10000;
    private final ITmfTrace trace;
    private final Class<? extends ITmfEvent> eventType;
    private final BlockingQueue<ITmfEvent> eventsQueue;
    private final Thread eventHandlerThread;
    private boolean ssAssigned;
    private ITmfEvent currentEvent;
    protected ITmfStateSystemBuilder ss = null;

    public AbstractTmfStateProvider(ITmfTrace trace, Class<? extends ITmfEvent> eventType, String id) {
        this.trace = trace;
        this.eventType = eventType;
        this.eventsQueue = new ArrayBlockingQueue<ITmfEvent>(10000);
        this.ssAssigned = false;
        String id2 = id == null ? "Unamed" : id;
        this.eventHandlerThread = new Thread((Runnable)new EventProcessor(), String.valueOf(id2) + " Event Handler");
    }

    @Override
    public ITmfTrace getTrace() {
        return this.trace;
    }

    @Override
    public long getStartTime() {
        return this.trace.getStartTime().normalize(0L, -9).getValue();
    }

    @Override
    public void assignTargetStateSystem(ITmfStateSystemBuilder ssb) {
        this.ss = ssb;
        this.ssAssigned = true;
        this.eventHandlerThread.start();
    }

    @Override
    public ITmfStateSystem getAssignedStateSystem() {
        return this.ss;
    }

    @Override
    public void dispose() {
        try {
            this.eventsQueue.put(CtfTmfEventFactory.getNullEvent());
            this.eventHandlerThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.ssAssigned = false;
        this.ss = null;
    }

    @Override
    public final Class<? extends ITmfEvent> getExpectedEventType() {
        return this.eventType;
    }

    @Override
    public final void processEvent(ITmfEvent event) {
        if (!this.ssAssigned) {
            System.err.println("Cannot process event without a target state system");
            return;
        }
        ITmfEvent curEvent = event;
        try {
            this.eventsQueue.put(curEvent);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void waitForEmptyQueue() {
        EmptyEvent ev = new EmptyEvent();
        try {
            this.eventsQueue.put(ev);
            while (!this.eventsQueue.isEmpty()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected abstract void eventHandle(ITmfEvent var1);

    private class EmptyEvent
    extends TmfEvent {
        public EmptyEvent() {
            super(null, new TmfTimestamp(0L), null, null, null, null);
        }
    }

    private class EventProcessor
    implements Runnable {
        private EventProcessor() {
        }

        @Override
        public void run() {
            if (AbstractTmfStateProvider.this.ss == null) {
                System.err.println("Cannot run event manager without assigning a target state system first!");
                return;
            }
            try {
                ITmfEvent event = (ITmfEvent)AbstractTmfStateProvider.this.eventsQueue.take();
                while (event.getTimestamp().getValue() != -1L) {
                    if (event instanceof EmptyEvent) {
                        event = (ITmfEvent)AbstractTmfStateProvider.this.eventsQueue.take();
                        continue;
                    }
                    AbstractTmfStateProvider.this.currentEvent = event;
                    if (AbstractTmfStateProvider.this.eventType.isInstance(event) && event.getType() != null) {
                        AbstractTmfStateProvider.this.eventHandle(event);
                    }
                    event = (ITmfEvent)AbstractTmfStateProvider.this.eventsQueue.take();
                }
                this.closeStateSystem();
                return;
            }
            catch (InterruptedException e) {
                System.out.println("Event handler interrupted!");
                e.printStackTrace();
                return;
            }
        }

        private void closeStateSystem() {
            if (AbstractTmfStateProvider.this.currentEvent == null) {
                return;
            }
            try {
                AbstractTmfStateProvider.this.ss.closeHistory(AbstractTmfStateProvider.this.currentEvent.getTimestamp().normalize(0L, -9).getValue());
            }
            catch (TimeRangeException e) {
                e.printStackTrace();
            }
        }
    }
}

