/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.ICreateSessionDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TargetNodeComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionGroup;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.IRemoteSystemProxy;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateSessionDialog
extends Dialog
implements ICreateSessionDialog {
    public static final String CREATE_SESSION_ICON_FILE = "icons/elcl16/add_button.gif";
    private static final int COMMON_URL_LAST_INDEX = 1;
    private static final int DEFAULT_URL_INDEX = 0;
    private Control fControl = null;
    private Composite fDialogComposite = null;
    private Text fSessionNameText = null;
    private Label fSessionPathLabel = null;
    private Text fSessionPathText = null;
    private Group fMainStreamingGroup = null;
    private Button fConfigureStreamingButton = null;
    private Composite fStreamingComposite = null;
    private Text fTracePathText = null;
    private Button fLinkDataWithControlButton = null;
    private CCombo fControlProtocolCombo = null;
    private ControlProtocolSelectionListener fCopyProtocolSelectionListener;
    private ProtocolComboSelectionListener fControlProtocolSelectionListener;
    private ProtocolComboSelectionListener fDataProtocolSelectionListener;
    private Text fControlHostAddressText = null;
    private CopyModifyListener fControlUrlKeyListener;
    private Text fControlPortText = null;
    private CCombo fDataProtocolCombo = null;
    private Text fDataHostAddressText = null;
    private Text fDataPortText = null;
    private TraceSessionGroup fParent = null;
    private String fSessionName = null;
    private String fSessionPath = null;
    private boolean fIsDefaultPath = true;
    private boolean fIsStreamedTrace = false;
    private String fNetworkUrl = null;
    private String fControlUrl = null;
    private String fDataUrl = null;
    private String fTracePath = null;

    public CreateSessionDialog(Shell shell) {
        super(shell);
        this.setShellStyle(16);
    }

    @Override
    public String getSessionName() {
        return this.fSessionName;
    }

    @Override
    public String getSessionPath() {
        return this.fSessionPath;
    }

    @Override
    public boolean isDefaultSessionPath() {
        return this.fIsDefaultPath;
    }

    @Override
    public void initialize(TraceSessionGroup group) {
        this.fParent = group;
        this.fStreamingComposite = null;
        this.fSessionName = null;
        this.fSessionPath = null;
        this.fIsDefaultPath = true;
        this.fIsStreamedTrace = false;
        this.fNetworkUrl = null;
        this.fControlUrl = null;
        this.fDataUrl = null;
    }

    @Override
    public boolean isStreamedTrace() {
        return this.fIsStreamedTrace;
    }

    @Override
    public String getNetworkUrl() {
        return this.fNetworkUrl;
    }

    @Override
    public String getControlUrl() {
        return this.fControlUrl;
    }

    @Override
    public String getDataUrl() {
        return this.fDataUrl;
    }

    protected Control createContents(Composite parent) {
        this.fControl = super.createContents(parent);
        Point clientArea = this.fControl.computeSize(-1, -1);
        Rectangle trim = this.getShell().computeTrim(0, 0, clientArea.x, clientArea.y);
        this.getShell().setMinimumSize(trim.width, trim.height);
        return this.fControl;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_CreateSessionDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(CREATE_SESSION_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        Group sessionGroup = new Group(this.fDialogComposite, 32);
        sessionGroup.setLayoutData((Object)new GridData(768));
        sessionGroup.setLayout((Layout)new GridLayout(4, true));
        Label sessionNameLabel = new Label((Composite)sessionGroup, 131072);
        sessionNameLabel.setText(Messages.TraceControl_CreateSessionNameLabel);
        this.fSessionNameText = new Text((Composite)sessionGroup, 0);
        this.fSessionNameText.setToolTipText(Messages.TraceControl_CreateSessionNameTooltip);
        this.fSessionPathLabel = new Label((Composite)sessionGroup, 131072);
        this.fSessionPathLabel.setText(Messages.TraceControl_CreateSessionPathLabel);
        this.fSessionPathText = new Text((Composite)sessionGroup, 0);
        this.fSessionPathText.setToolTipText(Messages.TraceControl_CreateSessionPathTooltip);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.fSessionNameText.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.fSessionPathText.setLayoutData((Object)data);
        if (this.fParent.isNetworkStreamingSupported()) {
            this.createAdvancedOptionsComposite();
        }
        return this.fDialogComposite;
    }

    private void createAdvancedOptionsComposite() {
        this.fMainStreamingGroup = new Group(this.fDialogComposite, 32);
        this.fMainStreamingGroup.setLayoutData((Object)new GridData(1808));
        this.fMainStreamingGroup.setLayout((Layout)new GridLayout(1, true));
        this.fConfigureStreamingButton = new Button((Composite)this.fMainStreamingGroup, 8);
        this.fConfigureStreamingButton.setText(String.valueOf(Messages.TraceControl_CreateSessionConfigureStreamingButtonText) + " >>>");
        this.fConfigureStreamingButton.setToolTipText(Messages.TraceControl_CreateSessionConfigureStreamingButtonTooltip);
        this.fConfigureStreamingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateSessionDialog.this.fIsStreamedTrace) {
                    CreateSessionDialog.this.fIsStreamedTrace = false;
                    CreateSessionDialog.this.fConfigureStreamingButton.setText(">>> " + Messages.TraceControl_CreateSessionConfigureStreamingButtonText);
                    CreateSessionDialog.this.fConfigureStreamingButton.setToolTipText(Messages.TraceControl_CreateSessionConfigureStreamingButtonTooltip);
                    CreateSessionDialog.this.fSessionPathText.setEnabled(true);
                    CreateSessionDialog.this.fSessionPathLabel.setText(Messages.TraceControl_CreateSessionPathLabel);
                    CreateSessionDialog.this.disposeConfigureStreamingComposite();
                } else {
                    CreateSessionDialog.this.fIsStreamedTrace = true;
                    CreateSessionDialog.this.fConfigureStreamingButton.setText("<<< " + Messages.TraceControl_CreateSessionNoStreamingButtonText);
                    CreateSessionDialog.this.fConfigureStreamingButton.setToolTipText(Messages.TraceControl_CreateSessionNoStreamingButtonTooltip);
                    CreateSessionDialog.this.fSessionPathText.setEnabled(false);
                    CreateSessionDialog.this.fSessionPathText.setText("");
                    CreateSessionDialog.this.fSessionPathLabel.setText("");
                    CreateSessionDialog.this.createConfigureStreamingComposite();
                }
                CreateSessionDialog.this.fDialogComposite.layout();
                Point clientArea = CreateSessionDialog.this.fControl.computeSize(-1, -1);
                Rectangle trim = CreateSessionDialog.this.getShell().computeTrim(0, 0, clientArea.x, clientArea.y);
                CreateSessionDialog.this.getShell().setSize(trim.width, trim.height);
            }
        });
    }

    private void createConfigureStreamingComposite() {
        if (this.fStreamingComposite == null) {
            this.fStreamingComposite = new Composite((Composite)this.fMainStreamingGroup, 0);
            GridLayout layout = new GridLayout(1, true);
            this.fStreamingComposite.setLayout((Layout)layout);
            this.fStreamingComposite.setLayoutData((Object)new GridData(1808));
            Group urlGroup = new Group(this.fStreamingComposite, 32);
            layout = new GridLayout(7, true);
            urlGroup.setLayout((Layout)layout);
            urlGroup.setLayoutData((Object)new GridData(1808));
            Label tracePathLabel = new Label((Composite)urlGroup, 131072);
            tracePathLabel.setText(Messages.TraceControl_CreateSessionTracePathText);
            this.fTracePathText = new Text((Composite)urlGroup, 0);
            this.fTracePathText.setToolTipText(Messages.TraceControl_CreateSessionTracePathTooltip);
            GridData data = new GridData(768);
            data.horizontalSpan = 6;
            this.fTracePathText.setLayoutData((Object)data);
            this.fLinkDataWithControlButton = new Button((Composite)urlGroup, 32);
            this.fLinkDataWithControlButton.setText(Messages.TraceControl_CreateSessionLinkButtonText);
            this.fLinkDataWithControlButton.setToolTipText(Messages.TraceControl_CreateSessionLinkButtonTooltip);
            data = new GridData(768);
            data.horizontalSpan = 7;
            this.fLinkDataWithControlButton.setLayoutData((Object)data);
            this.fLinkDataWithControlButton.setSelection(true);
            Label label = new Label((Composite)urlGroup, 0);
            data = new GridData(768);
            data.horizontalSpan = 1;
            label.setLayoutData((Object)data);
            label = new Label((Composite)urlGroup, 0);
            label.setText(Messages.TraceControl_CreateSessionProtocolLabelText);
            data = new GridData(768);
            data.horizontalSpan = 1;
            label.setLayoutData((Object)data);
            label = new Label((Composite)urlGroup, 0);
            label.setText(Messages.TraceControl_CreateSessionAddressLabelText);
            data = new GridData(768);
            data.horizontalSpan = 4;
            label.setLayoutData((Object)data);
            label = new Label((Composite)urlGroup, 0);
            label.setText(Messages.TraceControl_CreateSessionPortLabelText);
            data = new GridData(768);
            data.horizontalSpan = 1;
            label.setLayoutData((Object)data);
            label = new Label((Composite)urlGroup, 131072);
            label.setText(Messages.TraceControl_CreateSessionControlUrlLabel);
            data = new GridData(768);
            data.horizontalSpan = 1;
            label.setLayoutData((Object)data);
            this.fControlProtocolCombo = new CCombo((Composite)urlGroup, 8);
            this.fControlProtocolCombo.setToolTipText(Messages.TraceControl_CreateSessionCommonProtocolTooltip);
            data = new GridData(768);
            data.horizontalSpan = 1;
            this.fControlProtocolCombo.setLayoutData((Object)data);
            this.fControlHostAddressText = new Text((Composite)urlGroup, 0);
            this.fControlHostAddressText.setToolTipText(Messages.TraceControl_CreateSessionControlAddressTooltip);
            data = new GridData(768);
            data.horizontalSpan = 4;
            this.fControlHostAddressText.setLayoutData((Object)data);
            this.fControlPortText = new Text((Composite)urlGroup, 0);
            this.fControlPortText.setToolTipText(Messages.TraceControl_CreateSessionControlPortTooltip);
            data = new GridData(768);
            data.horizontalSpan = 1;
            this.fControlPortText.setLayoutData((Object)data);
            label = new Label((Composite)urlGroup, 131072);
            label.setText(Messages.TraceControl_CreateSessionDataUrlLabel);
            data = new GridData(768);
            data.horizontalSpan = 1;
            label.setLayoutData((Object)data);
            this.fDataProtocolCombo = new CCombo((Composite)urlGroup, 8);
            this.fDataProtocolCombo.setEnabled(false);
            this.fDataProtocolCombo.setToolTipText(Messages.TraceControl_CreateSessionProtocolTooltip);
            data = new GridData(768);
            data.horizontalSpan = 1;
            this.fDataProtocolCombo.setLayoutData((Object)data);
            String[] items = new String[StreamingProtocol.values().length];
            int i = 0;
            while (i < items.length) {
                items[i] = StreamingProtocol.values()[i].name();
                ++i;
            }
            this.fControlProtocolCombo.setItems(items);
            this.fDataProtocolCombo.setItems(items);
            this.fDataHostAddressText = new Text((Composite)urlGroup, 0);
            this.fDataHostAddressText.setEnabled(false);
            this.fDataHostAddressText.setToolTipText(Messages.TraceControl_CreateSessionDataAddressTooltip);
            data = new GridData(768);
            data.horizontalSpan = 4;
            this.fDataHostAddressText.setLayoutData((Object)data);
            this.fDataPortText = new Text((Composite)urlGroup, 0);
            this.fDataPortText.setEnabled(true);
            this.fDataPortText.setToolTipText(Messages.TraceControl_CreateSessionDataPortTooltip);
            data = new GridData(768);
            data.horizontalSpan = 1;
            this.fDataPortText.setLayoutData((Object)data);
            this.fCopyProtocolSelectionListener = new ControlProtocolSelectionListener();
            this.fControlProtocolSelectionListener = new ProtocolComboSelectionListener(this.fControlProtocolCombo, this.fControlPortText);
            this.fDataProtocolSelectionListener = new ProtocolComboSelectionListener(this.fDataProtocolCombo, this.fDataPortText);
            this.fControlProtocolCombo.addSelectionListener((SelectionListener)this.fCopyProtocolSelectionListener);
            this.fControlUrlKeyListener = new CopyModifyListener(this.fControlHostAddressText, this.fDataHostAddressText);
            this.fControlHostAddressText.addModifyListener((ModifyListener)this.fControlUrlKeyListener);
            this.fControlProtocolCombo.select(0);
            this.fDataProtocolCombo.select(0);
            this.fLinkDataWithControlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CreateSessionDialog.this.fLinkDataWithControlButton.getSelection()) {
                        CreateSessionDialog.this.fDataProtocolCombo.setEnabled(false);
                        CreateSessionDialog.this.fDataHostAddressText.setEnabled(false);
                        CreateSessionDialog.this.fControlPortText.setEnabled(true);
                        CreateSessionDialog.this.fDataPortText.setEnabled(true);
                        CreateSessionDialog.this.fControlProtocolCombo.removeSelectionListener((SelectionListener)CreateSessionDialog.this.fControlProtocolSelectionListener);
                        CreateSessionDialog.this.fDataProtocolCombo.removeSelectionListener((SelectionListener)CreateSessionDialog.this.fDataProtocolSelectionListener);
                        CreateSessionDialog.this.fControlProtocolCombo.addSelectionListener((SelectionListener)CreateSessionDialog.this.fCopyProtocolSelectionListener);
                        CreateSessionDialog.this.fControlHostAddressText.addModifyListener((ModifyListener)CreateSessionDialog.this.fControlUrlKeyListener);
                        int currentSelection = CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex() <= 1 ? CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex() : 0;
                        CreateSessionDialog.this.fControlProtocolCombo.removeAll();
                        String[] controlItems = new String[StreamingProtocol.values().length];
                        int i = 0;
                        while (i < controlItems.length) {
                            controlItems[i] = StreamingProtocol.values()[i].name();
                            ++i;
                        }
                        CreateSessionDialog.this.fControlProtocolCombo.setItems(controlItems);
                        CreateSessionDialog.this.fDataProtocolCombo.setItems(controlItems);
                        CreateSessionDialog.this.fControlProtocolCombo.select(currentSelection);
                        CreateSessionDialog.this.fDataProtocolCombo.select(currentSelection);
                        CreateSessionDialog.this.fDataHostAddressText.setText(CreateSessionDialog.this.fControlHostAddressText.getText());
                        CreateSessionDialog.this.fControlProtocolCombo.setToolTipText(Messages.TraceControl_CreateSessionCommonProtocolTooltip);
                    } else {
                        CreateSessionDialog.this.fDataProtocolCombo.setEnabled(true);
                        CreateSessionDialog.this.fDataHostAddressText.setEnabled(true);
                        CreateSessionDialog.this.fControlProtocolCombo.removeSelectionListener((SelectionListener)CreateSessionDialog.this.fCopyProtocolSelectionListener);
                        CreateSessionDialog.this.fControlProtocolCombo.addSelectionListener((SelectionListener)CreateSessionDialog.this.fControlProtocolSelectionListener);
                        CreateSessionDialog.this.fDataProtocolCombo.addSelectionListener((SelectionListener)CreateSessionDialog.this.fDataProtocolSelectionListener);
                        CreateSessionDialog.this.fControlHostAddressText.removeModifyListener((ModifyListener)CreateSessionDialog.this.fControlUrlKeyListener);
                        int currentSelection = CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex();
                        CreateSessionDialog.this.fControlProtocolCombo.removeAll();
                        String[] controlItems = new String[StreamingProtocol2.values().length];
                        int i = 0;
                        while (i < controlItems.length) {
                            controlItems[i] = StreamingProtocol2.values()[i].name();
                            ++i;
                        }
                        CreateSessionDialog.this.fControlProtocolCombo.setItems(controlItems);
                        CreateSessionDialog.this.fDataProtocolCombo.setItems(controlItems);
                        CreateSessionDialog.this.fControlProtocolCombo.select(currentSelection);
                        CreateSessionDialog.this.fDataProtocolCombo.select(currentSelection);
                        CreateSessionDialog.this.fDataProtocolCombo.setToolTipText(Messages.TraceControl_CreateSessionProtocolTooltip);
                        CreateSessionDialog.this.fControlProtocolCombo.setToolTipText(Messages.TraceControl_CreateSessionProtocolTooltip);
                        if (CreateSessionDialog.this.fControlProtocolCombo.getItem(CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex()).equals(StreamingProtocol.net.name()) || CreateSessionDialog.this.fControlProtocolCombo.getItem(CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex()).equals(StreamingProtocol.net6.name())) {
                            CreateSessionDialog.this.fControlPortText.setText("");
                            CreateSessionDialog.this.fControlPortText.setEnabled(false);
                        } else {
                            CreateSessionDialog.this.fControlPortText.setEnabled(true);
                        }
                        if (CreateSessionDialog.this.fDataProtocolCombo.getItem(CreateSessionDialog.this.fDataProtocolCombo.getSelectionIndex()).equals(StreamingProtocol.net.name()) || CreateSessionDialog.this.fDataProtocolCombo.getItem(CreateSessionDialog.this.fDataProtocolCombo.getSelectionIndex()).equals(StreamingProtocol.net6.name())) {
                            CreateSessionDialog.this.fDataPortText.setText("");
                            CreateSessionDialog.this.fDataPortText.setEnabled(false);
                        } else {
                            CreateSessionDialog.this.fDataPortText.setEnabled(true);
                        }
                    }
                }
            });
        }
    }

    private void disposeConfigureStreamingComposite() {
        if (this.fStreamingComposite != null) {
            this.fStreamingComposite.dispose();
            this.fStreamingComposite = null;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        this.fSessionName = this.fSessionNameText.getText();
        this.fSessionPath = this.fSessionPathText.getText();
        if (!"".equals(this.fSessionPath)) {
            TargetNodeComponent node;
            IRemoteSystemProxy proxy;
            IFileServiceSubSystem fsss;
            if (!this.fIsStreamedTrace && (fsss = (proxy = (node = (TargetNodeComponent)this.fParent.getParent()).getRemoteSystemProxy()).getFileServiceSubSystem()) != null) {
                try {
                    IRemoteFile remoteFolder = fsss.getRemoteFileObject(this.fSessionPath, (IProgressMonitor)new NullProgressMonitor());
                    if (remoteFolder == null) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidSessionPathError) + " (" + this.fSessionPath + ") \n"));
                        return;
                    }
                    if (remoteFolder.exists()) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)(String.valueOf(Messages.TraceControl_SessionPathAlreadyExistsError) + " (" + this.fSessionPath + ") \n"));
                        return;
                    }
                }
                catch (SystemMessageException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)(String.valueOf(Messages.TraceControl_FileSubSystemError) + "\n" + (Object)((Object)e)));
                    return;
                }
            }
            this.fIsDefaultPath = false;
        }
        this.fNetworkUrl = null;
        this.fControlUrl = null;
        this.fDataUrl = null;
        if (this.fIsStreamedTrace) {
            this.fTracePath = this.fTracePathText.getText();
            if (this.fControlProtocolCombo.getSelectionIndex() < 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)"Control Protocol Text is empty\n");
                return;
            }
            if ("".equals(this.fControlHostAddressText.getText())) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)"Control Address Text is empty\n");
                return;
            }
            if (!this.fLinkDataWithControlButton.getSelection()) {
                if (this.fDataProtocolCombo.getSelectionIndex() < 0) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)"Control Protocol Text is empty\n");
                    return;
                }
                if ("".equals(this.fDataHostAddressText.getText())) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)"Control Address Text is empty\n");
                    return;
                }
                this.fControlUrl = CreateSessionDialog.getUrlString(this.fControlProtocolCombo.getItem(this.fControlProtocolCombo.getSelectionIndex()), this.fControlHostAddressText.getText(), this.fControlPortText.getText(), null, this.fTracePath);
                this.fDataUrl = CreateSessionDialog.getUrlString(this.fControlProtocolCombo.getItem(this.fDataProtocolCombo.getSelectionIndex()), this.fDataHostAddressText.getText(), null, this.fDataPortText.getText(), this.fTracePath);
            } else {
                this.fNetworkUrl = CreateSessionDialog.getUrlString(this.fControlProtocolCombo.getItem(this.fDataProtocolCombo.getSelectionIndex()), this.fControlHostAddressText.getText(), this.fControlPortText.getText(), this.fDataPortText.getText(), this.fTracePath);
            }
        }
        if (!"".equals(this.fSessionName) && !this.fSessionName.matches("^[a-zA-Z0-9\\-\\_]{1,}$")) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)(String.valueOf(Messages.TraceControl_InvalidSessionNameError) + " (" + this.fSessionName + ") \n"));
            return;
        }
        if (this.fParent.containsChild(this.fSessionName)) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_CreateSessionDialogTitle, (String)(String.valueOf(Messages.TraceControl_SessionAlreadyExistsError) + " (" + this.fSessionName + ")"));
            return;
        }
        super.okPressed();
    }

    private static String getUrlString(String proto, String host, String ctrlPort, String dataPort, String sessionPath) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(proto);
        stringBuilder.append("://");
        stringBuilder.append(host);
        if (ctrlPort != null && !"".equals(ctrlPort)) {
            stringBuilder.append(":");
            stringBuilder.append(ctrlPort);
        }
        if (dataPort != null && !"".equals(dataPort)) {
            stringBuilder.append(":");
            stringBuilder.append(dataPort);
        }
        if (sessionPath != null && !"".equals(sessionPath)) {
            stringBuilder.append("/");
            stringBuilder.append(sessionPath);
        }
        return stringBuilder.toString();
    }

    private class ControlProtocolSelectionListener
    extends SelectionAdapter {
        private ControlProtocolSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            CreateSessionDialog.this.fDataProtocolCombo.select(CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex());
            if (CreateSessionDialog.this.fControlProtocolCombo.getItem(CreateSessionDialog.this.fControlProtocolCombo.getSelectionIndex()).equals(StreamingProtocol.file.name())) {
                CreateSessionDialog.this.fControlPortText.setText("");
                CreateSessionDialog.this.fDataPortText.setText("");
                CreateSessionDialog.this.fControlPortText.setEnabled(false);
                CreateSessionDialog.this.fDataPortText.setEnabled(false);
            } else {
                CreateSessionDialog.this.fControlPortText.setEnabled(true);
                CreateSessionDialog.this.fDataPortText.setEnabled(true);
            }
        }
    }

    private static class CopyModifyListener
    implements ModifyListener {
        private Text fSource;
        private Text fDestination;

        public CopyModifyListener(Text source, Text destination) {
            this.fSource = source;
            this.fDestination = destination;
        }

        public void modifyText(ModifyEvent e) {
            this.fDestination.setText(this.fSource.getText());
        }
    }

    private class ProtocolComboSelectionListener
    extends SelectionAdapter {
        private CCombo fCombo;
        private Text fPortText;

        public ProtocolComboSelectionListener(CCombo combo, Text portText) {
            this.fCombo = combo;
            this.fPortText = portText;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.fCombo.getItem(this.fCombo.getSelectionIndex()).equals(StreamingProtocol.net.name()) || this.fCombo.getItem(this.fCombo.getSelectionIndex()).equals(StreamingProtocol.net6.name())) {
                this.fPortText.setText("");
                this.fPortText.setEnabled(false);
            } else {
                this.fPortText.setEnabled(true);
            }
        }
    }

    private static enum StreamingProtocol {
        net,
        net6,
        file;

    }

    private static enum StreamingProtocol2 {
        net,
        net6,
        tcp,
        tcp6;

    }
}

