/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;

public class ScrollView
extends Composite {
    public static final int AUTO = 0;
    public static final int ALWAYS_ON = 1;
    public static final int ALWAYS_OFF = 2;
    public static final int VBAR = 1;
    public static final int HBAR = 2;
    private static final int DEFAULT_H_SCROLL_INCREMENT = 10;
    private static final int DEFAULT_V_SCROLL_INCREMENT = 10;
    private static final int DEFAULT_AUTO_SCROLL_PERIOD = 75;
    private static final int DEFAULT_OVERVIEW_SIZE = 100;
    private int fContentsHeight = 0;
    private int fContentsWidth = 0;
    private int fContentsX = 0;
    private int fContentsY = 0;
    private int fHorScrollbarMode = 0;
    private int fVertScrollbarMode = 0;
    private int fHorScrollbarIncrement = 10;
    private int fVertScrollbarIncrement = 10;
    private boolean fAutoScrollEnabled = true;
    private int fAutoScrollPeriod = 75;
    private PaintListener fLocalPaintListener = null;
    private MouseMoveListener fLocalMouseMoveListener = null;
    private MouseListener fLocalMouseListener = null;
    private ControlListener fLocalControlListener = null;
    private KeyListener fLocalKeyListener = null;
    private Canvas fHorScrollBar = new Canvas((Composite)this, 256);
    private Canvas fVertScrollBar;
    private Canvas fViewControl;
    private Control fCornerControl;
    private int fOverviewSize = 100;
    private AutoScroll fAutoScroll = null;
    private Timer fAutoScrollTimer = null;
    private int fMouseDownX = -1;
    private int fMousDownY = -1;
    private static volatile Cursor fOverviewCursor;

    public ScrollView(Composite c, int style) {
        this(c, style, true);
    }

    public ScrollView(Composite c, int style, boolean mouseWheel) {
        super(c, 0);
        this.fViewControl = mouseWheel ? new Canvas((Composite)this, style | 0x100 | 0x200) : new Canvas((Composite)this, style);
        this.fViewControl.setBackground(this.getBackground());
        if (mouseWheel) {
            this.fViewControl.getVerticalBar().setVisible(false);
            this.fViewControl.getHorizontalBar().setVisible(false);
        }
        this.fVertScrollBar = new Canvas((Composite)this, 512);
        this.setLayout(new SVLayout());
        this.fLocalPaintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                Rectangle r = event.gc.getClipping();
                int cx = ScrollView.this.viewToContentsX(r.x);
                int cy = ScrollView.this.viewToContentsY(r.y);
                ScrollView.this.drawContents(event.gc, cx, cy, r.width, r.height);
            }
        };
        this.fViewControl.addPaintListener(this.fLocalPaintListener);
        this.fLocalMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseMoveEvent(e);
                e.x = ox;
                e.y = oy;
            }
        };
        this.fViewControl.addMouseMoveListener(this.fLocalMouseMoveListener);
        MouseTrackListener localMouseTrackListener = new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseEnter(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseHover(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseHover(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseExit(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseExit(e);
                e.x = ox;
                e.y = oy;
            }
        };
        this.fViewControl.addMouseTrackListener(localMouseTrackListener);
        this.fLocalMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseDoubleClickEvent(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseDown(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                ScrollView.this.fMouseDownX = e.x;
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.fMousDownY = e.y;
                ScrollView.this.contentsMouseDownEvent(e);
                e.x = ox;
                e.y = oy;
            }

            public void mouseUp(MouseEvent e) {
                int ox = e.x;
                int oy = e.y;
                e.x = ScrollView.this.viewToContentsX(e.x);
                e.y = ScrollView.this.viewToContentsY(e.y);
                ScrollView.this.contentsMouseUpEvent(e);
                e.x = ox;
                e.y = oy;
                ScrollView.this.fMouseDownX = -1;
                ScrollView.this.fMousDownY = -1;
            }
        };
        this.fViewControl.addMouseListener(this.fLocalMouseListener);
        this.fLocalKeyListener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ScrollView.this.keyPressedEvent(e);
            }

            public void keyReleased(KeyEvent e) {
                ScrollView.this.keyReleasedEvent(e);
            }
        };
        this.fViewControl.addKeyListener(this.fLocalKeyListener);
        this.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScrollView.this.setContentsPos(ScrollView.this.fContentsX, ScrollView.this.getVerticalBar().getSelection());
                if (!ScrollView.this.fViewControl.isFocusControl()) {
                    ScrollView.this.fViewControl.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.fViewControl.getVerticalBar() != null) {
            this.fViewControl.getVerticalBar().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ScrollBar b = ScrollView.this.fViewControl.getVerticalBar();
                    ScrollView.this.setContentsPos(ScrollView.this.fContentsX, b.getSelection());
                    ScrollView.this.getVerticalBar().setSelection(b.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.getHorizontalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScrollView.this.setContentsPos(ScrollView.this.getHorizontalBar().getSelection(), ScrollView.this.fContentsY);
                if (!ScrollView.this.fViewControl.isFocusControl()) {
                    ScrollView.this.fViewControl.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.fViewControl.getHorizontalBar() != null) {
            this.fViewControl.getHorizontalBar().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ScrollBar b = ScrollView.this.fViewControl.getHorizontalBar();
                    ScrollView.this.setContentsPos(b.getSelection(), ScrollView.this.fContentsY);
                    ScrollView.this.getHorizontalBar().setSelection(b.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public boolean setFocus() {
        return this.fViewControl.forceFocus();
    }

    public void setCursor(Cursor cursor) {
        this.fViewControl.setCursor(cursor);
    }

    public void dispose() {
        if (this.fAutoScroll != null) {
            this.fAutoScroll.cancel();
            this.fAutoScroll = null;
        }
        if (this.fViewControl != null) {
            this.fViewControl.dispose();
        }
        this.fViewControl = null;
        if (this.fVertScrollBar != null) {
            this.fVertScrollBar.dispose();
        }
        this.fVertScrollBar = null;
        if (this.fHorScrollBar != null) {
            this.fHorScrollBar.dispose();
        }
        this.fHorScrollBar = null;
        if (this.fCornerControl != null) {
            Object data = this.fCornerControl.getData();
            if (data instanceof Overview) {
                ((Overview)data).dispose();
            }
            this.fCornerControl.dispose();
            this.fCornerControl = null;
        }
        super.dispose();
    }

    public Rectangle getClientArea() {
        return this.fViewControl.getClientArea();
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.fViewControl.setBackground(c);
    }

    public void setToolTipText(String text) {
        this.fViewControl.setToolTipText(text);
    }

    protected void drawOverview(GC gc, Rectangle r) {
        int x = (int)((float)(r.width * this.fContentsX) / (float)this.fContentsWidth);
        int y = (int)((float)(r.height * this.fContentsY) / (float)this.fContentsHeight);
        int vw = this.getVisibleWidth();
        int vh = this.getVisibleHeight();
        int w = r.width - 1;
        if (this.fContentsWidth > vw) {
            w = (int)((float)(r.width * vw) / (float)this.fContentsWidth);
        }
        int h = r.height - 1;
        if (this.fContentsHeight > vh) {
            h = (int)((float)(r.height * vh) / (float)this.fContentsHeight);
        }
        gc.setForeground(this.getForeground());
        if (w < 5 || h < 5) {
            gc.drawLine(x, 0, x, r.height);
            gc.drawLine(0, y, r.width, y);
        } else {
            gc.drawRectangle(x, y, w, h);
        }
    }

    public void replaceControlListener(ControlListener nlistener) {
        if (this.fLocalControlListener != null) {
            this.removeControlListener(this.fLocalControlListener);
            this.fLocalControlListener = null;
        }
        this.addControlListener(nlistener);
    }

    public void replaceKeyListener(KeyListener nlistener) {
        if (this.fLocalKeyListener != null) {
            this.removeKeyListener(this.fLocalKeyListener);
            this.fLocalKeyListener = null;
        }
        this.addKeyListener(nlistener);
    }

    public void replaceMouseListener(MouseListener nlistener) {
        if (this.fLocalMouseListener != null) {
            this.removeMouseListener(this.fLocalMouseListener);
            this.fLocalMouseListener = null;
        }
        this.fViewControl.addMouseListener(nlistener);
    }

    public void replaceMouseMoveListener(MouseMoveListener nlistener) {
        if (this.fLocalMouseMoveListener != null) {
            this.removeMouseMoveListener(this.fLocalMouseMoveListener);
            this.fLocalMouseMoveListener = null;
        }
        this.fViewControl.addMouseMoveListener(nlistener);
    }

    public void replacePaintListener(PaintListener nlistener) {
        if (this.fLocalPaintListener != null) {
            this.removePaintListener(this.fLocalPaintListener);
            this.fLocalPaintListener = null;
        }
        this.fViewControl.addPaintListener(nlistener);
    }

    public int getContentsHeight() {
        return this.fContentsHeight;
    }

    public int getContentsWidth() {
        return this.fContentsWidth;
    }

    public int getContentsX() {
        return this.fContentsX;
    }

    public int getContentsY() {
        return this.fContentsY;
    }

    public boolean isDragAutoScroll() {
        return this.fAutoScrollEnabled;
    }

    public void setDragAutoScroll(boolean aDragAutoScroll) {
        this.fAutoScrollEnabled = aDragAutoScroll;
        if (!this.fAutoScrollEnabled && this.fAutoScroll != null) {
            this.fAutoScroll.cancel();
            this.fAutoScroll = null;
        }
    }

    public void setDragAutoScrollPeriod(int period) {
        this.fAutoScrollPeriod = Math.max(0, period);
    }

    public int getDragAutoScrollPeriod() {
        return this.fAutoScrollPeriod;
    }

    public int getHScrollBarMode() {
        return this.fHorScrollbarMode;
    }

    public void setHScrollBarMode(int aHScrollBarMode) {
        this.fHorScrollbarMode = aHScrollBarMode;
    }

    public int getVScrollBarMode() {
        return this.fVertScrollbarMode;
    }

    public void setVScrollBarMode(int aVScrollBarMode) {
        this.fVertScrollbarMode = aVScrollBarMode;
    }

    public int getHScrollBarIncrement() {
        return this.fHorScrollbarIncrement;
    }

    public int getVScrollBarIncrement() {
        return this.fVertScrollbarIncrement;
    }

    public void setHScrollBarIncrement(int inc) {
        this.fHorScrollbarIncrement = Math.max(1, inc);
    }

    public void setVScrollBarIncrement(int inc) {
        this.fVertScrollbarIncrement = Math.max(1, inc);
    }

    public void setOverviewEnabled(boolean value) {
        if (this.isOverviewEnabled() == value) {
            return;
        }
        Button cc = null;
        if (value) {
            Button b = new Button((Composite)this, 0);
            b.setText("+");
            Overview ovr = new Overview();
            ovr.useControl((Control)b);
            b.setData((Object)ovr);
            cc = b;
            b.setToolTipText(Messages.SequenceDiagram_OpenOverviewTooltip);
        }
        this.setCornerControl((Control)cc);
    }

    public void setOverviewSize(int size) {
        this.fOverviewSize = Math.abs(size);
    }

    public boolean isOverviewEnabled() {
        Object data;
        return this.fCornerControl instanceof Button && (data = ((Button)this.fCornerControl).getData()) instanceof Overview;
    }

    public int getOverviewSize() {
        return this.fOverviewSize;
    }

    public Control getViewControl() {
        return this.fViewControl;
    }

    protected void contentsMouseExit(MouseEvent e) {
    }

    protected void contentsMouseHover(MouseEvent e) {
    }

    protected void contentsMouseEnter(MouseEvent e) {
    }

    protected void contentsMouseDoubleClickEvent(MouseEvent e) {
    }

    protected void contentsMouseDownEvent(MouseEvent e) {
        this.fMouseDownX = e.x;
        this.fMousDownY = e.y;
    }

    protected void contentsMouseMoveEvent(MouseEvent event) {
        if ((event.stateMask & SWT.BUTTON_MASK) != 0) {
            if (!this.fAutoScrollEnabled) {
                this.scrollBy(-(event.x - this.fMouseDownX), -(event.y - this.fMousDownY));
                return;
            }
            int sx = 0;
            int sy = 0;
            int vRight = this.getContentsX() + this.getVisibleWidth();
            int vBottom = this.getContentsY() + this.getVisibleHeight();
            if (event.x < this.getContentsX()) {
                sx = this.getContentsX() - event.x;
                this.fMouseDownX = this.getContentsX();
            } else if (event.x > vRight) {
                sx = -event.x + vRight;
                this.fMouseDownX = vRight;
            }
            if (event.y < this.getContentsY()) {
                sy = this.getContentsY() - event.y;
                this.fMousDownY = this.getContentsY();
            } else if (event.y > vBottom) {
                sy = -event.y + vBottom;
                this.fMousDownY = vBottom;
            }
            if (sx != 0 || sy != 0) {
                if (this.fAutoScroll == null) {
                    if (this.fAutoScrollTimer == null) {
                        this.fAutoScrollTimer = new Timer(true);
                    }
                    this.fAutoScroll = new AutoScroll(this, sx, sy);
                    this.fAutoScrollTimer.schedule((TimerTask)this.fAutoScroll, 0L, (long)this.fAutoScrollPeriod);
                } else {
                    this.fAutoScroll.deltaX = sx;
                    this.fAutoScroll.deltaY = sy;
                }
            } else {
                if (this.fAutoScroll != null) {
                    this.fAutoScroll.cancel();
                    this.fAutoScroll = null;
                }
                this.scrollBy(-(event.x - this.fMouseDownX), -(event.y - this.fMousDownY));
            }
        }
    }

    protected void contentsMouseUpEvent(MouseEvent event) {
        if (this.fAutoScroll != null) {
            this.fAutoScroll.cancel();
            this.fAutoScroll = null;
        }
    }

    protected void drawContents(GC gc, int clipx, int clipy, int clipw, int cliph) {
    }

    public void resizeContents(int width, int height) {
        int localWidth = width;
        int localHeight = height;
        if (localWidth < 0) {
            localWidth = 0;
        }
        if (localHeight < 0) {
            localHeight = 0;
        }
        int oldW = this.fContentsWidth;
        int oldH = this.fContentsHeight;
        if (localWidth == oldW && localHeight == oldH) {
            return;
        }
        this.fContentsWidth = localWidth;
        this.fContentsHeight = localHeight;
        if (oldW > localWidth) {
            int s = localWidth;
            localWidth = oldW;
            oldW = s;
        }
        int visWidth = this.getVisibleWidth();
        int visHeight = this.getVisibleHeight();
        if (oldW < visWidth) {
            if (localWidth > visWidth) {
                localWidth = visWidth;
            }
            this.fViewControl.redraw(this.getContentsX() + oldW, 0, localWidth - oldW, visHeight, true);
        }
        if (oldH > localHeight) {
            int s = localHeight;
            localHeight = oldH;
            oldH = s;
        }
        if (oldH < visHeight) {
            if (localHeight > visHeight) {
                localHeight = visHeight;
            }
            this.fViewControl.redraw(0, this.getContentsY() + oldH, visWidth, localHeight - oldH, true);
        }
        if (this.updateScrollBarVisiblity()) {
            this.layout();
        } else {
            this.updateScrollBarsValues();
        }
    }

    public void redraw() {
        super.redraw();
        this.fViewControl.redraw();
    }

    public void scrollBy(int delataX, int deltaY) {
        this.setContentsPos(this.getContentsX() + delataX, this.getContentsY() + deltaY);
    }

    public void ensureVisible(int px, int py) {
        int cx = this.getContentsX();
        int cy = this.getContentsY();
        int right = this.getContentsX() + this.getVisibleWidth();
        int bottom = this.getContentsY() + this.getVisibleHeight();
        if (px < this.getContentsX()) {
            cx = px;
        } else if (px > right) {
            cx = px - this.getVisibleWidth();
        }
        if (py < this.getContentsY()) {
            cy = py;
        } else if (py > bottom) {
            cy = py - this.getVisibleHeight();
        }
        this.setContentsPos(cx, cy);
    }

    public void ensureVisible(int xValue, int yValue, int width, int height, int align) {
        this.ensureVisible(xValue, yValue, width, height, align, false);
    }

    protected void ensureVisible(int xValue, int yValue, int width, int height, int align, boolean forceAlign) {
        int localX = xValue;
        int localY = yValue;
        int localWidth = width;
        int localHeight = height;
        if (localWidth < 0) {
            localX += localWidth;
            localWidth = -localWidth;
        }
        if (localHeight < 0) {
            localY += localHeight;
            localHeight = -localHeight;
        }
        int hbar = this.getHorizontalBarHeight();
        int vbar = this.getVerticalBarWidth();
        int cx = this.getContentsX();
        int cy = this.getContentsY();
        int right = this.getContentsX() + this.getVisibleWidth() - vbar;
        int bottom = this.getContentsY() + this.getVisibleHeight() - hbar;
        boolean alignH = false;
        boolean alignV = false;
        if (localX < this.getContentsX()) {
            cx = localX;
        } else if (localX + localWidth > right) {
            cx = localX - localWidth;
        }
        if (localY < this.getContentsY()) {
            cy = localY;
        } else if (localY + localHeight > bottom) {
            cy = localY - localHeight;
        }
        if (localWidth > this.getVisibleWidth()) {
            alignH = true;
        }
        if (localHeight > this.getVisibleHeight()) {
            alignV = true;
        }
        if (alignH || forceAlign && localX + localWidth > right) {
            cx = (align & 0x4000) != 0 ? localX : ((align & 0x20000) != 0 ? right - localWidth : localX + (localWidth - this.getVisibleWidth()) / 2);
        }
        if (alignV || forceAlign && localY + localHeight > bottom) {
            cy = (align & 0x80) != 0 ? localY : ((align & 0x400) != 0 ? bottom - localHeight : localY + (localHeight - this.getVisibleHeight()) / 2);
        }
        this.setContentsPos(cx, cy);
    }

    public boolean isVisible(int px, int py) {
        if (px < this.getContentsX()) {
            return false;
        }
        if (py < this.getContentsY()) {
            return false;
        }
        if (px > this.getContentsX() + this.getVisibleWidth()) {
            return false;
        }
        return py <= this.getContentsY() + this.getVisibleHeight();
    }

    public boolean isVisible(int xValue, int yValue, int width, int height) {
        if (xValue + width < this.getContentsX()) {
            return false;
        }
        if (yValue + height < this.getContentsY()) {
            return false;
        }
        int vr = this.getContentsX() + this.getVisibleWidth();
        int vb = this.getContentsY() + this.getVisibleHeight();
        if (xValue > vr) {
            return false;
        }
        return yValue <= vb;
    }

    public Rectangle getVisiblePart(int xValue, int yValue, int width, int height) {
        if (xValue + width < this.getContentsX()) {
            return null;
        }
        if (yValue + height < this.getContentsY()) {
            return null;
        }
        int vr = this.getContentsX() + this.getVisibleWidth();
        int vb = this.getContentsY() + this.getVisibleHeight();
        if (xValue > vr) {
            return null;
        }
        if (yValue > vb) {
            return null;
        }
        int rr = xValue + width;
        int rb = yValue + height;
        int nl = Math.max(xValue, this.getContentsX());
        int nt = Math.max(yValue, this.getContentsY());
        int nr = Math.min(rr, vr);
        int nb = Math.min(rb, vb);
        return new Rectangle(nl, nt, nr - nl, nb - nt);
    }

    public final Rectangle getVisiblePart(Rectangle rect) {
        if (rect == null) {
            return null;
        }
        return this.getVisiblePart(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean setContentsPos(int xValue, int yValue) {
        int nx = xValue;
        int ny = yValue;
        if (this.getVisibleWidth() >= this.getContentsWidth()) {
            nx = 0;
        } else if (xValue < 0) {
            nx = 0;
        } else if (xValue + this.getVisibleWidth() > this.getContentsWidth()) {
            nx = this.getContentsWidth() - this.getVisibleWidth();
        }
        if (this.getVisibleHeight() >= this.getContentsHeight()) {
            ny = 0;
        } else if (yValue <= 0) {
            ny = 0;
        } else if (yValue + this.getVisibleHeight() > this.getContentsHeight()) {
            ny = this.getContentsHeight() - this.getVisibleHeight();
        }
        if (nx == this.fContentsX && ny == this.fContentsY) {
            return false;
        }
        this.fContentsX = nx;
        this.fContentsY = ny;
        this.updateScrollBarsValues();
        this.fViewControl.redraw();
        return true;
    }

    public ScrollBar getVerticalBar() {
        return this.fVertScrollBar.getVerticalBar();
    }

    public ScrollBar getHorizontalBar() {
        return this.fHorScrollBar.getHorizontalBar();
    }

    public int computeBarVisibility(int forWidth, int forHeight, boolean currHorVis, boolean currVertvis) {
        int localForWidth = forWidth;
        int vis = 0;
        switch (this.fVertScrollbarMode) {
            case 2: {
                break;
            }
            case 1: {
                vis |= 1;
                break;
            }
            case 0: {
                if (this.getContentsHeight() <= forHeight) break;
                vis = 1;
                if (currVertvis) break;
                localForWidth -= this.getVerticalBarWidth();
                break;
            }
        }
        switch (this.fHorScrollbarMode) {
            case 2: {
                break;
            }
            case 1: {
                vis |= 2;
                break;
            }
            case 0: {
                if (this.getContentsWidth() <= localForWidth) break;
                vis |= 2;
                if (currHorVis || this.getContentsHeight() <= forHeight - this.getHorizontalBarHeight()) break;
                vis |= 1;
                break;
            }
        }
        return vis;
    }

    protected boolean updateScrollBarVisiblity() {
        boolean newHorVis;
        boolean change = false;
        boolean currVertVis = this.fVertScrollBar.getVisible();
        boolean currHorVis = this.fHorScrollBar.getVisible();
        int barNewVis = this.computeBarVisibility(this.getVisibleWidth(), this.getVisibleHeight(), currHorVis, currVertVis);
        boolean newVertVis = (barNewVis & 1) != 0;
        boolean bl = newHorVis = (barNewVis & 2) != 0;
        if (currVertVis ^ newVertVis) {
            this.fVertScrollBar.setVisible(newVertVis);
            change = true;
        }
        if (currHorVis ^ newHorVis) {
            this.fHorScrollBar.setVisible(newHorVis);
            change = true;
        }
        if (this.fCornerControl != null && change) {
            boolean vis;
            boolean bl2 = vis = newVertVis || newHorVis;
            if (vis ^ this.fCornerControl.getVisible()) {
                this.fCornerControl.setVisible(vis);
                change = true;
            }
        }
        return change;
    }

    protected void updateScrollBarsValues() {
        ScrollBar b = this.getVerticalBar();
        if (b != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsHeight());
            b.setThumb(this.getVisibleHeight());
            b.setPageIncrement(this.getVisibleHeight());
            b.setIncrement(this.fVertScrollbarIncrement);
            b.setSelection(this.getContentsY());
        }
        if ((b = this.fViewControl.getVerticalBar()) != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsHeight());
            b.setThumb(this.getVisibleHeight());
            b.setPageIncrement(this.getVisibleHeight());
            b.setIncrement(this.fVertScrollbarIncrement);
            b.setSelection(this.getContentsY());
        }
        if ((b = this.getHorizontalBar()) != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsWidth());
            b.setThumb(this.getVisibleWidth());
            b.setSelection(this.getContentsX());
            b.setPageIncrement(this.getVisibleWidth());
            b.setIncrement(this.fHorScrollbarIncrement);
        }
        if ((b = this.fViewControl.getHorizontalBar()) != null) {
            b.setMinimum(0);
            b.setMaximum(this.getContentsWidth());
            b.setThumb(this.getVisibleWidth());
            b.setSelection(this.getContentsX());
            b.setPageIncrement(this.getVisibleWidth());
            b.setIncrement(this.fHorScrollbarIncrement);
        }
    }

    public void setCornerControl(Control control) {
        if (this.fCornerControl != null) {
            this.fCornerControl.dispose();
        }
        this.fCornerControl = control;
        if (this.fCornerControl != null) {
            ScrollBar vb = this.getVerticalBar();
            ScrollBar hb = this.getHorizontalBar();
            boolean vis = vb.getVisible() || hb.getVisible();
            this.fCornerControl.setVisible(vis);
        }
    }

    public final Point viewToContents(int x, int y) {
        return new Point(this.viewToContentsX(x), this.viewToContentsY(y));
    }

    public int viewToContentsX(int x) {
        return this.fContentsX + x;
    }

    public int viewToContentsY(int y) {
        return this.fContentsY + y;
    }

    public final Point contentsToView(int x, int y) {
        return new Point(this.contentsToViewX(x), this.contentsToViewY(y));
    }

    public int contentsToViewX(int x) {
        return x - this.fContentsX;
    }

    public int contentsToViewY(int y) {
        return y - this.fContentsY;
    }

    public int getVisibleHeight() {
        return this.fViewControl.getClientArea().height;
    }

    public int getVisibleWidth() {
        return this.fViewControl.getClientArea().width;
    }

    protected void keyPressedEvent(KeyEvent event) {
        switch (event.keyCode) {
            case 0x1000001: {
                this.scrollBy(0, -this.getVisibleHeight());
                break;
            }
            case 0x1000002: {
                this.scrollBy(0, this.getVisibleHeight());
                break;
            }
            case 0x1000003: {
                this.scrollBy(-this.getVisibleWidth(), 0);
                break;
            }
            case 0x1000004: {
                this.scrollBy(this.getVisibleWidth(), 0);
                break;
            }
        }
    }

    protected void keyReleasedEvent(KeyEvent event) {
    }

    public int getVerticalBarWidth() {
        int bw = this.fVertScrollBar.computeTrim((int)0, (int)0, (int)0, (int)0).width;
        return bw + 1;
    }

    public int getHorizontalBarHeight() {
        int bh = this.fHorScrollBar.computeTrim((int)0, (int)0, (int)0, (int)0).height;
        return bh + 1;
    }

    public Rectangle computeTrim(int x, int y, int w, int h) {
        Rectangle r = new Rectangle(x, y, w, h);
        int barVis = this.computeBarVisibility(w, h, false, false);
        if ((barVis & 1) != 0) {
            r.width += this.getVerticalBarWidth();
        }
        if ((barVis & 2) != 0) {
            r.height += this.getHorizontalBarHeight();
        }
        return r;
    }

    protected static class AutoScroll
    extends TimerTask {
        private int deltaX;
        private int deltaY;
        private ScrollView scrollView;

        public AutoScroll(ScrollView sv, int dx, int dy) {
            this.scrollView = sv;
            this.deltaX = dx;
            this.deltaY = dy;
        }

        @Override
        public void run() {
            Display display = Display.getDefault();
            if (display == null || display.isDisposed()) {
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AutoScroll.this.scrollView.isDisposed()) {
                        AutoScroll.this.scrollView.scrollBy(AutoScroll.this.deltaX, AutoScroll.this.deltaY);
                    }
                }
            });
        }
    }

    protected class Overview {
        private static final int REFRESH_FREQ = 4;
        private float fOverviewFactorX;
        private float fOverviewFactorY;
        private Shell fOverview;
        private int fSaveCursorX;
        private int fSaveCursorY;

        protected Overview() {
        }

        public void useControl(Control control) {
            final Point pos = control.getLocation();
            control.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    Overview.this.overviewAppear(e.x, e.y);
                }

                public void mouseUp(MouseEvent e) {
                    Overview.this.overviewDisappear();
                }
            });
            control.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (Overview.this.overviewing()) {
                        Overview.this.overviewDisappear(false);
                    }
                }
            });
            control.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 32 && !Overview.this.overviewing()) {
                        Overview.this.overviewAppear(pos.x, pos.y);
                    } else if (event.keyCode == 32) {
                        Overview.this.overviewDisappear();
                    }
                    if (event.keyCode == 0x1000002) {
                        Overview.this.overviewMove(0, 1, (TypedEvent)event);
                    }
                    if (event.keyCode == 0x1000001) {
                        Overview.this.overviewMove(0, -1, (TypedEvent)event);
                    }
                    if (event.keyCode == 0x1000004) {
                        Overview.this.overviewMove(1, 0, (TypedEvent)event);
                    }
                    if (event.keyCode == 0x1000003) {
                        Overview.this.overviewMove(-1, 0, (TypedEvent)event);
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            control.addMouseMoveListener(new MouseMoveListener(){
                private int refReshCount = 0;

                public void mouseMove(MouseEvent event) {
                    if (Overview.this.overviewing()) {
                        if (this.refReshCount % 4 == 0) {
                            Overview.this.overviewMove(event);
                        }
                        ++this.refReshCount;
                    }
                }
            });
        }

        public void dispose() {
            if (this.fOverview != null) {
                this.fOverview.dispose();
            }
        }

        protected boolean overviewing() {
            return this.fOverview != null && this.fOverview.isVisible();
        }

        protected void overviewAppear(int mx, int my) {
            int h;
            if (this.fOverview == null) {
                this.fOverview = new Shell(ScrollView.this.getShell(), 278528);
                this.fOverview.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        ScrollView.this.drawOverview(e.gc, Overview.this.fOverview.getClientArea());
                    }
                });
            }
            this.fOverview.setForeground(ScrollView.this.fViewControl.getForeground());
            Point p = this.toGlobalCoordinates(ScrollView.this.fCornerControl, 0, 0);
            int x = p.x;
            int y = p.y;
            int w = h = ScrollView.this.fOverviewSize;
            Rectangle scr = ScrollView.this.getDisplay().getBounds();
            Point ccs = ScrollView.this.fCornerControl.getSize();
            try {
                float ratio;
                if (ScrollView.this.fContentsWidth > ScrollView.this.fContentsHeight) {
                    ratio = (float)ScrollView.this.fContentsHeight / (float)ScrollView.this.fContentsWidth;
                    h = (int)((float)w * ratio);
                    if (h < ccs.y) {
                        h = ccs.y;
                    } else if (h >= scr.height / 2) {
                        h = scr.height / 2;
                    }
                } else {
                    ratio = (float)ScrollView.this.fContentsWidth / (float)ScrollView.this.fContentsHeight;
                    w = (int)((float)h * ratio);
                    if (w < ccs.x) {
                        w = ccs.x;
                    } else if (w >= scr.width / 2) {
                        w = scr.width / 2;
                    }
                }
                this.fOverviewFactorX = (float)ScrollView.this.fContentsWidth / (float)w;
                this.fOverviewFactorY = (float)ScrollView.this.fContentsHeight / (float)h;
            }
            catch (ArithmeticException ratio) {
                // empty catch block
            }
            if (x <= 0) {
                x = 1;
            }
            if (y <= 0) {
                y = 1;
            }
            x = x - w + ccs.x;
            y = y - h + ccs.y;
            this.fOverview.setBounds(x, y, w, h);
            this.fOverview.setVisible(true);
            this.fOverview.redraw();
            if (fOverviewCursor == null) {
                RGB[] rgb = new RGB[]{new RGB(0, 0, 0), new RGB(255, 0, 0)};
                PaletteData palette = new PaletteData(rgb);
                int s = 1;
                byte[] src = new byte[s * s];
                byte[] msk = new byte[s * s];
                int i = 0;
                while (i < s * s) {
                    src[i] = -1;
                    ++i;
                }
                ImageData i_src = new ImageData(s, s, 1, palette, 1, src);
                ImageData i_msk = new ImageData(s, s, 1, palette, 1, msk);
                fOverviewCursor = new Cursor(null, i_src, i_msk, 0, 0);
            }
            ScrollView.this.fCornerControl.setCursor(fOverviewCursor);
            p = this.toGlobalCoordinates(ScrollView.this.fCornerControl, mx, my);
            this.fSaveCursorX = p.x;
            this.fSaveCursorY = p.y;
            Rectangle r = this.fOverview.getClientArea();
            int cx = (int)((float)(r.width * ScrollView.this.fContentsX) / (float)ScrollView.this.fContentsWidth);
            int cy = (int)((float)(r.height * ScrollView.this.fContentsY) / (float)ScrollView.this.fContentsHeight);
            p = this.toGlobalCoordinates((Control)this.fOverview.getParent(), cx, cy);
        }

        protected void overviewDisappear() {
            this.overviewDisappear(true);
        }

        protected void overviewDisappear(boolean restoreCursorLoc) {
            if (this.fOverview == null) {
                return;
            }
            this.fOverview.setVisible(false);
            ScrollView.this.fCornerControl.setCursor(null);
            if (restoreCursorLoc) {
                ScrollView.this.getDisplay().setCursorLocation(this.fSaveCursorX, this.fSaveCursorY);
            }
            this.fOverview.dispose();
            this.fOverview = null;
        }

        protected void overviewMove(MouseEvent event) {
            Point p = this.toGlobalCoordinates(ScrollView.this.fCornerControl, event.x, event.y);
            int dx = p.x - this.fSaveCursorX;
            int dy = p.y - this.fSaveCursorY;
            this.overviewMove(dx, dy, (TypedEvent)event);
        }

        protected void overviewMove(int dx, int dy, TypedEvent event) {
            MouseEvent e;
            boolean ctrl = false;
            boolean shift = false;
            if (event instanceof MouseEvent) {
                e = (MouseEvent)event;
                ScrollView.this.getDisplay().setCursorLocation(this.fSaveCursorX, this.fSaveCursorY);
                ctrl = (e.stateMask & 0x40000) != 0;
                shift = (e.stateMask & 0x20000) != 0;
            } else if (event instanceof KeyEvent) {
                e = (KeyEvent)event;
                ctrl = (e.stateMask & 0x40000) != 0;
                shift = (e.stateMask & 0x20000) != 0;
            }
            int cx = ScrollView.this.fContentsX;
            int cy = ScrollView.this.fContentsY;
            float fx = this.fOverviewFactorX;
            float fy = this.fOverviewFactorY;
            if (ctrl && shift) {
                if (fx * 0.25f > 1.0f && (double)fy * 0.25 > 1.0) {
                    fy = 1.0f;
                    fx = 1.0f;
                } else {
                    fx *= 0.1f;
                    fy *= 0.1f;
                }
            } else if (ctrl) {
                fx *= 0.5f;
                fy *= 0.5f;
            } else if (shift) {
                fx *= 0.5f;
                fy *= 0.5f;
            }
            ScrollView.this.scrollBy((int)(fx * (float)dx), (int)(fy * (float)dy));
            if (cx != ScrollView.this.fContentsX || cy != ScrollView.this.fContentsY) {
                this.fOverview.redraw();
                this.fOverview.update();
            }
        }

        protected Point toGlobalCoordinates(Control loc, int x, int y) {
            Point p = new Point(x, y);
            Control c = loc;
            while (c != null) {
                int trimX = 0;
                int trimY = 0;
                if (c instanceof Scrollable) {
                    Scrollable s = (Scrollable)c;
                    Rectangle rr = s.getClientArea();
                    Rectangle tr = s.computeTrim(rr.x, rr.y, rr.width, rr.height);
                    trimX = rr.x - tr.x;
                    trimY = rr.y - tr.y;
                }
                p.x += c.getLocation().x + trimX;
                p.y += c.getLocation().y + trimY;
                c = c.getParent();
            }
            return p;
        }
    }

    protected class SVLayout
    extends Layout {
        private static final int DEFAULT_X = 250;
        private static final int DEFAULT_Y = 250;
        private static final int MAX_SEEK = 10;
        private static final int MIN_SEEK = 0;
        private int seek = 0;
        private boolean dontLayout = false;

        protected SVLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point p = new Point(250, 250);
            if (ScrollView.this.fContentsWidth < p.x) {
                p.x = ScrollView.this.fContentsWidth;
            }
            if (ScrollView.this.fContentsHeight < p.y) {
                p.y = ScrollView.this.fContentsHeight;
            }
            return p;
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (this.dontLayout) {
                return;
            }
            ++this.seek;
            if (this.seek > 10) {
                this.dontLayout = true;
            }
            Point cs = composite.getSize();
            int barVis = ScrollView.this.computeBarVisibility(cs.x, cs.y, false, false);
            boolean vbVis = (barVis & 1) != 0;
            boolean hbVis = (barVis & 2) != 0;
            ScrollView.this.fVertScrollBar.setVisible(vbVis);
            ScrollView.this.fHorScrollBar.setVisible(hbVis);
            int vbw = ScrollView.this.getVerticalBarWidth();
            int hbh = ScrollView.this.getHorizontalBarHeight();
            int wb = vbVis ? vbw : 0;
            int hb = hbVis ? hbh : 0;
            int cww = 0;
            int cwh = 0;
            if (ScrollView.this.fCornerControl != null && (vbVis || hbVis)) {
                ScrollView.this.fCornerControl.setVisible(true);
                cww = vbw;
                cwh = hbh;
                if (wb == 0) {
                    wb = vbw;
                }
                if (hb == 0) {
                    hb = hbh;
                }
            } else if (vbVis && hbVis) {
                if (ScrollView.this.fCornerControl != null) {
                    ScrollView.this.fCornerControl.setVisible(false);
                }
                cww = vbw;
                cwh = hbh;
            }
            if (vbVis || hbVis) {
                ScrollView.this.updateScrollBarsValues();
            }
            int vw = cs.x - (vbVis ? vbw : 0);
            int vh = cs.y - (hbVis ? hbh : 0);
            int vbx = cs.x - wb;
            int hby = cs.y - hb;
            ScrollView.this.fViewControl.setBounds(0, 0, vw, vh);
            if (vbVis) {
                ScrollView.this.fVertScrollBar.setBounds(vbx, 0, wb, cs.y - cwh);
            }
            if (hbVis) {
                ScrollView.this.fHorScrollBar.setBounds(0, hby, cs.x - cww, hb);
            }
            if (ScrollView.this.fCornerControl != null && ScrollView.this.fCornerControl.getVisible()) {
                ScrollView.this.fCornerControl.setBounds(vbx, hby, vbw, hbh);
            }
            ScrollView.this.updateScrollBarsValues();
            --this.seek;
            if (this.seek == 0) {
                this.dontLayout = false;
            }
        }

        boolean isDontLayout() {
            return this.dontLayout;
        }

        void setSontLayout(boolean dontLayout) {
            this.dontLayout = dontLayout;
        }
    }
}

