/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.cdt.ui.properties;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.ems.core.EnvManagerConfigString;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.ems.ui.EnvManagerConfigWidget;
import org.eclipse.ptp.ems.ui.IErrorListener;
import org.eclipse.ptp.internal.rdt.sync.cdt.core.Activator;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.wizards.AddSyncConfigWizardPage;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.ui.AbstractSynchronizeProperties;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizePropertiesDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SynchronizeProperties
extends AbstractSynchronizeProperties {
    private Group fUserDefinedContent;
    private Combo fConfigCombo;
    private SyncConfig fSyncConfig;
    private IEnvManagerConfig fEnvConfig;
    private AddSyncConfigWizardPage fWizardPage;
    private EnvManagerConfigWidget fEnvWidget;
    private final Map<String, String> fBuildConfigNameToIdMap = new HashMap<String, String>();
    private final Map<SyncConfig, String> fDirtyBuildConfigs = new HashMap<SyncConfig, String>();
    private final Map<SyncConfig, IEnvManagerConfig> fDirtyEnvConfigs = new HashMap<SyncConfig, IEnvManagerConfig>();

    public SynchronizeProperties(ISynchronizePropertiesDescriptor descriptor) {
        super(descriptor);
    }

    public void addConfiguration(SyncConfig config) {
        String buildConfigName = this.fWizardPage.getBuildConfiguration();
        if (buildConfigName != null) {
            this.fDirtyBuildConfigs.put(config, this.fWizardPage.getBuildConfiguration());
        }
    }

    private void cacheConfig() {
        String defaultConfigName;
        String selectedConfigName = null;
        int index = this.fConfigCombo.getSelectionIndex();
        if (index >= 0) {
            selectedConfigName = this.fConfigCombo.getItem(index);
        }
        if ((defaultConfigName = this.getDefaultBuildConfig(this.fSyncConfig)) == null || !defaultConfigName.equals(selectedConfigName)) {
            this.fDirtyBuildConfigs.put(this.fSyncConfig, selectedConfigName);
        } else {
            this.fDirtyBuildConfigs.remove(this.fSyncConfig);
        }
        this.fEnvWidget.saveConfiguration(this.fEnvConfig);
        this.fDirtyEnvConfigs.put(this.fSyncConfig, this.fEnvConfig);
    }

    private List<String> computeSelectedItems() {
        try {
            IEnvManagerConfig config = this.getEnvConfig();
            if (config.getConnectionName().equals(this.fEnvWidget.getConnectionName())) {
                return config.getConfigElements();
            }
            return null;
        }
        catch (Error error) {
            return null;
        }
    }

    public WizardPage[] createAddWizardPages(IProject project) {
        this.fWizardPage = new AddSyncConfigWizardPage(project);
        return new WizardPage[]{this.fWizardPage};
    }

    public void createPropertiesConfigurationArea(Composite parent, SyncConfig config) {
        this.fSyncConfig = config;
        this.fUserDefinedContent = new Group(parent, 0);
        this.fUserDefinedContent.setText(Messages.SynchronizeProperties_Title);
        this.fUserDefinedContent.setLayout((Layout)new GridLayout(2, false));
        this.fUserDefinedContent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label label = new Label((Composite)this.fUserDefinedContent, 0);
        label.setText(Messages.SynchronizeProperties_Default_configuration);
        this.fConfigCombo = new Combo((Composite)this.fUserDefinedContent, 8);
        this.readBuildConfigData(config.getProject());
        this.fConfigCombo.setItems(this.fBuildConfigNameToIdMap.keySet().toArray(new String[0]));
        this.fConfigCombo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fEnvWidget = new EnvManagerConfigWidget((Composite)this.fUserDefinedContent, 0);
        this.fEnvWidget.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.fEnvWidget.setErrorListener(new IErrorListener(){

            public void errorCleared() {
            }

            public void errorRaised(String message) {
            }
        });
        String initialBuildConfig = this.fDirtyBuildConfigs.containsKey(config) ? this.fDirtyBuildConfigs.get(config) : this.getDefaultBuildConfig(config);
        this.selectBuildConfiguration(initialBuildConfig);
        if (this.fDirtyEnvConfigs.containsKey(config)) {
            this.fEnvConfig = this.fDirtyEnvConfigs.get(config);
        }
        this.setEnvConfig();
    }

    public void disposePropertiesConfigurationArea() {
        if (this.fUserDefinedContent != null) {
            if (!this.fUserDefinedContent.isDisposed()) {
                this.cacheConfig();
                this.fUserDefinedContent.dispose();
            }
            this.fUserDefinedContent = null;
            this.fEnvConfig = null;
        }
    }

    private String getDefaultBuildConfig(SyncConfig syncConfig) {
        IManagedBuildInfo buildInfo;
        IConfiguration buildConfig;
        String buildConfigId = syncConfig.getProperty("default-build-config-id");
        if (buildConfigId != null && (buildConfig = (buildInfo = ManagedBuildManager.getBuildInfo((IResource)syncConfig.getProject())).getManagedProject().getConfiguration(buildConfigId)) != null) {
            return buildConfig.getName();
        }
        return null;
    }

    private IEnvManagerConfig getEnvConfig() {
        try {
            if (this.fEnvConfig == null) {
                this.fEnvConfig = new EnvManagerConfigString(this.fSyncConfig.getProperty("ems-configuration"));
            }
            return this.fEnvConfig;
        }
        catch (Error e) {
            Activator.log((Throwable)e);
            throw e;
        }
    }

    private String getManualConfigText() {
        try {
            return this.getEnvConfig().getManualConfigText();
        }
        catch (Error error) {
            return "";
        }
    }

    private URI getSyncURI() {
        try {
            return SyncConfigManager.getActiveSyncLocationURI((IResource)this.fSyncConfig.getProject());
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return null;
        }
    }

    private boolean isEnvConfigSupportEnabled() {
        try {
            return this.getEnvConfig().isEnvMgmtEnabled();
        }
        catch (Error error) {
            return false;
        }
    }

    private boolean isManualConfigEnabled() {
        try {
            return this.getEnvConfig().isManualConfigEnabled();
        }
        catch (Error error) {
            return false;
        }
    }

    public void performApply() {
        if (this.fUserDefinedContent != null && !this.fUserDefinedContent.isDisposed()) {
            this.cacheConfig();
        }
        HashSet<IProject> projectsToUpdate = new HashSet<IProject>();
        for (Map.Entry<SyncConfig, String> entry : this.fDirtyBuildConfigs.entrySet()) {
            String configId = this.fBuildConfigNameToIdMap.get(entry.getValue());
            entry.getKey().setProperty("default-build-config-id", configId);
            projectsToUpdate.add(entry.getKey().getProject());
        }
        for (Map.Entry<SyncConfig, String> entry : this.fDirtyEnvConfigs.entrySet()) {
            entry.getKey().setProperty("ems-configuration", ((IEnvManagerConfig)entry.getValue()).toString());
            projectsToUpdate.add(entry.getKey().getProject());
        }
        for (IProject iProject : projectsToUpdate) {
            try {
                SyncConfigManager.saveConfigs((IProject)iProject);
            }
            catch (CoreException e) {
                Activator.log((Throwable)e);
            }
        }
        this.fDirtyBuildConfigs.clear();
    }

    public void performCancel() {
        this.fDirtyBuildConfigs.clear();
        this.fDirtyEnvConfigs.clear();
    }

    public void performDefaults() {
        if (this.fUserDefinedContent != null) {
            String buildConfigName = this.getDefaultBuildConfig(this.fSyncConfig);
            this.selectBuildConfiguration(buildConfigName);
            this.fEnvConfig = null;
            this.setEnvConfig();
        }
        this.fDirtyBuildConfigs.clear();
        this.fDirtyEnvConfigs.clear();
    }

    private void readBuildConfigData(IProject project) {
        IConfiguration[] allBuildConfigs;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            throw new RuntimeException(String.valueOf(Messages.SynchronizeProperties_0) + project.getName());
        }
        IConfiguration[] iConfigurationArray = allBuildConfigs = buildInfo.getManagedProject().getConfigurations();
        int n = allBuildConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            this.fBuildConfigNameToIdMap.put(config.getName(), config.getId());
            ++n2;
        }
    }

    private void selectBuildConfiguration(String configName) {
        if (configName == null) {
            this.fConfigCombo.deselectAll();
            return;
        }
        int i = 0;
        while (i < this.fConfigCombo.getItemCount()) {
            if (this.fConfigCombo.getItem(i).equals(configName)) {
                this.fConfigCombo.select(i);
                return;
            }
            ++i;
        }
        this.fConfigCombo.deselectAll();
    }

    private void setEnvConfig() {
        try {
            this.fEnvWidget.setConnection(this.fSyncConfig.getRemoteConnection());
            this.fEnvWidget.setUseEMSCheckbox(this.isEnvConfigSupportEnabled());
            this.fEnvWidget.setManualConfigCheckbox(this.isManualConfigEnabled());
            this.fEnvWidget.setManualConfigText(this.getManualConfigText());
            this.fEnvWidget.configurationChanged(this.getSyncURI(), this.fSyncConfig.getRemoteConnection(), this.computeSelectedItems());
        }
        catch (MissingConnectionException e) {
            Activator.log((Throwable)e);
        }
    }
}

