/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.DeleteBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.egit.ui.internal.dialogs.UnmergedBranchDialog;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class DeleteBranchOnCommitHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<Ref> branchesToDelete;
        List<Ref> branchesOfCommit;
        int totalBranchCount;
        GitHistoryPage page = this.getPage();
        final Repository repository = this.getRepository(page);
        if (repository == null) {
            return null;
        }
        try {
            totalBranchCount = this.getBranchesOfCommit(page, repository, false).size();
            branchesOfCommit = this.getBranchesOfCommit(page, repository, true);
        }
        catch (IOException e) {
            throw new ExecutionException("Could not obtain current Branch", (Throwable)e);
        }
        if (branchesOfCommit.isEmpty()) {
            return null;
        }
        final ArrayList unmergedBranches = new ArrayList();
        final Shell shell = this.getPart(event).getSite().getShell();
        if (totalBranchCount > 1) {
            BranchSelectionDialog<Ref> dlg = new BranchSelectionDialog<Ref>(shell, branchesOfCommit, UIText.DeleteBranchOnCommitHandler_SelectBranchDialogTitle, UIText.DeleteBranchOnCommitHandler_SelectBranchDialogMessage, 2);
            if (dlg.open() != 0) {
                return null;
            }
            branchesToDelete = dlg.getSelectedNodes();
        } else {
            branchesToDelete = branchesOfCommit;
        }
        try {
            new ProgressMonitorDialog(shell).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            UnmergedBranchDialog messageDialog;
                            monitor.beginTask(UIText.DeleteBranchCommand_DeletingBranchesProgress, branchesToDelete.size());
                            for (Ref refNode : branchesToDelete) {
                                int result = DeleteBranchOnCommitHandler.this.deleteBranch(repository, refNode, false);
                                if (result == 1) {
                                    throw new CoreException(Activator.createErrorStatus(UIText.DeleteBranchCommand_CannotDeleteCheckedOutBranch, null));
                                }
                                if (result == 2) {
                                    unmergedBranches.add(refNode);
                                    continue;
                                }
                                monitor.worked(1);
                            }
                            if (!unmergedBranches.isEmpty() && (messageDialog = new UnmergedBranchDialog(shell, unmergedBranches)).open() == 0) {
                                for (Ref node : unmergedBranches) {
                                    DeleteBranchOnCommitHandler.this.deleteBranch(repository, node, true);
                                    monitor.worked(1);
                                }
                            }
                        }
                        catch (CoreException ex) {
                            throw new InvocationTargetException(ex);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            Activator.handleError(UIText.RepositoriesView_BranchDeletionFailureMessage, e1.getCause(), true);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    private int deleteBranch(Repository repo, Ref ref, boolean force) throws CoreException {
        DeleteBranchOperation dbop = new DeleteBranchOperation(repo, ref, force);
        dbop.execute(null);
        return dbop.getStatus();
    }

    public boolean isEnabled() {
        List<Ref> branchesOfCommit;
        GitHistoryPage page = this.getPage();
        Repository repository = this.getRepository(page);
        if (repository == null) {
            return false;
        }
        try {
            branchesOfCommit = this.getBranchesOfCommit(page, repository, true);
        }
        catch (IOException e) {
            Activator.logError("Could not calculate Enablement", e);
            return false;
        }
        return !branchesOfCommit.isEmpty();
    }
}

