/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import org.eclipse.ptp.internal.rdt.core.miners.RemoteLogService;

public class StandaloneLogService
extends RemoteLogService {
    private PrintStream log_ps;
    private boolean fIsTracing = true;
    private boolean fIsTracingExceptions = true;
    private static final String TRACE_LINE_BREAK = "---------------------------------------------------------------";
    private static final String ERROR_LINE_BREAK = "===============================================================";
    private static final StandaloneLogService instance = new StandaloneLogService();

    protected StandaloneLogService() {
        super(null, null);
    }

    public static StandaloneLogService getInstance() {
        return instance;
    }

    public void setLogFileName(String logFileName) {
        if (logFileName != null && logFileName.length() > 0) {
            try {
                File logFile = new File(logFileName);
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                FileOutputStream log_out = new FileOutputStream(logFileName);
                if (this.log_ps != null) {
                    this.log_ps.close();
                }
                this.log_ps = new PrintStream(log_out);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
    }

    public void setTracing(boolean isTracing) {
        this.fIsTracing = isTracing;
    }

    public void setTracingExceptions(boolean isTracingExceptions) {
        this.fIsTracingExceptions = isTracingExceptions;
    }

    public void saveLog() {
        if (this.log_ps != null) {
            this.log_ps.flush();
            this.log_ps.close();
            this.log_ps = null;
        }
    }

    @Override
    public void traceLog(String message) {
        if (this.isTracing()) {
            String logMessage;
            PrintStream local_ps = System.out;
            if (this.log_ps != null) {
                local_ps = this.log_ps;
            }
            if ((logMessage = this.getTraceMessage(message)) != null && logMessage.length() > 0) {
                Date date = new Date();
                local_ps.println(date.toString());
                local_ps.println(logMessage);
                local_ps.println(TRACE_LINE_BREAK);
            }
        }
    }

    @Override
    public void errorLog(String message) {
        if (this.isTracingExceptions()) {
            PrintStream local_ps = System.out;
            if (this.log_ps != null) {
                local_ps = this.log_ps;
            }
            if (message != null && message.length() > 0) {
                Date date = new Date();
                local_ps.println(date.toString());
                local_ps.println(this.getErrorMessage(message));
                local_ps.println(ERROR_LINE_BREAK);
            }
        }
    }

    public static String getStackTrace(Throwable e) {
        StringWriter strW = new StringWriter();
        PrintWriter printW = new PrintWriter((Writer)strW, true);
        e.printStackTrace(printW);
        printW.flush();
        strW.flush();
        return strW.toString();
    }

    public void errorLog(String message, Throwable e) {
        if (this.isTracingExceptions()) {
            PrintStream local_ps = System.out;
            if (this.log_ps != null) {
                local_ps = this.log_ps;
            }
            if (message != null && message.length() > 0) {
                Date date = new Date();
                local_ps.println(date.toString());
                local_ps.println(this.getErrorMessage(message));
            }
            if (e != null) {
                local_ps.println(this.getErrorMessage(StandaloneLogService.getStackTrace(e)));
            }
            local_ps.println(ERROR_LINE_BREAK);
        }
    }

    @Override
    public boolean isTracing() {
        return this.fIsTracing;
    }

    @Override
    public boolean isTracingExceptions() {
        return this.fIsTracingExceptions;
    }
}

