/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.lsf.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.rm.ibm.lsf.ui.LSFCommand;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.Messages;

public class LSFQueuesCommand
extends LSFCommand {
    private boolean isInteractiveSession;

    public LSFQueuesCommand(String name, IRemoteConnection connection, String[] cmd, boolean isInteractive) {
        super(name, connection, cmd);
        this.isInteractiveSession = isInteractive;
    }

    @Override
    protected IStatus getCommandOutput(IProgressMonitor monitor) {
        try {
            String[] columnData;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            this.commandResponse.clear();
            boolean headerProcessed = false;
            boolean headerNext = false;
            boolean queueDataNext = false;
            boolean batchQueueAllowed = true;
            boolean interactiveQueueAllowed = true;
            String queueName = "";
            String queueData = null;
            String data = reader.readLine();
            while (data != null) {
                if (data.startsWith("QUEUE:")) {
                    if (queueData != null && (this.isInteractiveSession && interactiveQueueAllowed || !this.isInteractiveSession && batchQueueAllowed)) {
                        queueData = queueData.replaceAll(" +/ +", "/");
                        columnData = queueData.split(" +");
                        this.commandResponse.add(columnData);
                    }
                    queueName = data.substring(7).trim();
                    headerNext = false;
                    queueDataNext = false;
                    batchQueueAllowed = true;
                    interactiveQueueAllowed = true;
                } else if (data.equals("PARAMETERS/STATISTICS")) {
                    headerNext = true;
                } else if (headerNext) {
                    if (!headerProcessed) {
                        data = "QUEUE_NAME " + data;
                        this.columnLabels = data.split(" +");
                    }
                    headerNext = false;
                    headerProcessed = true;
                    queueDataNext = true;
                } else if (queueDataNext) {
                    queueData = String.valueOf(queueName) + " " + data;
                    queueDataNext = false;
                } else if (data.startsWith("SCHEDULING POLICIES:")) {
                    if (data.contains("NO_INTERACTIVE")) {
                        interactiveQueueAllowed = false;
                    } else if (data.contains("ONLY_INTERACTIVE")) {
                        batchQueueAllowed = false;
                    }
                }
                data = reader.readLine();
                if (!monitor.isCanceled()) continue;
                reader.close();
                return new Status(8, "org.eclipse.ptp.rm.ibm.lsf.ui", 2, Messages.CommandCancelMessage, null);
            }
            if (queueData != null && (this.isInteractiveSession && interactiveQueueAllowed || !this.isInteractiveSession && batchQueueAllowed)) {
                queueData = queueData.replaceAll(" +/ +", "/");
                columnData = queueData.split(" +");
                this.commandResponse.add(columnData);
            }
            reader.close();
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.ptp.rm.ibm.lsf.ui", 3, "Error reading command output", (Throwable)e);
        }
        return new Status(0, "org.eclipse.ptp.rm.ibm.lsf.ui", 0, Messages.OkMessage, null);
    }
}

