/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.model.IEnableDisableTarget;
import org.eclipse.ptp.debug.core.model.IPPersistableRegisterGroup;
import org.eclipse.ptp.debug.core.model.IPRegisterDescriptor;
import org.eclipse.ptp.internal.debug.core.PRegisterManager;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.messages.Messages;
import org.eclipse.ptp.internal.debug.core.model.PDebugElement;
import org.eclipse.ptp.internal.debug.core.model.PRegister;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PRegisterGroup
extends PDebugElement
implements IPPersistableRegisterGroup,
IEnableDisableTarget {
    private static final String ATTR_REGISTER_GROUP_ENABLED = "enabled";
    private static final String ATTR_REGISTER_GROUP_NAME = "name";
    private static final String ATTR_REGISTER_NAME = "name";
    private static final String ATTR_REGISTER_ORIGINAL_GROUP_NAME = "originalGroupName";
    private static final String ELEMENT_REGISTER = "register";
    private static final String ELEMENT_REGISTER_GROUP = "registerGroup";
    private boolean fDisposed = false;
    private boolean fIsEnabled = true;
    private String fName;
    private IPRegisterDescriptor[] fRegisterDescriptors;
    private IRegister[] fRegisters;

    public PRegisterGroup(IPSession session, TaskSet tasks) {
        this(session, tasks, null, null);
    }

    public PRegisterGroup(IPSession session, TaskSet tasks, String name, IPRegisterDescriptor[] descriptors) {
        super(session, tasks);
        this.fName = name;
        this.fRegisterDescriptors = descriptors;
    }

    public boolean canEnableDisable() {
        return true;
    }

    public void dispose() {
        this.fDisposed = true;
        this.invalidate();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IEnableDisableTarget.class)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String getMemento() throws CoreException {
        Document document = DebugPlugin.newDocument();
        Element element = document.createElement(ELEMENT_REGISTER_GROUP);
        element.setAttribute("name", this.getName());
        element.setAttribute(ATTR_REGISTER_GROUP_ENABLED, Boolean.valueOf(this.isEnabled()).toString());
        int i = 0;
        while (i < this.fRegisterDescriptors.length) {
            Element child = document.createElement(ELEMENT_REGISTER);
            child.setAttribute("name", this.fRegisterDescriptors[i].getName());
            child.setAttribute(ATTR_REGISTER_ORIGINAL_GROUP_NAME, this.fRegisterDescriptors[i].getGroupName());
            element.appendChild(child);
            ++i;
        }
        document.appendChild(element);
        return DebugPlugin.serializeDocument((Document)document);
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public IPRegisterDescriptor[] getRegisterDescriptors() {
        return this.fRegisterDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegister[] getRegisters() throws DebugException {
        if (this.fDisposed) {
            return new IRegister[0];
        }
        if (this.fRegisters == null) {
            PRegisterGroup pRegisterGroup = this;
            synchronized (pRegisterGroup) {
                if (this.fRegisters == null) {
                    this.fRegisters = new IRegister[this.fRegisterDescriptors.length];
                    int i = 0;
                    while (i < this.fRegisters.length) {
                        this.fRegisters[i] = new PRegister(this, this.fRegisterDescriptors[i]);
                        ++i;
                    }
                }
            }
        }
        return this.fRegisters;
    }

    public boolean hasRegisters() throws DebugException {
        return this.fRegisterDescriptors.length > 0;
    }

    public void initializeFromMemento(String memento) throws CoreException {
        String groupName;
        Element element;
        Element node = DebugPlugin.parseDocument((String)memento);
        if (node.getNodeType() != 1) {
            this.abort(Messages.PRegisterGroup_0, null);
        }
        if (!ELEMENT_REGISTER_GROUP.equals((element = node).getNodeName())) {
            this.abort(Messages.PRegisterGroup_1, null);
        }
        if ((groupName = element.getAttribute("name")) == null || groupName.length() == 0) {
            this.abort(Messages.PRegisterGroup_2, null);
        }
        String e = element.getAttribute(ATTR_REGISTER_GROUP_ENABLED);
        boolean enabled = Boolean.valueOf(e);
        PRegisterManager rm = this.getRegisterManager();
        ArrayList<IPRegisterDescriptor> list = new ArrayList<IPRegisterDescriptor>();
        Node childNode = element.getFirstChild();
        while (childNode != null) {
            Element child;
            if (childNode.getNodeType() == 1 && ELEMENT_REGISTER.equals((child = (Element)childNode).getNodeName())) {
                String name = child.getAttribute("name");
                String originalGroupName = child.getAttribute(ATTR_REGISTER_ORIGINAL_GROUP_NAME);
                if (name == null || name.length() == 0 || originalGroupName == null || originalGroupName.length() == 0) {
                    this.abort(Messages.PRegisterGroup_3, null);
                } else {
                    IPRegisterDescriptor d = rm.findDescriptor(this.getTasks(), originalGroupName, name);
                    if (d != null) {
                        list.add(d);
                    } else {
                        PTPDebugCorePlugin.log(Messages.PRegisterGroup_4);
                    }
                }
            }
            childNode = childNode.getNextSibling();
        }
        this.setName(groupName);
        this.fRegisterDescriptors = list.toArray(new IPRegisterDescriptor[list.size()]);
        this.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void resetRegisterValues() {
        if (this.fRegisters == null) {
            return;
        }
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null) {
                ((PRegister)this.fRegisters[i]).invalidateValue();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setEnabled(boolean enabled) throws DebugException {
        if (this.fRegisters != null) {
            IRegister[] iRegisterArray = this.fRegisters;
            // MONITORENTER : this.fRegisters
            if (this.fRegisters != null) {
                int i = 0;
                while (i < this.fRegisters.length) {
                    if (this.fRegisters[i] instanceof PRegister) {
                        ((PRegister)this.fRegisters[i]).setEnabled(enabled);
                    }
                    ++i;
                }
            }
            // MONITOREXIT : iRegisterArray
        }
        this.fIsEnabled = enabled;
        this.fireChangeEvent(512);
    }

    public void setRegisterDescriptors(IPRegisterDescriptor[] registerDescriptors) {
        this.invalidate();
        this.fRegisterDescriptors = registerDescriptors;
    }

    public void targetSuspended() {
        if (this.fRegisters == null) {
            return;
        }
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null && ((PRegister)this.fRegisters[i]).hasErrors()) {
                ((PRegister)this.fRegisters[i]).resetStatus();
            }
            ++i;
        }
    }

    private void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, message, exception);
        throw new CoreException((IStatus)status);
    }

    private PRegisterManager getRegisterManager() {
        return (PRegisterManager)this.getSession().getAdapter(PRegisterManager.class);
    }

    private void invalidate() {
        if (this.fRegisters == null) {
            return;
        }
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null) {
                ((PRegister)this.fRegisters[i]).dispose();
            }
            ++i;
        }
        this.fRegisters = null;
    }

    private void setName(String name) {
        this.fName = name;
    }
}

