/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.managedbuilder.xlc.ui.environment;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.envvar.IProjectEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ProjectNotConfiguredException;
import org.eclipse.ptp.services.core.ServiceModelManager;

public class RemoteProjectEnvironmentSupplier
implements IProjectEnvironmentVariableSupplier {
    public IBuildEnvironmentVariable getVariable(String variableName, IManagedProject project, IEnvironmentVariableProvider provider) {
        Map<String, String> envMap = this.getRemoteEnvironment(project);
        if (envMap != null) {
            String value = envMap.get(variableName) == null ? new String() : envMap.get(variableName);
            BuildEnvVar envVar = new BuildEnvVar(variableName, value);
            return envVar;
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IManagedProject project, IEnvironmentVariableProvider provider) {
        LinkedList<BuildEnvVar> vars = new LinkedList<BuildEnvVar>();
        Map<String, String> remoteEnvMap = null;
        remoteEnvMap = this.getRemoteEnvironment(project);
        if (remoteEnvMap != null) {
            for (String var : remoteEnvMap.keySet()) {
                String value = remoteEnvMap.get(var);
                BuildEnvVar buildEnvVar = new BuildEnvVar(var, value);
                vars.add(buildEnvVar);
            }
            return vars.toArray(new IBuildEnvironmentVariable[0]);
        }
        return new IBuildEnvironmentVariable[0];
    }

    private Map<String, String> getRemoteEnvironment(IManagedProject project) {
        Map<String, String> remoteEnvMap;
        block9: {
            LinkedList command;
            IRemoteProcessBuilder processBuilder;
            IRemoteServices remoteServices;
            IRemoteExecutionServiceProvider executionProvider;
            block10: {
                IProject iProj = (IProject)project.getOwner();
                remoteEnvMap = new HashMap<String, String>();
                ServiceModelManager smm = ServiceModelManager.getInstance();
                try {
                    IServiceConfiguration serviceConfig = smm.getActiveConfiguration(iProj);
                    IService buildService = smm.getService("org.eclipse.ptp.rdt.core.BuildService");
                    IServiceProvider serviceProvider = serviceConfig.getServiceProvider(buildService);
                    executionProvider = null;
                    if (serviceProvider instanceof IRemoteExecutionServiceProvider) {
                        executionProvider = (IRemoteExecutionServiceProvider)serviceProvider;
                    }
                    if (executionProvider == null) break block9;
                    remoteServices = executionProvider.getRemoteServices();
                    if (remoteServices != null) break block10;
                    return null;
                }
                catch (ProjectNotConfiguredException projectNotConfiguredException) {}
            }
            IRemoteConnection connection = executionProvider.getConnection();
            if (connection == null) {
                return remoteEnvMap;
            }
            if (!connection.isOpen()) {
                try {
                    connection.open(null);
                }
                catch (RemoteConnectionException e) {
                    RDTLog.logError((Throwable)e);
                }
            }
            if ((processBuilder = remoteServices.getProcessBuilder(connection, command = new LinkedList())) != null) {
                remoteEnvMap = processBuilder.environment();
            }
        }
        return remoteEnvMap;
    }
}

